/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}
#include "gui.h"
#include "misc.h"
#include "../common/net_client_wrapper.h"
#include "us.h"

#include "um_obj.h"

/***************************************************************************
* Edit User Monitor entry
***************************************************************************/
tedit_um_entry::tedit_um_entry(void)
{
  monitor_mode = 0;
}

tedit_um_entry::~tedit_um_entry(void)
{
}

void tedit_um_entry::set_no_actives(int index)
{
  sprintf(str,"%d",curr_um->no_active);
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_last_act(int index)
{
  strcpy(str,na_label);
  if(monitor_mode)
  {
    if(curr_um->no_active > 0)
      str_hh_mm(curr_um->last_active,str);
  }
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_d_conns(int index)
{
  if(curr_um->flags.flag.type == TUM_TYPE_NIF)
    strcpy(str,na_label);
  else
    sprintf(str,"%d",curr_um->d_connections);
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_t_conns(int index)
{
  if(curr_um->flags.flag.type == TUM_TYPE_NIF)
    strcpy(str,na_label);
  else
    sprintf(str,"%d",curr_um->t_connections);
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_ttu(int index)
{
  str_hh_mm(curr_um->tt_used,str);
  strcat(str,curr_um->flags.flag.tt_graced ? "*" : "");
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_dtzl(int index)
{
  if(!curr_um->no_active || (curr_um->dt_zone_limit == -1))
    strcpy(str,na_label);
  else
    sprintf(str,"%d",curr_um->dt_zone_limit);
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_dtsl(int index)
{
  if(!curr_um->no_active || (curr_um->dt_zone_limit == -1))
    strcpy(str,na_label);
  else
    str_hh_mm(curr_um->dt_set_limit,str);
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_dtu(int index)
{
  str_hh_mm(curr_um->dt_used,str);
  strcat(str,curr_um->flags.flag.dt_graced ? "*" : "");
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_t_ul(int index)
{
  sprintf(str,"%.2f%c",
    rnd2meg64(curr_um->t_ul),
    curr_um->flags.flag.t_ul_graced ? '*' : ' ');
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_t_dl(int index)
{
  sprintf(str,"%.2f%c",
    rnd2meg64(curr_um->t_dl),
    curr_um->flags.flag.t_dl_graced ? '*' : ' ');
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_d_ul(int index)
{
  sprintf(str,"%.2f%c",
    rnd2meg64(curr_um->d_ul),
    curr_um->flags.flag.d_ul_graced ? '*' : ' ');
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::set_d_dl(int index)
{
  sprintf(str,"%.2f%c",
    rnd2meg64(curr_um->d_dl),
    curr_um->flags.flag.d_dl_graced ? '*' : ' ');
  um_select.ammend_str(index,27,str);
}

void tedit_um_entry::create_sub(void)
{
  um_select.append("No Active                |             ");
  um_select.append("Idle Time                |             ");
  um_select.append("Daily Connections        :             ");
  um_select.append("Total Connections        :             ");
  um_select.append("Total Time Used          :             ");
  um_select.append("Daily Time Login Zone    |             ");
  um_select.append("Daily Time Set Limit     |             ");
  um_select.append("Daily Time Used          :             ");
  um_select.append("Total Uploaded   (Mb)    :             ");
  um_select.append("Total Downloaded (Mb)    :             ");
  um_select.append("Daily Uploaded   (Mb)    :             ");
  um_select.append("Daily Downloaded (Mb)    :             ");

  set_no_actives(0);
  set_last_act(1);
  set_d_conns(2);
  set_t_conns(3);
  set_ttu(4);
  set_dtzl(5);
  set_dtsl(6);
  set_dtu(7);
  set_t_ul(8);
  set_t_dl(9);
  set_d_ul(10);
  set_d_dl(11);
}

void tedit_um_entry::create(tum *ump,char *hr,int y,int x)
{
  curr_um = ump;
  tdialog::create(hr,14,41,y,x,COLOR_PAIR(4) | A_BOLD);
  um_select.init(pos_y + 1,pos_x + 1,12,39,0);
  create_sub();
  tobj::create(this);
}

void tedit_um_entry::redraw(void)
{
  tdialog::redraw();
  attrset(COLOR_PAIR(5));
  um_select.redraw();
}

_UD_64 tedit_um_entry::get_net_vol(void)
{
  return (_UD_64)(um_select.get_float(27) * 0x100000);
}

void tedit_um_entry::run(void)
{
  while(running)
  {
    ch = getch();
    switch(ch)
    {
      case 'Q':
        running = 0;
        break;
      case KEY_UP:
        um_select.cursor_up();
        update();
        break;
      case KEY_DOWN:
        um_select.cursor_down();
        update();
        break;
      case 'E':
        switch(um_select.get_option())
        {
          case 4:
            curr_um->flags.flag.tt_graced ^= 1;
            set_ttu(4);
            goto do_redraw;

          case 7:
            curr_um->flags.flag.dt_graced ^= 1;
            set_dtu(7);
            goto do_redraw;

          case 8:
            curr_um->flags.flag.t_ul_graced ^= 1;
            set_t_ul(8);
            goto do_redraw;

          case 9:
            curr_um->flags.flag.t_dl_graced ^= 1;
            set_t_dl(9);
            goto do_redraw;

          case 10:
            curr_um->flags.flag.d_ul_graced ^= 1;
            set_d_ul(10);
            goto do_redraw;

          case 11:
            curr_um->flags.flag.d_dl_graced ^= 1;
            set_d_dl(11);
            goto do_redraw;

        }
        break;
      case 10:
        switch(um_select.get_option())
        {
          case 2: //d_conns
            curr_um->d_connections = um_select.get_integer(27);
            set_d_conns(2);
            goto do_redraw;

          case 3: //t_conns
            curr_um->t_connections = um_select.get_integer(27);
            set_t_conns(3);
            goto do_redraw;

          case 4: //ttu
            curr_um->tt_used = um_select.get_hr_min(27);
            range_check(&(curr_um->tt_used),0,999 * 60 * 60);
            set_ttu(4);
do_redraw:
            um_select.redraw();
            update();
            touched = 1;
            break;

          case 7: //dtu
            curr_um->dt_used = um_select.get_hr_min(27);
            range_check(&(curr_um->dt_used),0,24 * 60 * 60);
            set_dtu(7);
            goto do_redraw;

          case 8: //Total Uploaded
            curr_um->t_ul = get_net_vol();
            set_t_ul(8);
            goto do_redraw;

          case 9: //Total Downloaded
            curr_um->t_dl = get_net_vol();
            set_t_dl(9);
            goto do_redraw;

          case 10: //Daily Uploaded
            curr_um->d_ul = get_net_vol();
            set_d_ul(10);
            goto do_redraw;

          case 11: //Daily Downloaded
            curr_um->d_dl = get_net_vol();
            set_d_dl(11);
            goto do_redraw;

        }
        break;

    }
  }
}

/***************************************************************************
* Edit User Monitors
***************************************************************************/
void tedit_um::create(void)
{
  tdialog::create(
    "UM",
    19,STR_USER_LEN + 1 + 3,3,3,
    COLOR_PAIR(4) | A_BOLD);
  length = 17;
  notify_on(notify_label,pwait_mess);
  get_users(cmd_gumu);
  tobj::create(this);
}

void tedit_um::get_users2(void)
{
  notify_on(notify_label,pwait_mess);
  get_users(cmd_gumu);
  redraw();
  update();
  notify_off();
}

void tedit_um::select(void)
{
  char *user;

  notify_on(notify_label,pwait_mess);
  user_list->get_str(user_list->get_option(),0,&user);
  user++;
  if(net_lock_user(user) == CO_SUCCESSFUL)
  {
    tedit_um_entry edit_um_entry;

    if(net_get_um(user) == CO_SUCCESSFUL)
    {
      edit_um_entry.create(&um,"User Monitor",3,15);
      edit_um_entry.run();
      edit_um_entry.dest();
      notify_on(notify_label,pwait_mess);
      if(edit_um_entry.touched)
        net_put_um();
      get_users2();
      user_list->goto_user(user);
    }
    net_unlock_user();
  }
  notify_off();
}

void tedit_um::add_user(void)
{
  notify(notify_label,"Inapplicable command. No can do. Hit key key.");
}

void tedit_um::delete_user(void)
{
  char *user;
  int tmp_pos,tmp_hl;

  tmp_pos = user_list->pos;
  tmp_hl = user_list->hl;
  user_list->get_str(user_list->get_option(),0,&user);
  user++;
  notify_on(notify_label,pwait_mess);
  if(net_lock_user(user) == CO_SUCCESSFUL)
  {
    if(net_delete_um(user) == CO_SUCCESSFUL)
    {
      get_users(cmd_gumu);
      user_list->pos = tmp_pos;
      user_list->hl = tmp_hl;
      if(user_list->get_option() == user_list->list_size)
        user_list->cursor_up();
      redraw();
      update();
    }
    net_unlock_user();
  }
  notify_off();
}
