/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
*
****************************************************************************
****************************************************************************
***************************************************************************/
extern "C" {
#include <curses.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
}

#include "gui.h"
#include "misc.h"
#include "../common/net_client_wrapper.h"
#include "dt.h"

#include "us_obj.h"

/***************************************************************************
* List groups
***************************************************************************/
tus_groups::tus_groups(void)
{
  user = NULL;
}

void tus_groups::create(void)
{
  tdialog::create(
    "US Groups",
    19,STR_USER_LEN + 1 + 3,3,20,
    COLOR_PAIR(4) | A_BOLD);
  length = 17;
  notify_on(notify_label,pwait_mess);
  get_users(cmd_gusg);
  tobj::create(this);
}

void tus_groups::get_users2(void)
{
  notify_on(notify_label,pwait_mess);
  get_users(cmd_gusg);
  redraw();
  update();
  notify_off();
}

void tus_groups::select(void)
{
  user_list->get_str(user_list->get_option(),0,&user);
  running = 0;
}

void tus_groups::add_user(void)
{
}

void tus_groups::delete_user(void)
{
}

/***************************************************************************
* Edit def User Settings
***************************************************************************/
tedit_def_us::tedit_def_us(void)
{
}

tedit_def_us::~tedit_def_us(void)
{
}

void tedit_def_us::set_rec_type(int index)
{
  switch(curr_us->flags.flag.record_type)
  {
    case TUS_RECORD_TYPE_NORMAL:
      us_select.ammend_str(index,27,normal_label);
      break;
    case TUS_RECORD_TYPE_GROUP:
      us_select.ammend_str(index,27,"Group");
      break;
    case TUS_RECORD_TYPE_LINK:
      us_select.ammend_str(index,27,"Link");
      break;
    case TUS_RECORD_TYPE_UNION:
      us_select.ammend_str(index,27,"Union");
      break;
    case TUS_RECORD_TYPE_EFFECTIVE:
      us_select.ammend_str(index,27,"Effective");
      break;
    default:
      us_select.ammend_str(index,27,unknown_label);
      break;
  }
}

void tedit_def_us::set_email_link(int index)
{
  switch(curr_us->flags.flag.record_type)
  {
    case TUS_RECORD_TYPE_GROUP:
      us_select.ammend_str(index,0,"Email Host               : ");
      break;
    case TUS_RECORD_TYPE_LINK:
    case TUS_RECORD_TYPE_UNION:
      us_select.ammend_str(index,0,"Link                     : ");
      break;
    default:
      us_select.ammend_str(index,0,"Email Host/Address       : ");
      break;
  }

  if((curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK) ||
     (curr_us->flags.flag.record_type == TUS_RECORD_TYPE_UNION))
  {
    us_select.ammend_str(index,27,curr_us->ident.link);
  }
  else
  {
    sprintf(str,"%s",curr_us->ident.email);
    if(strlen(str) > 32) str[32] = '+';  
    str[33] = 0;
    us_select.ammend_str(index,27,str);
  }
}

void tedit_def_us::set_tt(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_total_time)
      us_select.ammend_str(index,27,exempt_label);
    else
    {
      str_hh_mm(curr_us->tt_lim,str);
      us_select.ammend_str(index,27,str);
    }
}

void tedit_def_us::set_dt(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_daily_time)
      us_select.ammend_str(index,27,exempt_label);
    else
      us_select.ammend_str(index,27,"");
}

void tedit_def_us::set_expiry_date(int index) //dd:mm:yyyy
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_expiry_date)
      us_select.ammend_str(index,27,exempt_label);
    else
    {
      compose_date(&(curr_us->expiry_date),str);
      us_select.ammend_str(index,27,str);
    }
}

void tedit_def_us::set_niceness(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_nice)
      us_select.ammend_str(index,27,exempt_label);
    else
    {
      sprintf(str,"%d",curr_us->nice_factor);
      us_select.ammend_str(index,27,str);
    }
}

void tedit_def_us::set_tul(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_total_ul_lim)
      us_select.ammend_str(index,27,exempt_label);
    else
    {
      sprintf(str,"%d",curr_us->t_ul_lim);
      us_select.ammend_str(index,27,str);
    }
}

void tedit_def_us::set_tdl(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_total_dl_lim)
      us_select.ammend_str(index,27,exempt_label);
    else
    {
      sprintf(str,"%d",curr_us->t_dl_lim);
      us_select.ammend_str(index,27,str);
    }
}

void tedit_def_us::set_dul(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_daily_ul_lim)
      us_select.ammend_str(index,27,exempt_label);
    else
    {
      sprintf(str,"%d",curr_us->d_ul_lim);
      us_select.ammend_str(index,27,str);
    }
}

void tedit_def_us::set_ddl(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_daily_dl_lim)
      us_select.ammend_str(index,27,exempt_label);
    else
    {
      sprintf(str,"%d",curr_us->d_dl_lim);
      us_select.ammend_str(index,27,str);
    }
}

void tedit_def_us::set_purge_dt(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    us_select.ammend_str(index,27,
      curr_us->flags.flag.instant_purge_dt ? yes_label : no_label);
}

void tedit_def_us::set_clob_mult_logins(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    us_select.ammend_str(index,27,
      curr_us->flags.flag.clobber_mult_logins ? yes_label : no_label);
}

void tedit_def_us::set_banned(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    us_select.ammend_str(index,27,
      curr_us->flags.flag.banned ? yes_label : no_label);
}

void tedit_def_us::set_act_to(int index)
{
  if(curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK)
    us_select.ammend_str(index,27,na_label);
  else
    if(curr_us->flags.flag.exempt_act_timeout)
      us_select.ammend_str(index,27,exempt_label);
    else
    {   
      str_hh_mm(curr_us->act_timeout,str);
      us_select.ammend_str(index,27,str);
    }
}

void tedit_def_us::set_email_type(int index)
{
  switch(curr_us->flags.flag.email_type)
  {
    case TUS_EMAIL_TYPE_NORMAL:
      us_select.ammend_str(index,27,normal_label);
      break;
    case TUS_EMAIL_TYPE_CC_ROOT:
      us_select.ammend_str(index,27,"CC to root");
      break;
    case TUS_EMAIL_TYPE_NONE:
      us_select.ammend_str(index,27,none_label);
      break;
  }
}

void tedit_def_us::set_flash_method(int index)
{
  sprintf(str,"%d %s",
    curr_us->flags.flag.flash_method,
    curr_us->flags.flag.flash_method == 0 ? "(none)" : "");
  us_select.ammend_str(index,27,str);
}

void tedit_def_us::create(tus *usp,char *hr,int y,int x)
{
  curr_us = usp;
  tdialog::create(hr,18,62,y,x,COLOR_PAIR(4) | A_BOLD);
  us_select.init(pos_y + 1,pos_x + 1,16,60,0);

  us_select.append("Record Type              :           ");
  us_select.append(
    "Email Host/Address/Link  : xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
  us_select.append("Total Time Limit (hhh:mm):           ");
  us_select.append("Daily Time Limits        >           ");
  us_select.append("Expiry Date (dd:mm:yyyy) : dd:mm:yyyy");
  us_select.append("Niceness                 : dddddddddd");
  us_select.append("Total Upload Limit   (Mb): dddddddddd");
  us_select.append("Total Download Limit (Mb): dddddddddd");
  us_select.append("Daily Upload Limit   (Mb): dddddddddd");
  us_select.append("Daily Download Limit (Mb): dddddddddd");
  us_select.append("Reset DT after Clobber   : xxx");
  us_select.append("Clobber multiple Dialins : xxx");
  us_select.append("Permanently Ban User     : xxx");
  us_select.append("Activity Timeout (hhh:mm):           ");
  us_select.append("Email Type               :           ");
  us_select.append("Flash Method             :           ");

  set_rec_type(0);
  set_email_link(1);
  set_tt(2);
  set_dt(3);
  set_expiry_date(4);
  set_niceness(5);
  set_tul(6);
  set_tdl(7);
  set_dul(8);
  set_ddl(9);
  set_purge_dt(10);
  set_clob_mult_logins(11);
  set_banned(12);
  set_act_to(13);
  set_email_type(14);
  set_flash_method(15);

  tobj::create(this);
}

void tedit_def_us::redraw(void)
{
  tdialog::redraw();
  attrset(COLOR_PAIR(5));
  us_select.redraw();
}

void tedit_def_us::open_dt(void)
{
  if(!curr_us->flags.flag.exempt_daily_time)
  {
    tedit_dt edit_dt;

    edit_dt.create(curr_us->dt_lim);
    edit_dt.run();
    edit_dt.dest();
    if(edit_dt.touched)
      touched = 1;
  }
}

void tedit_def_us::run_selections(void)
{
  switch(us_select.get_option())
  {
    case 0: // record type
      if(curr_us == &(us_hr.default_us))
        return;
      touched = 1;
      curr_us->flags.flag.record_type++;
      if(curr_us->flags.flag.record_type > TUS_RECORD_TYPE_SIZE)
        curr_us->flags.flag.record_type = 0;
      set_rec_type(0);
      set_email_link(1);
      set_tt(2);
      set_dt(3);
      set_expiry_date(4);
      set_niceness(5);
      set_tul(6);
      set_tdl(7);
      set_dul(8);
      set_ddl(9);
      set_purge_dt(10);
      set_clob_mult_logins(11);
      set_banned(12);
      set_act_to(13);
      goto do_redraw;

    case 1: // edit email/link
      if((curr_us->flags.flag.record_type == TUS_RECORD_TYPE_LINK) ||
         (curr_us->flags.flag.record_type == TUS_RECORD_TYPE_UNION))
      {
        tus_groups us_groups;

        us_groups.create();
        us_groups.run();
        if(us_groups.user != NULL)
        {
          touched = 1;
          strcpy(curr_us->ident.link,us_groups.user + 1);
        }
        us_groups.dest();
        set_email_link(1);
        goto do_redraw;
      }
      else
      {
        touched = 1;
        us_select.get_string(curr_us->ident.email,27,STR_EMAIL,33);
        set_email_link(1);
do_redraw:
        us_select.redraw();
        update();
      }
      break;

    case 2: // get total time
      if(!curr_us->flags.flag.exempt_total_time)
      {
        touched = 1;
        curr_us->tt_lim = us_select.get_hr_min(27);
        range_check(&(curr_us->tt_lim),0,999 * 60 * 60);
        set_tt(2);
        goto do_redraw;
      }
      break;

    case 3: // Daily Time Limits
      open_dt();
      break;

    case 4: // Get Expiry Date
      if(!curr_us->flags.flag.exempt_expiry_date)
      {
        int x,y;

        touched = 1;
        str[0] = 0;
        us_select.get_string(str,27,10,10);
        sscanf(str,"%d:%d:%d",&x,&y,&(curr_us->expiry_date.year));
        range_check(&x,1,31);
        range_check(&y,1,12);
        range_check(&(curr_us->expiry_date.year),1970,9999);
        curr_us->expiry_date.day = (char)x;
        curr_us->expiry_date.month = (char)y;
        set_expiry_date(4);
        goto do_redraw;
      }
      break;

    case 5: // Get niceness
      if(!curr_us->flags.flag.exempt_nice)
      {
        touched = 1;
        curr_us->nice_factor = us_select.get_integer(27);
        range_check(&(curr_us->nice_factor),-20,20);
        set_niceness(5);
        goto do_redraw;
      }
      break;

    case 6: // tul
      if(!curr_us->flags.flag.exempt_total_ul_lim)
      {
        touched = 1;
        curr_us->t_ul_lim = us_select.get_integer(27);
        set_tul(6);
        goto do_redraw;
      }
      break;

    case 7: // tdl
      if(!curr_us->flags.flag.exempt_total_dl_lim)
      {
        touched = 1;
        curr_us->t_dl_lim = us_select.get_integer(27);
        set_tdl(7);
        goto do_redraw;
      }
      break;

    case 8: // dul
      if(!curr_us->flags.flag.exempt_daily_ul_lim)
      {
        touched = 1;
        curr_us->d_ul_lim = us_select.get_integer(27);
        set_dul(8);
        goto do_redraw;
      }
      break;

    case 9: // ddl
      if(!curr_us->flags.flag.exempt_daily_dl_lim)
      {
        touched = 1;
        curr_us->d_dl_lim = us_select.get_integer(27);
        set_ddl(9);
        goto do_redraw;
      }
      break;

    case 10: // toggle purge td on clobber
      touched = 1;
      curr_us->flags.flag.instant_purge_dt ^= 1;
      set_purge_dt(10);
      goto do_redraw;

    case 11: // toggle clob mult logins
      touched = 1;
      curr_us->flags.flag.clobber_mult_logins ^= 1;
      set_clob_mult_logins(11);
      goto do_redraw;

    case 12: //toggle clobber flag
      touched = 1;
      curr_us->flags.flag.banned ^= 1;
      set_banned(12);
      goto do_redraw;

    case 13:
      if(!curr_us->flags.flag.exempt_act_timeout)
      {
        touched = 1;
        curr_us->act_timeout = us_select.get_hr_min(27);
        range_check(&(curr_us->act_timeout),0,999 * 60 * 60);
        set_act_to(13);
        goto do_redraw;
      }
      break;

    case 14:
      touched = 1;
      if(curr_us->flags.flag.email_type == TUS_EMAIL_TYPE_SIZE)
        curr_us->flags.flag.email_type = 0;
      else
        curr_us->flags.flag.email_type++;
      set_email_type(14);
      goto do_redraw;

    case 15:
      {
        int x;

        touched = 1;
        x = us_select.get_integer(27);
        range_check(&x,0,15);
        curr_us->flags.flag.flash_method = x;
        set_flash_method(15);
        goto do_redraw;
      }

  }
}

void tedit_def_us::toggle_exemptions(void)
{
  touched = 1;
  switch(us_select.get_option())
  {

    case 2:
      curr_us->flags.flag.exempt_total_time ^= 1;
      set_tt(2);
      goto do_redraw;

    case 3:
      curr_us->flags.flag.exempt_daily_time ^= 1;
      set_dt(3);
      goto do_redraw;

    case 4:
      curr_us->flags.flag.exempt_expiry_date ^= 1;
      set_expiry_date(4);
      goto do_redraw;

    case 5:
      curr_us->flags.flag.exempt_nice ^= 1;
      set_niceness(5);
      goto do_redraw;

    case 6:
      curr_us->flags.flag.exempt_total_ul_lim ^= 1;
      set_tul(6);
      goto do_redraw;

    case 7:
      curr_us->flags.flag.exempt_total_dl_lim ^= 1;
      set_tdl(7);
      goto do_redraw;

    case 8:
      curr_us->flags.flag.exempt_daily_ul_lim ^= 1;
      set_dul(8);
      goto do_redraw;

    case 9:
      curr_us->flags.flag.exempt_daily_dl_lim ^= 1;
      set_ddl(9);
do_redraw:
      us_select.redraw();
      update();
      break;

    case 13:
      curr_us->flags.flag.exempt_act_timeout ^= 1;
      set_act_to(13);
      goto do_redraw;
  }
}

void tedit_def_us::run(void)
{
  while(running)
  {
    ch = getch();
    switch(ch)
    {
      case 'Q':
        running = 0;
        break;
      case KEY_UP:
        us_select.cursor_up();
        update();
        break;
      case KEY_DOWN:
        us_select.cursor_down();
        update();
        break;
      case 'E':
        toggle_exemptions();
        break;
      case 10:
        run_selections();
        break;
    }
  }
}

/***************************************************************************
* Edit User Settings
***************************************************************************/
tedit_us::tedit_us(void)
{
  user_list = NULL;
}

tedit_us::~tedit_us(void)
{
  if(user_list != NULL)
    delete(user_list);
}

void tedit_us::get_users(char *cmd)
{
  if(user_list != NULL) //this is here so list can be reloaded
    delete(user_list);
  user_list = new(tscroll_select);
  if(user_list == NULL)
    fatal_memory_error_gui();

  user_list->init(pos_y + 1,pos_x + 1,length,STR_USER_LEN + 1,1);
  net_put_cmd(cmd);
  for(;;)
  {
    char str[STR_LEN_LN + 1];
    int status;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
      break;
    if(str[0] == ':')
      user_list->append(str + 1);
  }
}

void tedit_us::create(void)
{
  tdialog::create(
    "US",
    19,STR_USER_LEN + 1 + 3,3,3,
    COLOR_PAIR(4) | A_BOLD);
  length = 17;
  notify_on(notify_label,pwait_mess);
  get_users(cmd_gusu);
  tobj::create(this);
}

void tedit_us::redraw(void)
{
  tdialog::redraw();
  attrset(COLOR_PAIR(5));
  user_list->redraw();
}

void tedit_us::get_users2(void)
{
  notify_on(notify_label,pwait_mess);
  get_users(cmd_gusu);
  redraw();
  update();
  notify_off();
}

void tedit_us::select(void)
{
  char *user;

  notify_on(notify_label,pwait_mess);
  user_list->get_str(user_list->get_option(),0,&user);
  user++;
  if(net_lock_user(user) == CO_SUCCESSFUL)
  {
    tedit_def_us edit_us_entry;

    if(net_get_us(user,0) == CO_SUCCESSFUL)
    {
      edit_us_entry.create(&us,"User Settings",3,10);
      edit_us_entry.run();
      edit_us_entry.dest();
      notify_on(notify_label,pwait_mess);
      if(edit_us_entry.touched)
        net_put_us();
      get_users2();
      user_list->goto_user(user);
    }
    net_unlock_user();
  }
  notify_off();
}

int tedit_us::valid_username(char *name)
{
  register unsigned int x;

  if(name[0] == 0)
    return 0;
  for(x = 0;x < strlen(name);x++)
  {
    if((name[x] <= ' ') || (name[x] >= 127))
      return 0;
  }
  return 1;
}

void tedit_us::add_user(void)
{
  tstrbox strbox;
  tedit_def_us edit_us;
  char user[STR_USER_LEN + 1] = "";

  strbox.create("New User",
    3,STR_USER_LEN,pos_y + 1,pos_x + 2,STR_USER_LEN);
  strbox.run(user);
  strbox.dest();
  if(!valid_username(user))
  {
    notify(error_label,"Bad Username.");
    return;
  }
  notify_on(notify_label,pwait_mess);
  if(net_lock_user(user) == CO_SUCCESSFUL)
  {
    if(net_new_us(user) == CO_SUCCESSFUL)
    {
      if(net_get_us_hr() == CO_SUCCESSFUL)
      {
        if(us_hr.flags.flag.default_us_enabled)
          memcpy(&us,&(us_hr.default_us),sizeof(tus));
        else
          us_clr(&us);
        strcpy(us.user,user);
        edit_us.create(&us,"User Settings",3,15);
        edit_us.run();
        edit_us.dest();
        notify_on(notify_label,pwait_mess);
        if(net_put_us() == CO_SUCCESSFUL)
        {
          get_users(cmd_gusu);
          user_list->goto_user(user);
          redraw();
          update();
        }
      }
    }
    net_unlock_user();
  }
  notify_off();
}

void tedit_us::delete_user(void)
{
  char *user;
  int tmp_pos,tmp_hl;

  tmp_pos = user_list->pos;
  tmp_hl = user_list->hl;
  user_list->get_str(user_list->get_option(),0,&user);
  user++;
  notify_on(notify_label,pwait_mess);
  if(net_lock_user(user) == CO_SUCCESSFUL)
  {
    if(net_delete_us(user) == CO_SUCCESSFUL)
    {
      get_users(cmd_gusu);
      user_list->pos = tmp_pos;
      user_list->hl = tmp_hl;
      if(user_list->get_option() == user_list->list_size)
        user_list->cursor_up();
      redraw();
      update();
    }
    net_unlock_user();
  }
  notify_off();
}

void tedit_us::user_search(void)
{
  tstrbox u_search;
  char user[STR_USER_LEN + 1] = "";

  u_search.create("Find User",
    3,STR_USER_LEN,pos_y + 1,pos_x + 2,STR_USER_LEN);
  u_search.run(user);
  u_search.dest();
  user_list->goto_user(user);
  update();
}

void tedit_us::run(void)
{
  while(running)
  {
    ch = getch();

    switch(ch)
    {
      case 'Q':
        running = 0;
        break;
      case ' ':
        get_users2();
        break;
      case 'A':
        add_user();
        break;
      default:
        if(user_list->list_size)
          switch(ch)
          {
            case KEY_UP:
              user_list->cursor_up();
              update();
              break;
            case KEY_DOWN:
              user_list->cursor_down();
              update();
              break;
            case PAGE_UP:
              user_list->page_up();
              update();
              break;
            case PAGE_DOWN:
              user_list->page_down();
              update();
              break;
            case 10:
              select();
              break;
            case 'D':
              delete_user();
              break;
            case 'S':
              user_search();
              break;
          }
        break;
    }
  }
}
