/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* common functions used through the dist by the daemon, and the clients.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include "defs.h"

char  *notify_label = "Notify";
char  *warning_label = "Warning";
char  *error_label = "Error";
char  *yes_label = "Yes";
char  *no_label  = "No";
char  *unknown_label = "UNKNOWN";
char  *exempt_label = "Exempt";
char  *na_label = "n/a";
char  *verbose_label = "Verbose";
char  *normal_label = "Normal";
char  *none_label = "None";
char  *daemon_started_mess = "--Daemon Started----";
char  *daemon_ended_mess = "--Daemon ended------";
char  *dt_table[] = {"Mon","Tue","Wed","Thu","Fri","Sat","Sun"};
char  *tm_table[] = {"00","01","02","03","04","05",
                     "06","07","08","09","10","11",
                     "12","13","14","15","16","17",
                     "18","19","20","21","22","23"};
char  *term_type[] =
{
  "Unknown",
  "Shell Login",
  "PPPD Login",
  "PPPD PAP",
  "PPP Unknown",
  "NIF"
};

/*cmd codes*/
char *cmd__ok    = ";ok";    /*obsolete 4.11+. here for backward comptab.*/
char *cmd_ret    = ";ret";   /*returns status  ";ret <code>"*/

char *cmd_ver    = ";ver";   /*version handshake*/
char *cmd_quit   = ";quit";
char *cmd_pass   = ";pass";  /*send password*/
char *cmd_stat   = ";stat";  /*list connection stats*/

char *cmd_gushr  = ";gushr"; /*get us_hr*/
char *cmd_sushr  = ";sushr"; /*set us_hr*/
char *cmd_lushr  = ";lushr"; /*lock us_hr*/
char *cmd_uushr  = ";uushr"; /*unlock us_hr*/

char *cmd_gusu   = ";gusu";  /*get (list) us users*/
char *cmd_gus    = ";gus";   /*get actual us*/
char *cmd_gus2   = ";gus2";  /*get effective us*/
char *cmd_sus    = ";sus";   /*set us entry*/
char *cmd_nus    = ";nus";   /*init for new us entry*/
char *cmd_dus    = ";dus";   /*delete us entry*/

char *cmd_gusg   = ";gusg";   /*get us groups*/
char *cmd_gusug  = ";gusug";  /*get (list) us users in a group*/

char *cmd_gumu   = ";gumu";  /*get (list) um users*/
char *cmd_gum    = ";gum";   /*get actual um entry*/
char *cmd_sum    = ";sum";   /*set um entry*/
char *cmd_dum    = ";dum";   /*delete um entry*/

char *cmd_luser  = ";luser"; /*lock user*/
char *cmd_uuser  = ";uuser"; /*unlock user*/

char *cmd_stime  = ";stime"; /*get sleep time*/

char *cmd_tpurg  = ";tpurg"; /*request total purge*/
char *cmd_dpurg  = ";dpurg"; /*request daily purge*/

char *cmd_die    = ";die";   /*shutdown daemon*/

char *cmd_save   = ";save";  /*force save*/

char *cmd_gtinf  = ";gtinf"; /*get tinfo entry*/

char *cmd_gstat  = ";gstat"; /*general statistics*/

char *cmd_ul_ttu = ";ulttu"; /*User List (Total Time Used)*/
char *cmd_ul_tnv = ";ultnv"; /*User List (Total Network Volume)*/
char *cmd_ul_cef = ";ulcef"; /*User List (Connection Efficiency)*/

char *cmd_arch   = ";arch";  /*archive runs VAR_PATH/archive.sh*/

/*struct tokens*/
#define CMD_DT_SIZE 7

/*
 *TCP transmission data tokens
 */

/*us hr*/
char *dtushr_flags                      = ":hFlags";
char *dtushr_root_email                 = ":hRootE";
char *dtushr_sleep_time                 = ":hSleep";
char *dtushr_grace_time                 = ":hGTime";
char *dtushr_grace_volume               = ":hGVolm";
char *dtushr_save_time                  = ":hSaveT";
char *dtushr_min_free_dialins           = ":hMinDn";

/*us*/
char *dtus_flags                        = ":sFlags";
char *dtus_user                         = ":sUserN";
char *dtus_email                        = ":sEmail";
char *dtus_tt_lim                       = ":sTtLim";
char *dtus_dt_lim                       = ":sDtLim";
char *dtus_expiry_date                  = ":sEDate";
char *dtus_nice_factor                  = ":sNiceF";
char *dtus_t_ul_lim                     = ":sT_ULL";
char *dtus_t_dl_lim                     = ":sT_DLL";
char *dtus_d_ul_lim                     = ":sD_ULL";
char *dtus_d_dl_lim                     = ":sD_DLL";
char *dtus_act_timeout                  = ":sACTTO";

/*um*/
char *dtum_flags                        = ":mFlags";
char *dtum_user                         = ":mUserN";
char *dtum_no_active                    = ":mNActv";
char *dtum_d_connections                = ":mDConn";
char *dtum_t_connections                = ":mTConn";
char *dtum_tt_used                      = ":mTTusd";
char *dtum_dt_used                      = ":mDTusd";
char *dtum_t_ul                         = ":mT_ULs";
char *dtum_t_dl                         = ":mT_DLs";
char *dtum_d_ul                         = ":mD_ULs";
char *dtum_d_dl                         = ":mD_DLs";
char *dtum_last_active                  = ":mLastA";
char *dtum_dt_zone_limit                = ":mDTZon";
char *dtum_dt_set_limit                 = ":mDTslm";

/*tinfo ll*/
char *dttinfo_flags                     = ":tFlags";
char *dttinfo_pid                       = ":t__PID";
char *dttinfo_tty                       = ":t__TTY";
char *dttinfo_nif                       = ":tNetIf";
char *dttinfo_t_used                    = ":tTUsed";
char *dttinfo_ul                        = ":tNetUL";
char *dttinfo_dl                        = ":tNetDL";
char *dttinfo_last_active               = ":tLastA";

/*tgstat*/
char *dttgstat_mem_used                 = ":gMemUd";
char *dttgstat_total_users              = ":gTUser";
char *dttgstat_no_active                = ":gNoAct";
char *dttgstat_no_kons                  = ":gNoKon";
char *dttgstat_no_free_dialins          = ":gFreeD";
char *dttgstat_d_connections            = ":gDConn";
char *dttgstat_t_connections            = ":gTConn";
char *dttgstat_d_traffic                = ":gDTraf";
char *dttgstat_t_traffic                = ":gTTraf";
char *dttgstat_avg_d_connections        = ":gADCon";
char *dttgstat_avg_t_connections        = ":gATCon";
char *dttgstat_avg_s_time               = ":gAvSTm";
char *dttgstat_avg_d_time               = ":gAvDTm";
char *dttgstat_avg_t_time               = ":gAvTTm";
char *dttgstat_avg_s_traffic            = ":gAvSTr";
char *dttgstat_avg_d_traffic            = ":gAvDTr";
char *dttgstat_avg_t_traffic            = ":gAvTTr";
char *dttgstat_hour_tally               = ":gHrTly";

/***************************************************************************
* memory error callback routines
***************************************************************************/
void default_memory_error_cb(void)
{
  exit(-1);
}

void (*memory_error_cb)(void) = default_memory_error_cb;

/***************************************************************************
* configuration file parsing routines
***************************************************************************/
int freadln(FILE *fp,char *str)
{
  str[0] = 0;
  fgets(str,STR_LEN,fp);
  if((str[0] != '#') && (str[0] >= 32)) return 1;
  return 0;
}

int get_param(char *d_str,char *s_str,char *key,int max)
{
  char tok[STR_LEN + 1],param[STR_LEN + 1];

  sscanf(s_str,"%s %s",tok,param);
  if(!strcmp(tok,key))
  {
    char *s;

    s = strstr(s_str + strlen(tok),param);
    if(s != NULL) strncpy(d_str,s,max);
    d_str[max] = 0;
    s = strchr(d_str,'\n');
    if(s != NULL) *s = 0;
    s = strchr(d_str,'\r');
    if(s != NULL) *s = 0;
    return 1;
  }
  return 0;
}

/***************************************************************************
*
***************************************************************************/
void str_mm_ss(int t,char *s)
{
  if(t < 0)
    t = 0;
  sprintf(s,"%d:%02d",(int)(t / 60),(int)(t % 60));
}

void str_hh_mm(int t,char *s)
{
  if(t < 0)
    t = 0;
  if((t % 60) < 30)
    t /= 60;
  else
  {
    t /= 60;
    t++;
  }
  sprintf(s,"%d:%02d",(int)(t / 60),(int)(t % 60));
}

void range_check(int *val,int lim1,int lim2)
{
  if(*val < lim1)
    *val = lim1;
  if(*val > lim2)
    *val = lim2;
}

void compose_date(tdate_st *d,char *str)
{
  sprintf(str,"%02d:%02d:%04d",d->day,d->month,d->year);
}

double rnd2meg(int val)
{
  double d;
  register int m;
  
  d = val / 0x100000;  
  m = val % 0x100000;
  d += ((double)m / 0x100000);
  return d;
}

double rnd2meg64(_UD_64 val)
{
  double d;
  register int m;

  d = val / 0x100000;
  m = val % 0x100000;
  d += ((double)m / 0x100000);
  return d;
}

/***************************************************************************
*
***************************************************************************/
void close_socket(int s)
{
  shutdown(s,2);
  close(s);
}

/***************************************************************************
****************************************************************************
*
* universal packet coder/decoder code
*
****************************************************************************
***************************************************************************/

/***************************************************************************
*
***************************************************************************/
void decomp_str(char *dest,char *src,int max_len)
{
  char *p;

  strncpy(dest,src + CMD_DT_SIZE + 1,max_len);
  dest[max_len] = 0;
  p = strchr(dest,'\n');
  if(p != NULL)
    *p = 0;
}

void comp_64b(char *cmd,_UD_64 val,char *buf)
{
  char str[STR_LEN_LN + 1];
  register unsigned int ms,ls;

  ms = val >> 32;
  ls = val & 0xffffffff;
  sprintf(str,"%s %x %x\n",cmd,ms,ls);
  strcat(buf,str);
}

void decomp_64b(_UD_64 *val,char *dst)
{
  unsigned int ms,ls;

  sscanf(dst,"%*s %x %x",&ms,&ls);
  *val = ((_UD_64)ms << 32) + (_UD_64)ls;
}

/***************************************************************************
* ttinfo packer/unpacker
***************************************************************************/
void comp_net_tinfo(ttinfo *p,char *buf)
{
  char str[STR_LEN_LN + 1]; 

  sprintf(str,"%s %x\n",dttinfo_flags,p->flags.all);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttinfo_pid,p->pid);
  strcat(buf,str);

  sprintf(str,"%s %s\n",dttinfo_tty,p->tty);
  strcat(buf,str);

  sprintf(str,"%s %s\n",dttinfo_nif,p->nif);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttinfo_t_used,p->t_used);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttinfo_ul,p->ul);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttinfo_dl,p->dl);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttinfo_last_active,p->last_active);
  strcat(buf,str);
}

void decomp_net_tinfo(ttinfo *p,char *ins)
{
  if(ins[0] != ':')
    return;

  if(!strncmp(ins,dttinfo_flags,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->flags.all));
    return;
  }

  if(!strncmp(ins,dttinfo_pid,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->pid));
    return;
  }

  if(!strncmp(ins,dttinfo_tty,CMD_DT_SIZE))
  {
    decomp_str(p->tty,ins,STR_TTY_LEN);
    return;
  }

  if(!strncmp(ins,dttinfo_nif,CMD_DT_SIZE))
  {
    decomp_str(p->nif,ins,STR_SMALL);
    return;
  }

  if(!strncmp(ins,dttinfo_t_used,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->t_used));
    return;
  }

  if(!strncmp(ins,dttinfo_ul,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->ul));
    return;
  }

  if(!strncmp(ins,dttinfo_dl,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->dl));
    return;
  }

  if(!strncmp(ins,dttinfo_last_active,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->last_active));
    return;
  }
}

/***************************************************************************
* tus & tus_hr packer/unpacker
***************************************************************************/

/********************************
*
*********************************/
void comp_net_us(tus *p,char *buf)
{
  char str[STR_LEN_LN + 1];
  register int x;

  sprintf(str,"%s %x\n",dtus_flags,p->flags.all);
  strcat(buf,str);

  sprintf(str,"%s %s\n",dtus_user,p->user);
  strcat(buf,str);

  sprintf(str,"%s %s\n",dtus_email,p->ident.email);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtus_tt_lim,p->tt_lim);
  strcat(buf,str);

  for(x = 0;x < DT_LIM_SIZE;x++)
  {
    sprintf(str,"%s %d %x %x %x %x %x\n",
      dtus_dt_lim,
      x,
      p->dt_lim[x].d_fr,
      p->dt_lim[x].d_to,
      p->dt_lim[x].t_fr,
      p->dt_lim[x].t_to,
      p->dt_lim[x].limit);
    strcat(buf,str);
  }

  sprintf(str,"%s %x %x %x\n",
    dtus_expiry_date,
    p->expiry_date.day,
    p->expiry_date.month,
    p->expiry_date.year);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtus_nice_factor,p->nice_factor);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtus_t_ul_lim,p->t_ul_lim);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtus_t_dl_lim,p->t_dl_lim);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtus_d_ul_lim,p->d_ul_lim);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtus_d_dl_lim,p->d_dl_lim);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtus_act_timeout,p->act_timeout);
  strcat(buf,str);
}

void comp_net_us_hr(tus_hr *p,char *buf)
{
  char str[STR_LEN_LN + 1];

  sprintf(str,"%s %x\n",dtushr_flags,p->flags.all);
  strcat(buf,str);

  sprintf(str,"%s %s\n",dtushr_root_email,p->root_email);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtushr_sleep_time,p->sleep_time);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtushr_grace_time,p->grace_time);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtushr_grace_volume,p->grace_volume);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtushr_save_time,p->save_time);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtushr_min_free_dialins,p->min_free_dialins);
  strcat(buf,str);

  comp_net_us(&(p->default_us),buf);
}

/********************************
*
*********************************/
void decomp_net_us(tus *p,char *ins)
{
  if(ins[0] != ':')
    return;

  if(!strncmp(ins,dtus_flags,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->flags.all));
    return;
  }

  if(!strncmp(ins,dtus_user,CMD_DT_SIZE))
  {
    decomp_str(p->user,ins,STR_USER_LEN);
    return;
  }

  if(!strncmp(ins,dtus_email,CMD_DT_SIZE))
  {
    decomp_str(p->ident.email,ins,STR_EMAIL);
    return;
  }

  if(!strncmp(ins,dtus_tt_lim,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->tt_lim));
    return;
  }

  if(!strncmp(ins,dtus_dt_lim,CMD_DT_SIZE))
  {
    int x,a,b,c,d,e;

    sscanf(ins,"%*s %d %x %x %x %x %x",
              &x,&a,&b,&c,&d,&e);
    if(x >= DT_LIM_SIZE)
      return;
    if(x == 0)
    {
      register int i;

      for(i = 1;i < DT_LIM_SIZE;i++)
        p->dt_lim[i].limit = -1;
    }
    p->dt_lim[x].d_fr  = a;
    p->dt_lim[x].d_to  = b;
    p->dt_lim[x].t_fr  = c;
    p->dt_lim[x].t_to  = d;
    p->dt_lim[x].limit = e;
    return;
  }

  if(!strncmp(ins,dtus_expiry_date,CMD_DT_SIZE))
  {
    int a,b;

    sscanf(ins,"%*s %x %x %x",&a,&b,&(p->expiry_date.year));
    p->expiry_date.day = a;
    p->expiry_date.month = b;
    return;
  }

  if(!strncmp(ins,dtus_nice_factor,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->nice_factor));
    return;
  }

  if(!strncmp(ins,dtus_t_ul_lim,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->t_ul_lim));
    return;
  }

  if(!strncmp(ins,dtus_t_dl_lim,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->t_dl_lim));
    return;
  }

  if(!strncmp(ins,dtus_d_ul_lim,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->d_ul_lim));
    return;
  }

  if(!strncmp(ins,dtus_d_dl_lim,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->d_dl_lim));
    return;
  }

  if(!strncmp(ins,dtus_act_timeout,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->act_timeout));
    return;
  }
}

void decomp_net_us_hr(tus_hr *p,char *ins)
{
  if(ins[0] != ':')
    return;

  if(!strncmp(ins,dtushr_flags,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->flags.all));
    return;
  }

  if(!strncmp(ins,dtushr_root_email,CMD_DT_SIZE))
  {
    decomp_str(p->root_email,ins,STR_EMAIL);
    return;
  }

  if(!strncmp(ins,dtushr_sleep_time,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->sleep_time));
    return;
  }

  if(!strncmp(ins,dtushr_grace_time,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->grace_time));
    return;
  }

  if(!strncmp(ins,dtushr_grace_volume,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->grace_volume));
    return;
  }

  if(!strncmp(ins,dtushr_save_time,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->save_time));
    return;
  }

  if(!strncmp(ins,dtushr_min_free_dialins,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->min_free_dialins));
    return;
  }

  decomp_net_us(&(p->default_us),ins);
}

/***************************************************************************
* um packer/unpacker
***************************************************************************/

/********************************
*
*********************************/
void comp_net_um(tum *p,char *buf)
{
  char str[STR_LEN_LN + 1]; 

  sprintf(str,"%s %x\n",dtum_flags,p->flags.all);
  strcat(buf,str);

  sprintf(str,"%s %s\n",dtum_user,p->user);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtum_no_active,p->no_active);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtum_d_connections,p->d_connections);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtum_t_connections,p->t_connections);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtum_tt_used,p->tt_used);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtum_dt_used,p->dt_used);
  strcat(buf,str);

  comp_64b(dtum_t_ul,p->t_ul,buf);
  comp_64b(dtum_t_dl,p->t_dl,buf);
  comp_64b(dtum_d_ul,p->d_ul,buf);
  comp_64b(dtum_d_dl,p->d_dl,buf);

  sprintf(str,"%s %x\n",dtum_last_active,p->last_active);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtum_dt_zone_limit,p->dt_zone_limit);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dtum_dt_set_limit,p->dt_set_limit);
  strcat(buf,str);
}

/********************************
*
*********************************/
void decomp_net_um(tum *p,char *ins)
{
  if(ins[0] != ':')
    return;

  if(!strncmp(ins,dtum_flags,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->flags.all));
    return;
  }

  if(!strncmp(ins,dtum_user,CMD_DT_SIZE))
  {
    decomp_str(p->user,ins,STR_USER_LEN);
    return;
  }

  if(!strncmp(ins,dtum_no_active,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->no_active));
    return;
  }

  if(!strncmp(ins,dtum_d_connections,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->d_connections));
    return;
  }

  if(!strncmp(ins,dtum_t_connections,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->t_connections));
    return;
  }

  if(!strncmp(ins,dtum_tt_used,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->tt_used));
    return;
  }

  if(!strncmp(ins,dtum_dt_used,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->dt_used));
    return;
  }

  if(!strncmp(ins,dtum_t_ul,CMD_DT_SIZE))
  {
    decomp_64b(&(p->t_ul),ins);
    return;
  }

  if(!strncmp(ins,dtum_t_dl,CMD_DT_SIZE))
  {
    decomp_64b(&(p->t_dl),ins);
    return;
  }

  if(!strncmp(ins,dtum_d_ul,CMD_DT_SIZE))
  {
    decomp_64b(&(p->d_ul),ins);
    return;
  }

  if(!strncmp(ins,dtum_d_dl,CMD_DT_SIZE))
  {
    decomp_64b(&(p->d_dl),ins);
    return;
  }

  if(!strncmp(ins,dtum_last_active,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->last_active));
    return;
  }

  if(!strncmp(ins,dtum_dt_zone_limit,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->dt_zone_limit));
    return;
  }

  if(!strncmp(ins,dtum_dt_set_limit,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->dt_set_limit));
    return;
  }
}

/***************************************************************************
* tgstat packer/unpacker
***************************************************************************/

/********************************
*
*********************************/
void comp_net_gstat(tgstat *p,char *buf)
{
  char str[STR_LEN_LN + 1];
  register int x;

  sprintf(str,"%s %x\n",dttgstat_mem_used,p->mem_used);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_total_users,p->total_users);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_no_active,p->no_active);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_no_kons,p->no_kons);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_no_free_dialins,p->no_free_dialins);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_d_connections,p->d_connections);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_t_connections,p->t_connections);
  strcat(buf,str);

  comp_64b(dttgstat_d_traffic,p->d_traffic,buf);
  comp_64b(dttgstat_t_traffic,p->t_traffic,buf);

  sprintf(str,"%s %x\n",dttgstat_avg_d_connections,p->avg_d_connections);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_avg_t_connections,p->avg_t_connections);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_avg_s_time,p->avg_s_time);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_avg_d_time,p->avg_d_time);
  strcat(buf,str);

  sprintf(str,"%s %x\n",dttgstat_avg_t_time,p->avg_t_time);
  strcat(buf,str);

  comp_64b(dttgstat_avg_s_traffic,p->avg_s_traffic,buf);
  comp_64b(dttgstat_avg_d_traffic,p->avg_d_traffic,buf);
  comp_64b(dttgstat_avg_t_traffic,p->avg_t_traffic,buf);

  for(x = 0;x < 24;x++)
  {
    sprintf(str,"%s %d %x\n",dttgstat_hour_tally,x,p->hour_tally[x]);
    strcat(buf,str);
  }
}

/********************************
*
*********************************/
void decomp_net_gstat(tgstat *p,char *ins)
{
  if(ins[0] != ':')
    return;

  if(!strncmp(ins,dttgstat_mem_used,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->mem_used));
    return;
  }

  if(!strncmp(ins,dttgstat_total_users,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->total_users));
    return;
  }

  if(!strncmp(ins,dttgstat_no_active,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->no_active));
    return;
  }

  if(!strncmp(ins,dttgstat_no_kons,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->no_kons));
    return;
  }

  if(!strncmp(ins,dttgstat_no_free_dialins,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->no_free_dialins));
    return;
  }

  if(!strncmp(ins,dttgstat_d_connections,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->d_connections));
    return;
  }

  if(!strncmp(ins,dttgstat_t_connections,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->t_connections));
    return;
  }

  if(!strncmp(ins,dttgstat_d_traffic,CMD_DT_SIZE))
  {
    decomp_64b(&(p->d_traffic),ins);
    return;
  }

  if(!strncmp(ins,dttgstat_t_traffic,CMD_DT_SIZE))
  {
    decomp_64b(&(p->t_traffic),ins);
    return;
  }

  if(!strncmp(ins,dttgstat_avg_d_connections,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->avg_d_connections));
    return;
  }

  if(!strncmp(ins,dttgstat_avg_t_connections,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->avg_t_connections));
    return;
  }

  if(!strncmp(ins,dttgstat_avg_s_time,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->avg_s_time));
    return;
  }

  if(!strncmp(ins,dttgstat_avg_d_time,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->avg_d_time));
    return;
  }

  if(!strncmp(ins,dttgstat_avg_t_time,CMD_DT_SIZE))
  {
    sscanf(ins,"%*s %x",&(p->avg_t_time));
    return;
  }

  if(!strncmp(ins,dttgstat_avg_s_traffic,CMD_DT_SIZE))
  {
    decomp_64b(&(p->avg_s_traffic),ins);
    return;
  }

  if(!strncmp(ins,dttgstat_avg_d_traffic,CMD_DT_SIZE))
  {
    decomp_64b(&(p->avg_d_traffic),ins);
    return;
  }

  if(!strncmp(ins,dttgstat_avg_t_traffic,CMD_DT_SIZE))
  {
    decomp_64b(&(p->avg_t_traffic),ins);
    return;
  }

  if(!strncmp(ins,dttgstat_hour_tally,CMD_DT_SIZE))
  {
    int x,a;

    sscanf(ins,"%*s %d %x",&x,&a);
    if(x >= 24)
      return;
    if(x == 0)
    {
      register int i;

      for(i = 1;i < 24;i++)
        p->hour_tally[i] = 0;
    }
    p->hour_tally[x] = a;
    return;
  }
}

/***************************************************************************
* struct clearing routines
***************************************************************************/
void us_clr(tus *p)
{
  register int x;

  p->flags.flag.unused_0 = 0;
  p->flags.flag.exempt_total_time = 1;
  p->flags.flag.exempt_daily_time = 1;
  p->flags.flag.exempt_expiry_date = 1;
  p->flags.flag.exempt_nice = 1;
  p->flags.flag.exempt_total_ul_lim = 1;
  p->flags.flag.exempt_total_dl_lim = 1;
  p->flags.flag.exempt_daily_ul_lim = 1;
  p->flags.flag.exempt_daily_dl_lim = 1;
  p->flags.flag.instant_purge_dt = 1;
  p->flags.flag.clobber_mult_logins = 1;
  p->flags.flag.banned = 0;
  p->flags.flag.exempt_act_timeout = 1;
  p->flags.flag.record_type = TUS_RECORD_TYPE_NORMAL;
  p->flags.flag.email_type = TUS_EMAIL_TYPE_NORMAL;
  p->flags.flag.flash_method = TUS_FLASH_METHOD_NONE;
  p->user[0] = 0;
  p->ident.email[0] = 0;
  p->tt_lim = 0;
  for(x = 0;x < DT_LIM_SIZE;x++)
  {
    p->dt_lim[x].d_fr = -1;
    p->dt_lim[x].d_to = 0;
    p->dt_lim[x].t_fr = 0;
    p->dt_lim[x].t_to = 0;
    p->dt_lim[x].limit = 0;
  }
  p->expiry_date.day = 1;
  p->expiry_date.month = 1;
  p->expiry_date.year = 1970;
  p->nice_factor = 0;
  p->t_ul_lim = 0;
  p->t_dl_lim = 0;
  p->d_ul_lim = 0;
  p->d_dl_lim = 0;
  p->act_timeout = 30 * 60;
}

void us_hr_clr(tus_hr *p)
{
  p->flags.flag.run_level = 1;
  p->flags.flag.min_free_dialin_exempt = 1;
  strcpy(p->root_email,"root@localhost");
  p->sleep_time = 15;
  p->grace_time = 5 * 60;
  p->grace_volume = 20;
  p->save_time = 15 * 60;
  p->min_free_dialins = 0;
  us_clr(&(p->default_us));
}
