/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* common functions used by clients
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>    
#include <netdb.h>
#include "defs.h"
#include "common.h"
#include "ll_bt.h"

char   *addr = "localhost";
int    port  = 303;

int    client_s = -1;
FILE   *client_fp = NULL;

tus_hr us_hr;
tus    us;
tum    um;
tgstat gstat;

/***************************************************************************
* network error call back routines for clients.
***************************************************************************/
void default_net_error_cb(void)
{
  exit(-1);
}

void (*net_error_cb)(void) = default_net_error_cb;

/***************************************************************************
*
***************************************************************************/
void common_atend_clean_up(void)
{
  if(client_s != -1)
    close_socket(client_s);
  if(client_fp != NULL)
    fclose(client_fp);
}

/***************************************************************************
*
***************************************************************************/
void client_init(void (*atend_func)(void),void (*mcb)(void),void (*ncb)(void))
{
  signal(SIGPIPE,SIG_IGN);
  signal(SIGINT,SIG_IGN);
  atexit(atend_func);
  /*
   * this is the callback routine used by functions like cnet_get_entry()
   * to display a network error message if it ever did arise. in clobberedit
   * it would be a dialogised message. in a cmd line utility, it would be
   * a print to stdio.
   */
  memory_error_cb = mcb;
  net_error_cb = ncb;
}

/***************************************************************************
*
***************************************************************************/
int client_bind_socket(char *addr,int port)
{
  register int s;
  struct hostent *hp;
  struct sockaddr_in saddr_in;

  memset((char *)&saddr_in,0,sizeof(struct sockaddr_in));
  if((hp = gethostbyname(addr)) != NULL)
  {
    saddr_in.sin_family = AF_INET;
    saddr_in.sin_addr.s_addr = ((struct in_addr *)(hp->h_addr))->s_addr;
    saddr_in.sin_port = htons(port);
    if((s = socket(AF_INET,SOCK_STREAM,0)) != -1)
      if(connect(s,(struct sockaddr *)&saddr_in,
        sizeof(struct sockaddr_in)) != -1)
        return s;
  }
  return 0;
}

/***************************************************************************
* this routine does everything to create a tcp connection to a host.
* once run, and if return's 1, then your up and running.
***************************************************************************/
int init_client_kon(void)
{
  struct servent *se;
  int port;

  se = getservbyname("clobberd","tcp");
  if(se != NULL)
    port = ntohs(se->s_port);
  else
    return 0;

  client_s = client_bind_socket(addr,port);
  if(client_s)
  {
    client_fp = fdopen(client_s,"a+");
    if(client_fp != NULL)
      return 1;
  }
  return 0;
}

/***************************************************************************
* client cmd atoms
***************************************************************************/
void net_get_entry(char *str)
{
  register int s;

  if(fgets(str,STR_LEN_LN,client_fp) == NULL)
    net_error_cb();
  s = strlen(str);
  if(s > 0)
    if(str[s - 1] == '\n')
      str[s - 1] = 0;
}

void net_put_entry(char *str)
{
  fprintf(client_fp,str);
  fflush(client_fp);
}

void net_put_cmd(char *str)
{
  fprintf(client_fp,"%s\n",str);
  fflush(client_fp);
}

int net_parse_ret_code(char *ins,int *status)
{
  char cmd_str[STR_LEN_LN + 1] = "";

  sscanf(ins,"%s %d",cmd_str,status);
  if(!strcmp(cmd_str,cmd_ret))
    return 1;
  return 0;
}

int net_get_ret(void)
{
  for(;;)
  {
    char ins[STR_LEN_LN + 1];
    int status = 0;

    net_get_entry(ins);
    if(net_parse_ret_code(ins,&status))
      return status;
  }
  return 0;
}

/***************************************************************************
* cmd routines that need to be wrapped
***************************************************************************/
int common_net_lock_us_hr(void)
{
  net_put_cmd(cmd_lushr);
  return net_get_ret();
}

int common_net_unlock_us_hr(void)
{
  net_put_cmd(cmd_uushr);
  return net_get_ret();
}

int common_net_get_us_hr(void)
{
  memset(&us_hr,0,sizeof(tus_hr));
  net_put_cmd(cmd_gushr);
  for(;;)
  {
    char ins[STR_LEN_LN + 1];
    int status = 0;

    net_get_entry(ins);
    if(net_parse_ret_code(ins,&status))
      return status;
    decomp_net_us_hr(&us_hr,ins);
  }

  return 0;
}

int common_net_put_us_hr(void)
{
  char str[STR_BIG] = "";

  comp_net_us_hr(&us_hr,str);
  net_put_cmd(cmd_sushr);
  net_put_entry(str);
  net_put_cmd(cmd_ret);
  return net_get_ret();
}

/***************************************************************************
*
***************************************************************************/
int common_net_lock_user(char *user)
{
  char str[STR_LEN];

  sprintf(str,"%s %s",cmd_luser,user);
  net_put_cmd(str);
  return net_get_ret();
}

int common_net_unlock_user(void)
{
  net_put_cmd(cmd_uuser);
  return net_get_ret();
}

/***************************************************************************
* type:
* 0 = find_us()
* 1 = find_effective_us()
***************************************************************************/
int common_net_get_us(char *user,int type)
{
  char str[STR_LEN];

  memset(&us,0,sizeof(tus));
  sprintf(str,"%s %s",type ? cmd_gus2 : cmd_gus,user);
  net_put_cmd(str);
  for(;;)
  {
    int status = 0;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
      return status;
    decomp_net_us(&us,str);
  }

  return 0;
}

int common_net_put_us(void)
{
  char str[STR_BIG] = "";

  comp_net_us(&us,str);
  net_put_cmd(cmd_sus);
  net_put_entry(str);
  net_put_cmd(cmd_ret);
  return net_get_ret();
}

int common_net_new_us(char *user)
{
  char str[STR_LEN]; 

  sprintf(str,"%s %s",cmd_nus,user);
  net_put_cmd(str);
  return net_get_ret();
}

int common_net_delete_us(char *user)
{
  char str[STR_LEN];

  sprintf(str,"%s %s",cmd_dus,user);
  net_put_cmd(str);
  return net_get_ret();
}

/***************************************************************************
*
***************************************************************************/
int common_net_get_um(char *user)
{
  char str[STR_LEN];

  memset(&um,0,sizeof(tum));
  sprintf(str,"%s %s",cmd_gum,user);
  net_put_cmd(str);
  for(;;)
  {
    int status = 0;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
      return status;
    decomp_net_um(&um,str);
  }

  return 0;
}

int common_net_put_um(void)
{
  char str[STR_BIG] = "";

  comp_net_um(&um,str);
  net_put_cmd(cmd_sum);
  net_put_entry(str);
  net_put_cmd(cmd_ret);
  return net_get_ret();
}

int common_net_delete_um(char *user)
{
  char str[STR_LEN]; 

  sprintf(str,"%s %s",cmd_dum,user);
  net_put_cmd(str);
  return net_get_ret();
}

/***************************************************************************
*
***************************************************************************/
int common_net_get_gstat(void)
{
  memset(&gstat,0,sizeof(tgstat));
  net_put_cmd(cmd_gstat);
  for(;;)
  {
    char ins[STR_LEN_LN + 1];
    int status = 0;

    net_get_entry(ins);
    if(net_parse_ret_code(ins,&status))
      return status;
    decomp_net_gstat(&gstat,ins);
  }
  return 1;
}

/***************************************************************************
*
***************************************************************************/
void common_net_get_stime(int *s,int *t)
{
  char str[STR_LEN]; 

  net_put_cmd(cmd_stime);
  net_get_entry(str);
  if(str[0] == ':')
  {
    sscanf(str + 1,"%x %x",s,t);
    net_get_ret();
  }
  else
  {
    *s = 60;
    *t = 0;
  }
}

int common_net_tpurge(void)
{
  net_put_cmd(cmd_tpurg);
  return net_get_ret();
}

int common_net_dpurge(void)
{
  net_put_cmd(cmd_dpurg);
  return net_get_ret();
}

void common_net_archive(void)
{
  net_put_cmd(cmd_arch);
  net_get_ret();
}
