/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ======================================================================
* Global definations used by everything in the distribution
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include "ll_bt_st.h"
#include "../version.h"

#define WELCOME \
"Clobberd version " VERSION ", Copyright (C) 1996-2001 Jason Nunn.\n\n"
#define DISCLAIMER \
"Clobberd is under the GNU GENERAL PUBLIC LICENSE AGREEMENT, and\n" \
"comes with ABSOLUTELY NO WARRANTY. This is free software, and you are\n" \
"welcome to redistribute it under certain conditions.\n\n" \
"   Contact: 32 Rothdale Rd, Moil Darwin NT 0810, AUSTRALIA\n" \
"     Email: jsno@downunder.net.au or jsno@accessnt.com.au\n" \
"\n"

typedef unsigned long long int _UD_64; /* this is 64 bit unsigned on GNU C*/

#define STR_LEN             256     /*string size defs.*/
#define STR_LEN_LN          80
#define STR_GEN_LEN         40
#define STR_USER_LEN        32
#define STR_BIG             2048
#define STR_TTY_LEN         12
#define STR_SMALL           16
#define STR_EMAIL           60

#define ATEND_CHILD_TERM    32     /*used by atend_clean_up() in misc.c*/
#define RECV_BUF_LEN        512    /*size of TCP recv buffer*/
#define NETWORK_SUSTAIN     256

/*************************************************
* cmd operation status codes
*
* (status return codes of cmd_ret)
*************************************************/
#define CO_SUCCESSFUL        0
#define CO_RECORD_NOT_FOUND  1
#define CO_RECORD_LOCKED     2
#define CO_OPERATION_FAILED  3
#define CO_CMD_MISSING_PARAM 4
#define CO_UNKNOWN_CMD       5

/*************************************************
* locations of various files etc
* (used by clob_notify)
*************************************************/
#define CLOB_SIGNATURE      VAR_PATH "/mesg/signature.txt"
#define CLOB_MESS           VAR_PATH "/mesg/m_banned.txt"
#define CLOB_MULTPLE_MESS   VAR_PATH "/mesg/m_multiple.txt"
#define ACCT_EXPIRED_MESS   VAR_PATH "/mesg/m_expired.txt"
#define EXCEEDED_TT_MESS    VAR_PATH "/mesg/m_total_time.txt"
#define EXCEEDED_DT_MESS    VAR_PATH "/mesg/m_daily_time.txt"
#define EXCEEDED_TNET_MESS  VAR_PATH "/mesg/m_total_net.txt"
#define EXCEEDED_DNET_MESS  VAR_PATH "/mesg/m_daily_net.txt"
#define UACT_TIMEOUT_MESS   VAR_PATH "/mesg/m_activity_to.txt"

/*
 * various defs used to tell clob_notify what type of message
 * to send to user.
 */
#define CLOB_INDEX          0
#define CLOB_MULTIPLE_INDEX 1
#define ACCT_EXPIRED_INDEX  2
#define EXCEEDED_TT_INDEX   3
#define EXCEEDED_DT_INDEX   4
#define EXCEEDED_TNET_INDEX 5
#define EXCEEDED_DNET_INDEX 6
#define UACT_TIMEOUT_INDEX  7

/*************************************************
* this is used by read_boot_conf() in clobberd/misc.c
it will store all the info in boot.conf
*************************************************/
#define TTY_T_SIZE        256
#define EXEMPT_USER_SIZE  32
#define FLASH_METHOD_SIZE 16

typedef struct
{
  unsigned clobber_logins_only : 1;
} tboot_st_flags;

typedef struct
{
  union
  {
    int            all;
    tboot_st_flags flag;
  }    flags;

  char passwd[STR_GEN_LEN + 1];

  int  max_kons;
  int  kon_timeout;

  char pppd_run_dir[STR_LEN + 1];
  int  kill_signal;

  int  mfd_tty_t_size;
  char mfd_tty_t[TTY_T_SIZE][STR_TTY_LEN + 1];

  int  exempt_user_size;
  char exempt_user[EXEMPT_USER_SIZE][STR_USER_LEN + 1];
} tboot_st;

/**************************************************
* for caching user <--> nif associations
**************************************************/
typedef struct
{
  int  pid;
  char nif_name[STR_SMALL + 1];
} tuser_nif;

/**************************************************
* for caching nifs
**************************************************/
typedef struct
{
  char name[STR_SMALL + 1];
  int  rx;
  int  tx;
} tnif;

/**************************************************
* "Terminal Info" structures
**************************************************/
#define TINFO_TYPE_UNKNOWN     0
#define TINFO_TYPE_LOGIN       1
#define TINFO_TYPE_PPP_LOGIN   2
#define TINFO_TYPE_PPP_PAP     3
#define TINFO_TYPE_PPP_UNKNOWN 4
#define TINFO_TYPE_GNIF        5

#define TINFO_TYPE_SIZE        5

typedef struct
{
  unsigned type       : 4;
  unsigned nif_primed : 1;
} ttinfo_flags;

typedef struct
{
  union
  {
    int          all;
    ttinfo_flags flag;
  }    flags;
  int  pid;                   /*pid & term id together*/
  char tty[STR_TTY_LEN + 1];  /*determine unique session*/
  char nif[STR_SMALL + 1];    /*network interface*/
  int  t_used;
  int  ul;
  int  dl;
  int  last_active;

/*tmp members*/
  int  old_time;
  int  old_ul;
  int  old_dl;
  int  delta_ul;
  int  delta_dl;
} ttinfo;

/**************************************************
* "User Settings" structures
**************************************************/
#define DT_LIM_SIZE               8

#define TUS_RECORD_TYPE_NORMAL    0
#define TUS_RECORD_TYPE_GROUP     1
#define TUS_RECORD_TYPE_LINK      2
#define TUS_RECORD_TYPE_UNION     3
#define TUS_RECORD_TYPE_EFFECTIVE 4
#define TUS_RECORD_TYPE_SIZE      3  /*selectable ones*/

#define TUS_EMAIL_TYPE_NORMAL     0
#define TUS_EMAIL_TYPE_CC_ROOT    1
#define TUS_EMAIL_TYPE_NONE       2
#define TUS_EMAIL_TYPE_SIZE       2

#define TUS_FLASH_METHOD_NONE     0
#define TUS_FLASH_METHOD_SIZE     (FLASH_METHOD_SIZE - 1)

typedef struct
{
  unsigned unused_0            : 1;
  unsigned exempt_total_time   : 1;
  unsigned exempt_daily_time   : 1;
  unsigned exempt_expiry_date  : 1;
  unsigned exempt_nice         : 1;
  unsigned exempt_total_ul_lim : 1;
  unsigned exempt_total_dl_lim : 1;
  unsigned exempt_daily_ul_lim : 1;
  unsigned exempt_daily_dl_lim : 1;
  unsigned instant_purge_dt    : 1;
  unsigned clobber_mult_logins : 1;
  unsigned banned              : 1;
  unsigned exempt_act_timeout  : 1;
  unsigned record_type         : 3;   /*type range: 0-7*/
  unsigned email_type          : 2;   /*type range: 0-3*/
  unsigned flash_method        : 4;   /*method range: 0-f; 0 = none*/
} tus_flags;

typedef struct
{
  char d_fr; /*0 = Mon, 6 = Sun*/
  char d_to;
  char t_fr; /*1am - 12pm*/
  char t_to;
  int  limit;
} tdt_lim;

typedef struct
{
  char day;
  char month;
  int  year;
} tdate_st;

typedef struct
{
  union
  {
    int       all;
    tus_flags flag;
  }        flags;
  char     user[STR_USER_LEN + 1];
  union
  {
    char email[STR_EMAIL + 1];
    char link[STR_USER_LEN + 1];
  }        ident;
  int      tt_lim;
  tdt_lim  dt_lim[DT_LIM_SIZE];
  tdate_st expiry_date;
  int      nice_factor;
  int      t_ul_lim; /*Mb*/
  int      t_dl_lim; /*Mb*/
  int      d_ul_lim; /*Mb*/
  int      d_dl_lim; /*Mb*/
  int      act_timeout;
} tus;

/**************************************************
* "General Settings" structures
**************************************************/
typedef struct
{
  unsigned run_level              : 3;
  unsigned not_used               : 1;
  unsigned min_free_dialin_exempt : 1;
  unsigned default_us_enabled     : 1;
} tus_hr_flags;

typedef struct
{
  union
  {
    int          all;
    tus_hr_flags flag;
  }      flags;
  char   root_email[STR_EMAIL + 1];
  int    sleep_time;
  int    grace_time;
  int    grace_volume;
  int    save_time;
  int    min_free_dialins;
  tus    default_us;
} tus_hr;

/**************************************************
* "User Monitor" structures
**************************************************/
#define TUM_TYPE_USER  0
#define TUM_TYPE_NIF   1

typedef struct
{
  unsigned type        : 4;

/*temp flags*/
  unsigned tt_graced   : 1;
  unsigned dt_graced   : 1;
  unsigned t_ul_graced : 1;
  unsigned t_dl_graced : 1;
  unsigned d_ul_graced : 1;
  unsigned d_dl_graced : 1;
} tum_flags;

typedef struct
{
  union
  {
    int       all;
    tum_flags flag;
  }        flags;

/*stored fields*/
  char     user[STR_USER_LEN + 1];
  int      no_active;
  int      d_connections;
  int      t_connections;
  int      tt_used;
  int      dt_used;
  _UD_64   t_ul; /*stored in bytes*/
  _UD_64   t_dl; /*64 bit integer*/
  _UD_64   d_ul;
  _UD_64   d_dl;

/*runtime (temp) fields*/
  tll      *tinfo_ll;
  int      last_active;
  int      old_time;
  int      dt_zone_limit;
  int      dt_set_limit;
} tum;

/**************************************************
* "General Statistics" structure
**************************************************/
typedef struct
{
  int    mem_used;
  int    total_users;
  int    no_active;
  int    no_kons;

/*accumulated members*/
  int    no_free_dialins;
  int    d_connections;
  int    t_connections;
  _UD_64 d_traffic;
  _UD_64 t_traffic;

/*average members*/
  int    avg_d_connections;
  int    avg_t_connections;
  int    avg_s_time;
  int    avg_d_time;
  int    avg_t_time;
  _UD_64 avg_s_traffic;
  _UD_64 avg_d_traffic;
  _UD_64 avg_t_traffic;

/*24 hour activity list*/
  int    hour_tally[24];
} tgstat;

/**************************************************
* this struct is used by net_server.c to store
* connection information.
**************************************************/
#define RECV_BUF_FRAG_SIZE 100  /*size of TCP recv buffer*/

#define TKON_MODE_CMD      0  /*tkon.mode settings*/
#define TKON_MODE_S_US_HR  1
#define TKON_MODE_S_US     2
#define TKON_MODE_S_UM     3

typedef struct
{
  unsigned version_hs   : 1;
  unsigned authorised   : 1;
  unsigned us_hr_locked : 1;
  unsigned mode         : 4;
} tkon_flags;

typedef struct
{
  union
  {
    int        all;
    tkon_flags flag;
  } flags;
  int  kid;
  int  s;
  char hostname[STR_GEN_LEN + 1];
  int  port;
  int  created;
  int  last_active;
  char user_lock[STR_USER_LEN + 1];
  FILE *tmp_fp;
  tll  *recv_queue_ll;
} tkon;
