/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* general purpose linked list & binary tree atoms
*
* this module was prompted, because clobberd now uses *lots* of linked
* lists. some small, some very big.
*
* although, slighty more O/H than the previous high weight linked
* lists, these routines reduce code redundancy, and reduce bugs when
* any maintainers add extra features.
*
* to any one adding new data structures to clobberd, ll_bt.c is your
* friend...
*
* have a look at ll_bt_test.c for an example to use.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "defs.h"
#include "common.h"

/***************************************************************************
****************************************************************************
* Linked List routines
****************************************************************************
***************************************************************************/

/****************************************
*
****************************************/
tll *ll_append_unsorted(tll **n,void *entry,int entry_size)
{
  tll *tmp,*tmp2;

  tmp = malloc(sizeof(tll));
  if(tmp == NULL)
    memory_error_cb();
  tmp2 = (*n);
  (*n) = tmp;
  (*n)->next = tmp2;
  (*n)->entry = malloc(entry_size);
  if((*n)->entry == NULL)
    memory_error_cb();
  memcpy((*n)->entry,entry,entry_size);
  return tmp;
}

/****************************************
*
****************************************/
tll *ll_append_sorted(
  tll **ll,void *entry,int entry_size,int (*cmp_func)(tll *))
{
  tll **n;

  n = ll;
  for(;;)
  {
    if((*n == NULL) || cmp_func(*n))
      return ll_append_unsorted(n,entry,entry_size);
    n = &((*n)->next);
  }
  return NULL;
}

/****************************************
*
****************************************/
tll *ll_find(tll **ll,int (*cmp_func)(tll *))
{
  tll *n;

  n = *ll;
  for(;;)
  {
    if(n == NULL)
      return NULL;
    if(cmp_func(n))
      return n;
    n = n->next;
  }
  return NULL;
}

/****************************************
*
****************************************/
void ll_remove(tll **ll,int (*cmp_func)(tll *))
{
  tll **n;

  n = ll;
  for(;;)
  {
    if(*n == NULL)
      return;
    if(cmp_func(*n))
    {
      tll *tmp;

      free((*n)->entry);
      tmp = (*n)->next;
      free(*n);
      *n = tmp;
      return;
    }
    n = &((*n)->next);
  }
}

/****************************************
*
****************************************/
void ll_free(tll **ll)
{
  tll **n;

  n = ll;
  for(;;)
  {
    tll *tmp;

    if(*n == NULL)
      break;
    tmp = (*n)->next;
    free((*n)->entry);
    free(*n);
    *n = tmp;
  }
  *ll = NULL;
}

/****************************************
*
****************************************/
void *ll_read_entry(tll **ll_ptr)
{
  void *e;

  if(*ll_ptr == NULL)
    return NULL;
  e = (*ll_ptr)->entry;
  *ll_ptr = (*ll_ptr)->next;
  return e;
}

/***************************************************************************
****************************************************************************
* Binary Search Tree routines
*
* note, these are search structures, and are intended to be used inconjunction
* with a linked list. these don't "store" entries as it were.
*
* Nb/ keys (values returned by cmp_func()) _MUST_ be unique.
*
****************************************************************************
***************************************************************************/

/****************************************
*
****************************************/
void bt_append(tbt **t,void *entry,int (*cmp_func)(tbt *))
{
  tbt **n;

  n = t;
  for(;;)
  {
    if(*n != NULL)
    {
      register int r;

      r = cmp_func(*n);
      if(r < 0)
        n = &((*n)->left);
      else
        if(r > 0)
          n = &((*n)->right);
    }
    else
    {
      *n = malloc(sizeof(tbt));
      if(*n == NULL)
        memory_error_cb();
      (*n)->left = NULL;
      (*n)->right = NULL;
      (*n)->entry = entry;
      return;
    }
  }
}

/****************************************
*
****************************************/
tbt *bt_find(tbt **t,int (*cmp_func)(tbt *))
{
  tbt *n;

  n = *t;
  for(;;)
  {
    if(n != NULL)
    {
      register int r;

      r = cmp_func(n);
      if(r < 0)
        n = n->left;
      else
        if(r > 0)
          n = n->right;
        else
          return n;
    }
    else
      break;
  }
  return NULL;
}

/****************************************
*
****************************************/
void bt_append_branch(
  tbt **tree,tbt *branch,int (*cmp_func)(tbt *t,tbt *))
{
  tbt **n;

  if(branch == NULL)
    return;
  n = tree;
  for(;;)
  {
    if(*n != NULL)
    {
      register int r;
  
      r = cmp_func(*n,branch);
      if(r < 0)
        n = &((*n)->left);
      else
        if(r > 0)
          n = &((*n)->right);
    }
    else
    {
      *n = branch;
      return;
    }
  }
}

void bt_remove(
  tbt **t,int (*cmp_func)(tbt *),int (*cmp_func2)(tbt *,tbt *))
{
  tbt **n;

  n = t;
  for(;;)
  {
    if(*n != NULL)
    {
      register int r;

      r = cmp_func(*n);
      if(r < 0)
         n = &((*n)->left);
      else
      {
        if(r > 0)
           n = &((*n)->right);
        else
        {
          tbt *l,*r;

          l = (*n)->left;
          r = (*n)->right;
          free(*n);
          if(l != NULL)
          {
            *n = l;
            bt_append_branch(n,r,cmp_func2);
          }
          else
            if(r != NULL)
            {
              *n = r;
              bt_append_branch(n,l,cmp_func2);
            }
            else
              *n = NULL;
          return;
        }
      }
    }
    else
      break;
  }
}

/****************************************
*
****************************************/
void bt_free(tbt **t)
{
  if(*t != NULL)
  {
    bt_free(&((*t)->left));
    bt_free(&((*t)->right));
    free(*t);
    *t = NULL;
  }
}
