/***************************************************************************
* routines to test linked list routines.
***************************************************************************/
#include <stdio.h>
#include "defs.h"
#include "common.h"
#include "ll_bt.h"

typedef struct
{
  char name[20];
  int  age;
} trecord;

/***************************************************************************
*
***************************************************************************/
void fatal_ll_error(void)
{
  printf("Fatal Memory error. Aborting.\n");
  exit(-1);
}

/***************************************************************************
* linked list protos
***************************************************************************/
void append_record_unsorted(tll **ll,char *name,int age)
{
  trecord record;

  strcpy(record.name,name);
  record.age = age;
  ll_append_unsorted(ll,&record,sizeof(trecord));
}

void append_record_sorted(tll **ll,char *name,int age)
{
  trecord record;

  int cmp_func(tll *n)
  {
    if(strcmp(name,((trecord *)(n->entry))->name) < 0)
      return 1;
    return 0;
  }

  strcpy(record.name,name);
  record.age = age;
  ll_append_sorted(ll,&record,sizeof(trecord),cmp_func);
}

trecord *find_record(tll **ll,char *name)
{
  tll *ret;

  int cmp_func(tll *n)
  {
    if(!strcmp(((trecord *)(n->entry))->name,name))
      return 1;
    return 0;
  }

  ret = ll_find(ll,cmp_func);
  if(ret == NULL)
    return NULL;
  return ret->entry;
}

void remove_record(tll **ll,char *name)
{
  int cmp_func(tll *n)
  {
    if(!strcmp(((trecord *)(n->entry))->name,name))
      return 1;
    return 0;
  }

  ll_remove(ll,cmp_func);
}

/***************************************************************************
* binary tree protos
***************************************************************************/
void bsearch_append(tbt **t,trecord *e)
{
  int cmp_func(tbt *n)
  {
    return strcmp(e->name,((trecord *)(n->entry))->name);
  }

  bt_append(t,e,cmp_func);
}

trecord *bsearch(tbt **t,char *name)
{
  tbt *ret;

  int cmp_func(tbt *n)
  {
    return strcmp(name,((trecord *)(n->entry))->name);
  }

  ret = bt_find(t,cmp_func);
  if(ret == NULL)
    return NULL;
  return ret->entry;
}

void bsearch_remove(tbt **t,char *name)
{
  int cmp_func(tbt *n)
  {
    return strcmp(name,((trecord *)(n->entry))->name);
  }

  int cmp_func2(tbt *t,tbt *b)
  {
    return strcmp(((trecord *)(b->entry))->name,((trecord *)(t->entry))->name);
  }

  bt_remove(t,cmp_func,cmp_func2);
}

/***************************************************************************
*
***************************************************************************/
void print_records(tll *ll)
{
  printf("\nprinting records using ll_read_entry().\n");
  for(;;)
  {
    trecord *p;

    p = ll_read_entry(&ll);
    if(p == NULL)
      break;
    printf("%15s %2d\n",p->name,p->age);
  }
}

/***************************************************************************
*
***************************************************************************/
void ll_test_unsorted(void)
{
  tll *unsorted_ll = NULL;
  trecord *rp;

  printf("== Unsorted linked list test. ==\n\n");

  printf("adding records using ll_append_unsorted().\n");
  append_record_unsorted(&unsorted_ll,"jason",0);
  append_record_unsorted(&unsorted_ll,"jack",1);
  append_record_unsorted(&unsorted_ll,"phil",2);
  append_record_unsorted(&unsorted_ll,"ted",3);
  append_record_unsorted(&unsorted_ll,"dick",4);
  append_record_unsorted(&unsorted_ll,"john",5);
  append_record_unsorted(&unsorted_ll,"peter",6);

  print_records(unsorted_ll);

  printf("\nfinding records using ll_find().\n");
  rp = find_record(&unsorted_ll,"ted");
  if(rp != NULL)
    printf("Found %s aged %d\n",rp->name,rp->age);
  rp = find_record(&unsorted_ll,"john");
  if(rp != NULL)
    printf("Found %s aged %d\n",rp->name,rp->age);

  printf("\nremoving records using ll_remove().\n");
  remove_record(&unsorted_ll,"jack");
  printf("Removed jack\n");
  remove_record(&unsorted_ll,"john");
  printf("Removed john\n");
  remove_record(&unsorted_ll,"jason");
  printf("Removed jason\n");

  print_records(unsorted_ll);

  printf("\nFreeing linked list using ll_free().\n");
  ll_free(&unsorted_ll);
}

/***************************************************************************
*
***************************************************************************/
void ll_test_sorted(void)
{
  tll *sorted_ll = NULL;
  trecord *rp;

  printf("\n\n\n\n== Sorted linked list test. ==\n");

  printf("adding records using ll_append_sorted().\n");
  append_record_sorted(&sorted_ll,"jason",0);
  append_record_sorted(&sorted_ll,"jack",1);
  append_record_sorted(&sorted_ll,"phil",2);
  append_record_sorted(&sorted_ll,"ted",3);
  append_record_sorted(&sorted_ll,"dick",4);
  append_record_sorted(&sorted_ll,"john",5);
  append_record_sorted(&sorted_ll,"peter",6);

  print_records(sorted_ll);

  printf("\nfinding records using ll_find().\n");
  rp = find_record(&sorted_ll,"ted");
  if(rp != NULL)
    printf("Found %s aged %d\n",rp->name,rp->age);
  rp = find_record(&sorted_ll,"john");
  if(rp != NULL)
    printf("Found %s aged %d\n",rp->name,rp->age);

  printf("\nremoving records using ll_remove().\n");
  remove_record(&sorted_ll,"jack");
  printf("Removed jack\n");
  remove_record(&sorted_ll,"john");
  printf("Removed john\n");
  remove_record(&sorted_ll,"jason");
  printf("Removed jason\n");

  print_records(sorted_ll);

  printf("\nFreeing linked list using ll_free().\n");
  ll_free(&sorted_ll);
}

/***************************************************************************
*
***************************************************************************/
void bt_test(void)
{
  tbt *bt = NULL;
  trecord tab[10];
  trecord *tr;

  printf("\n\n\n\n== Binary Search Tree test. ==\n");

  strcpy(tab[0].name,"jason");
  strcpy(tab[1].name,"fred");
  strcpy(tab[2].name,"phil");
  strcpy(tab[3].name,"dick");
  strcpy(tab[4].name,"tom");
  strcpy(tab[5].name,"harry");
  strcpy(tab[6].name,"tim");
  strcpy(tab[7].name,"peter");
  strcpy(tab[8].name,"graham");
  strcpy(tab[9].name,"john");

  tab[0].age = 0;
  tab[1].age = 1;
  tab[2].age = 2;
  tab[3].age = 3;
  tab[4].age = 4;
  tab[5].age = 5;
  tab[6].age = 6;
  tab[7].age = 7;
  tab[8].age = 8;
  tab[9].age = 9;

  printf("\nbuilding btree using bt_append()\n");

  bsearch_append(&bt,&(tab[0]));
  bsearch_append(&bt,&(tab[1]));
  bsearch_append(&bt,&(tab[2]));
  bsearch_append(&bt,&(tab[3]));
  bsearch_append(&bt,&(tab[4]));
  bsearch_append(&bt,&(tab[6]));
  bsearch_append(&bt,&(tab[7]));
  bsearch_append(&bt,&(tab[8]));

  printf("\nSearching btree using bt_find()\n");
  tr = bsearch(&bt,"tom");
  if(tr != NULL) printf("Found %s aged %d\n",tr->name,tr->age);
  tr = bsearch(&bt,"peter");
  if(tr != NULL) printf("Found %s aged %d\n",tr->name,tr->age);

  printf("\nRemoving node from btree using bt_remove()\n");

  bsearch_remove(&bt,"tom");
  tr = bsearch(&bt,"tom");
  if(tr == NULL)
    printf("tom removed\n");
  else
    printf("tom wasn't removed\n");

  bsearch_remove(&bt,"phil");
  tr = bsearch(&bt,"phil");
  if(tr == NULL)
    printf("phil removed\n");
  else
    printf("phil wasn't removed\n");


  printf("\nbuilding btree using bt_append()\n");

  bsearch_append(&bt,&(tab[9]));
  bsearch_append(&bt,&(tab[5]));

  printf("\n freeing btree using bt_free()\n");
  bt_free(&bt);
}

/***************************************************************************
*
***************************************************************************/
void walk_bt(tbt *t)
{
  if(t != NULL)
  {
    printf("%10s %x\n",((trecord *)(t->entry))->name,(int)t);
    walk_bt(t->left);
    walk_bt(t->right);
  }
}

void bt_test2(void)
{
  tbt *bt = NULL;
  trecord tab[10];

  printf("\n\n\n\n== Binary Search Tree test 2. ==\n");

  strcpy(tab[0].name,"jason");
  strcpy(tab[1].name,"fred");
  strcpy(tab[2].name,"phil");
  strcpy(tab[3].name,"dick");
  strcpy(tab[4].name,"tom");
  strcpy(tab[5].name,"harry");
  strcpy(tab[6].name,"tim");
  strcpy(tab[7].name,"peter");
  strcpy(tab[8].name,"graham");
  strcpy(tab[9].name,"john");

  printf("\nbuilding btree using bt_append()\n");

  bsearch_append(&bt,&(tab[0]));
  bsearch_append(&bt,&(tab[1]));
  bsearch_append(&bt,&(tab[2]));
  bsearch_append(&bt,&(tab[3]));
  bsearch_append(&bt,&(tab[4]));
  bsearch_append(&bt,&(tab[5]));
  bsearch_append(&bt,&(tab[6]));
  bsearch_append(&bt,&(tab[7]));
  bsearch_append(&bt,&(tab[8]));
  bsearch_append(&bt,&(tab[9]));

  printf("\nWalk tree\n\n");
  walk_bt(bt);

  printf("\nRemoving node from btree using bt_remove()\n");

  bsearch_remove(&bt,"john");
  bsearch_remove(&bt,"peter");
  bsearch_remove(&bt,"phil");
  bsearch_remove(&bt,"dick");
  bsearch_remove(&bt,"tim");
  bsearch_remove(&bt,"fred");

  printf("\nWalk tree\n\n");
  walk_bt(bt);

  printf("\n freeing btree using bt_free()\n");
  bt_free(&bt);
}

/***************************************************************************
*
***************************************************************************/
int main(void)
{
  memory_error_cb = fatal_ll_error;
  ll_test_unsorted();
  ll_test_sorted();
  bt_test();
  bt_test2();
  return 1;
}
