/***************************************************************************
* routines to test linked list routines 2
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "defs.h"
#include "common.h"
#include "ll_bt.h"

typedef struct
{
  int          no;
  unsigned int magic;
} trecord;

tll *record_ll = NULL;
tbt *record_bt = NULL;

/***************************************************************************
*
***************************************************************************/
void fatal_ll_error(void)
{
  printf("Fatal Memory error. Aborting.\n");
  exit(-1);
}

/***************************************************************************
* protos
***************************************************************************/
void append_record(int no,int magic)
{
  tll *node;
  trecord record;

  int ll_cmp_func(tll *n)
  {
    if((no - ((trecord *)(n->entry))->no) < 0)
      return 1;
    return 0;
  }

  int bt_cmp_func(tbt *n)
  {
    return no - ((trecord *)(n->entry))->no;
  }

  record.no = no;
  record.magic = magic;
  node = ll_append_sorted(&record_ll,&record,sizeof(trecord),ll_cmp_func);
  if(node != NULL)
    bt_append(&record_bt,node->entry,bt_cmp_func);
}

trecord *find_record_ll(char no)
{
  tll *ret;

  int cmp_func(tll *n)
  {
    if(((trecord *)(n->entry))->no == no)
      return 1;
    return 0;
  }

  ret = ll_find(&record_ll,cmp_func);
  if(ret == NULL)
    return NULL;
  return ret->entry;
}

trecord *find_record_bt(char no)
{
  tbt *ret;

  int cmp_func(tbt *n)
  {
    return no - ((trecord *)(n->entry))->no;
  }

  ret = bt_find(&record_bt,cmp_func);
  if(ret == NULL)
    return NULL;
  return ret->entry;
}

void remove_record(char no)
{
  int ll_cmp_func(tll *n)
  {
    if(((trecord *)(n->entry))->no == no)
      return 1;
    return 0;
  }

  int bt_cmp_func(tbt *n)
  {
    return no - ((trecord *)(n->entry))->no;
  }

  int bt_cmp_func2(tbt *t,tbt *b)
  {
    return ((trecord *)(b->entry))->no - ((trecord *)(t->entry))->no;
  }

  bt_remove(&record_bt,bt_cmp_func,bt_cmp_func2);
  ll_remove(&record_ll,ll_cmp_func);
}

void free_records(void)
{
  bt_free(&record_bt);
  ll_free(&record_ll);
}

/***************************************************************************
*
***************************************************************************/
#define MLEN 0x1fff

void find(void)
{
  register int x,found = 0,found2 = 0;

  for(x = 0;x < MLEN;x++)
  {
    register int r;

    r = random() & MLEN;

    if(find_record_ll(r))
      found++;
    if(find_record_bt(r))
      found2++;
  }

  printf("ll_fnd:%-6d, bt_fnd:%-6d  ",found,found2);
  fflush(stdout);
}

int main(void)
{
  printf("Memory leak test...\n\n"
         "Nb/ when you're running this test, do a 'cat /proc/<pid>/status\n"
         "and have a look at the VmSize: field to see if the figure grows.\n"
         "It will go up and down during excution, but if it steaderly\n"
         "increases, then you know you have a memory leak.\n\n\n");

  memory_error_cb = fatal_ll_error;
  for(;;)
  {
    register int x;

    printf("Add:");
    fflush(stdout);

    for(x = 0;x < MLEN;x++)
      append_record(x,(random() & MLEN));

    printf("find:");
    fflush(stdout);

    find();

    for(x = 0;x < (MLEN / 8);x++)
      remove_record(random() & MLEN);

    find();

    printf("free");
    fflush(stdout);
    free_records();

    printf("\n");
  }

  return 1;
}
