/*
 * ant - accessnt.com.au overtime calculator.
 * written for trevor hopp's ISP
 * by jason nunn, Jan 2000
 *
 * This software comes under the GNU General Public License.
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define STR_LEN         256
#define STR_USER        32

#define DB_PATH         "./ant.db"
#define USERSTATS_PATH  "/usr/local/sbin/clob_userstats"

char user[STR_LEN];
int t_used = 0,no_calls;
float dl_used,ul_used,ot_rate = 0,ov_rate = 0;

void clear(void)
{
  user[0] = 0;
  t_used = 0;
  no_calls = 0;
  dl_used = 0;
  ul_used = 0;
}

int main(void)
{
  FILE *fp;

  fp = fopen(DB_PATH,"r");
  if(fp == NULL)
    return -1;

  printf(
    "USER         CALLS    TIME    SENT    RCVD   OTIME    OVOL  CTIME"
    "   CVOL CTOTAL\n");

  for(;;)
  {
    char str[STR_LEN + 1],group[STR_USER + 1];
    int h,m,dl_lim;
    register int time_lim;
    FILE *p_fp;

    if(feof(fp))
      break;
    if(fgets(str,STR_LEN,fp) == NULL)
      continue;
    if(str[0] == '#')
      continue;

    if(!strncmp(str,"ot_rate:",8))
    {
      sscanf(str,"%*s %f",&ot_rate);
      continue;
    }

    if(!strncmp(str,"ov_rate:",8))
    {
      sscanf(str,"%*s %f",&ov_rate);
      continue;
    }

    if(sscanf(str,"%s %d:%d %d",group,&h,&m,&dl_lim) != 4)
      continue;
    time_lim = (h * 60) + m;

    sprintf(str,"%s %s",USERSTATS_PATH,group);
    p_fp = popen(str,"r");
    if(p_fp != NULL)
    {
      clear();
      for(;;)
      {
        char str2[STR_LEN + 1],str3[STR_LEN + 1];

        if(feof(p_fp))
          break;

        if(fgets(str,STR_LEN,p_fp) == NULL)
          continue;

        if(strstr(str,"Daemon is down.") != NULL)
        {
          printf(str);
          exit(0);
        }

        if(!strcmp(str,"\n"))
        {
          int   otime;
          float ovolume,ot_charge,ov_charge;

          otime = t_used - time_lim;
          if(otime < 0) otime = 0;
          ovolume = dl_used - dl_lim;
          if(ovolume < 0) ovolume = 0;
          sprintf(str2,"%d:%02d",t_used / 60,t_used % 60);
          sprintf(str3,"%d:%02d",otime / 60,otime % 60);
          ot_charge = ((float)otime * ot_rate) / 60;
          ov_charge = ovolume * ov_rate;
          printf(
            "%-16s%2d%8s%8.2f%8.2f%8s%8.2f%7.2f%7.2f%7.2f\n",
            user,no_calls,str2,ul_used,dl_used,str3,ovolume,
            ot_charge,ov_charge,ot_charge + ov_charge);

          clear();
        }

        if(sscanf(str,"User                : %s",user) == 1)
          continue;

        if(sscanf(str,"Total Connections   : %d",&no_calls) == 1)
          continue;

        if(sscanf(str,"Total Time (hhh:mm) : %d:%d",&h,&m) == 2)
        {
          t_used = (h * 60) + m;
          continue;
        }

        if(sscanf(str,"Total Uploads (Mb)  : %f",&ul_used) == 1)
          continue;

        if(sscanf(str,"Total Dnloads (Mb)  : %f",&dl_used) == 1)
          continue;
      }
      pclose(p_fp);
    }
    else
      exit(0);
  }

  fclose(fp);
  return 0;
}
