/*
 * ant - accessnt.com.au overtime calculator.
 * written for trevor hopp's ISP
 * by jason nunn, Jan 2000
 *
 * This software comes under the GNU General Public License.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define STR_LEN         256
#define STR_USER        32

#define USERSTATS_PATH  "/usr/local/sbin/clob_userstats"

int main(void)
{
  FILE *p_fp;

  p_fp = popen(USERSTATS_PATH,"r");
  if(p_fp != NULL)
  {
    char user[STR_LEN] = "";

    for(;;)
    {
      char str[STR_LEN + 1];

      if(feof(p_fp))
        break;

      if(fgets(str,STR_LEN,p_fp) == NULL)
        continue;

      if(strstr(str,"Daemon is down.") != NULL)
      {
        printf(str);
        exit(0);
      }

      if(!strcmp(str,"\n"))
        user[0] = 0;

      if(sscanf(str,"User                : %s",user) == 1)
        continue;

      if(!strncmp(str,"Total Time (hhh:mm) :",20))
      {
        if(strstr(str,"(Lim: Exempt)") == NULL)
          printf("%s\n",user);
        continue;
      }
    }

    pclose(p_fp);
  }

  return 0;
}
