/*
 * steve- written for tcc-comp.com.au
 * by jason nunn, Feb 2000
 *
 * a program that reads data outputed from clob_userstats, and
 * emails anybody who will expire within 6 days.
 *
 * to use, put program in cron job to be run once a day.
 *
 * to compile: gcc -Wall -O4 steve.c -o steve ; strip steve
 */

#include <stdio.h>
#include <sys/time.h>

#define EXPIRE_GRACE_TIME   6
#define CLOB_USERSTATS_PATH "/usr/local/sbin/clob_userstats"
#define SENDMAIL_PATH       "/usr/sbin/sendmail"

int main(void)
{
  FILE *pfp;

  pfp = popen(CLOB_USERSTATS_PATH,"r");
  if(pfp == NULL)
  {
    printf("Error: getting output from clob_userstats, aborting.\n");
    return -1;
  }

  for(;;)
  {
    struct tm e_tm;
    int dt;
    char user[33],str[256];

    if(feof(pfp))
      break;

    if(fgets(str,255,pfp) == NULL)
      continue;

    if(sscanf(str,"User                : %s",user) == 1)
      continue;

    if(sscanf(str,"Expiry Date         : %d:%d:%d",
      &(e_tm.tm_mday),&(e_tm.tm_mon),&(e_tm.tm_year)) != 3)
      continue;

    if((e_tm.tm_mday < 1) || (e_tm.tm_mday > 31))
      continue;
    if((e_tm.tm_mon < 0) || (e_tm.tm_mon > 11))
      continue;
    if(e_tm.tm_year < 1900)
      continue;

    e_tm.tm_mon--;
    e_tm.tm_year -= 1900;
    e_tm.tm_sec = 0;
    e_tm.tm_min = 0;
    e_tm.tm_hour = 0;

    dt = (mktime(&e_tm) - time(NULL)) / (60 * 60 * 24);
    printf("%-32s will expire in %02d days. ",user,dt);
    if(dt == EXPIRE_GRACE_TIME)
    {
      FILE *sfp;

      printf("mailing..");
      sprintf(str,"%s %s",SENDMAIL_PATH,user);
      sfp = popen(str,"w");
      if(sfp != NULL)
      {
        fprintf(sfp,
          "from: Steve Walsh <curl@tcc-comp.com.au>\n"
          "subject: expiry date near.\n"
          "\n"
          "Dear %s,\n"
          "\n"
          "Your account will expire in %d days.\n"
          "This is a automatically generated notification message.\n"
          "\n"
          "--\n"
          "steve\n",
          user,dt);
        pclose(sfp);
        printf("done\n");
      }
      else
        printf("Failed.\n");
    }
    else
      printf("Not emailed.\n");
  }
  pclose(pfp);

  return 1;
}
