/***************************************************************************
****************************************************************************
****************************************************************************
*
* killuser - By Jason Nunn
* Copyright 2000 (C) Jason Nunn
*
* killuser comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <utmp.h>
#include <pwd.h>
#include <dirent.h>
#include <signal.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/stat.h>
#include "defs.h"

char *username = NULL;
int sig = SIGKILL;

/***************************************************************************
* signal utmp login processes only
***************************************************************************/
void kill_logins_only(void)
{
  setutent();
  for(;;)
  {
    struct utmp *utmp_ptr;

    utmp_ptr = getutent();
    if(utmp_ptr == NULL)
      break;
    if(utmp_ptr->ut_type == USER_PROCESS)
      if(!strncmp(utmp_ptr->ut_user,username,UT_NAMESIZE))
        if(killpg(utmp_ptr->ut_pid,sig) == -1)
          perror("Error killpg()");
  }
  endutent();
}

/***************************************************************************
* singal all user processes, blow everything out of the water
***************************************************************************/
void kill_all_user_ps(void)
{
  DIR *dp;
  struct passwd *pw;

  pw = getpwnam(username);
  if(pw != NULL)
  {
    if((dp = opendir("/proc")) != NULL)
    {
      for(;;)
      {
        int e_pid;
        struct dirent *dir_entry;

        dir_entry = readdir(dp);
        if(dir_entry == NULL)
          break;

        if(sscanf(dir_entry->d_name,"%d",&e_pid))
        {
          char str[STR_LEN];
          struct stat statbuf;

          strcpy(str,"/proc/");
          strcat(str,dir_entry->d_name);
          if((lstat(str,&statbuf) != -1) && (pw->pw_uid == statbuf.st_uid))
            if(kill(e_pid,sig) == -1)
              perror("Error kill()");
        }
      }
      closedir(dp);
    }
  }
}

/***************************************************************************
*
***************************************************************************/
void print_help(void)
{
  printf(
    "Killuser " VERSION ", (C) 2000 Jason Nunn <jsno@downunder.net.au>\n\n"
    "  Usage: killuser -h -[la] -d <delay> -<signal> <user>\n"
    "\n");
  exit(0);
}

int main(int argc,char *argv[])
{
  register int x,kill_logins_f = 0,delay = 0;

  for(x = 1;x < argc;x++)
  {
    if(argv[x][0] == '-')
    {
      if(argv[x][1] == 'h')
        print_help();
      else if(isdigit(argv[x][1]))
      {
        sig = atoi(argv[x] + 1);
        continue;
      }
      else if(argv[x][1] == 'l')
      {
        kill_logins_f = 1;
        continue;
      }
      else if(argv[x][1] == 'd')
      {
        if((x + 1) < argc)
          delay = atoi(argv[x + 1]);
        continue;
      }
    }
    else
      username = argv[x];
  }

  if(username == NULL)
  {
    print_help();
    exit(-1);
  }

  sleep(delay);
  if(kill_logins_f)
    kill_logins_only();
  else
    kill_all_user_ps();

  return 0;
}
