#include <stdio.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
#include "net_client_wrapper.h"
#include "userstat_sub.h"
#include "misc.h"

void display_gstat(void)
{
  char str[STR_LEN];
  register int x;

  printf("Memory Used              : %dk\n",gstat.mem_used);
  printf("Total UM Entries         : %d\n",gstat.total_users);
  printf("Active Users             : %d\n",gstat.no_active);
  printf("Active Network Conn's    : %d\n\n",gstat.no_kons);

  if(gstat.no_free_dialins == -1)
    strcpy(str,na_label);
  else
    sprintf(str,"%d",gstat.no_free_dialins);
  printf("Number of free dialins   : %s\n",str);

  printf("Daily Connections        : %d\n",gstat.d_connections);
  printf("Total Connections        : %d\n",gstat.t_connections);
  printf("Avg Daily Connections    : %d\n",gstat.avg_d_connections);
  printf("Avg Total Connections    : %d\n",gstat.avg_t_connections);

  str_hh_mm(gstat.avg_s_time,str);
  printf("Avg Session Time         : %s\n",str);

  str_hh_mm(gstat.avg_d_time,str);
  printf("Avg Daily Time           : %s\n",str);

  str_hh_mm(gstat.avg_t_time,str);
  printf("Avg Total Time           : %s\n",str);

  printf("Daily Traffic       (Mb) : %.2f\n",rnd2meg64(gstat.d_traffic));
  printf("Total Traffic       (Mb) : %.2f\n",rnd2meg64(gstat.t_traffic));
  printf("Avg Session Traffic (Mb) : %.2f\n",rnd2meg64(gstat.avg_s_traffic));
  printf("Avg Daily Traffic   (Mb) : %.2f\n",rnd2meg64(gstat.avg_d_traffic));
  printf("Avg Total Traffic   (Mb) : %.2f\n\n",rnd2meg64(gstat.avg_t_traffic));

  for(x = 0;x < 24;x++)
    printf("Connection Tally %02d Hr   : %d\n",x,gstat.hour_tally[x]);
}

int main(int argc,char *argv[])
{
  register int x;

  for(x = 1;x < argc;x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          printf(
            WELCOME DISCLAIMER
            "Usage: clob_gstat <options>\n"
            " -h          Display this help info\n"
            " -a <host>   Hostname to connect to (default: localhost)\n"
            "\n");
          return 0;
        case 'a':
          if((x + 1) < argc)
          {
            addr = argv[x + 1];
            x++;
          }
          break;
      }
    }
  }

  init_and_connect();
  net_get_gstat();
  net_put_cmd(cmd_quit);
  display_gstat();

  return 0;
}
