#include <stdio.h>
#include <stdlib.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
#include "net_client_wrapper.h"
#include "misc.h"

int main(int argc,char *argv[])
{
  char *username = NULL;
  register int x,func = 0;

  for(x = 1;x < argc;x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          printf(
            WELCOME DISCLAIMER
            "Usage: clob_lists <options>\n"
            " -h          Display this help info\n"
            " -a <host>   Hostname to connect to (default: localhost)\n"
            " -t          User List (Total Time Used)\n"
            " -v          User List (Total Network Volume)\n"
            " -e          User List (Connection Efficiency)\n"
            "\n");
          return 0;
        case 'a':
          if((x + 1) < argc)
          {
            addr = argv[x + 1];
            x++;
          }
          break;
        case 't':
          func = 1;
          break;
        case 'v':
          func = 2;
          break;
        case 'e':
          func = 3;
          break;
      }
    }
    else
    {
      username = argv[x];
      break;
    }
  }

  if(!func)
  {
    printf("Missing parameter. Aborting.\n");
    exit(-1);
  }

  init_and_connect();

  switch(func)
  {
    case 1:
      printf(" User                             HH:MM\n");
      net_put_cmd(cmd_ul_ttu);
      break;
    case 2:
      printf(" User                             Mb\n");
      net_put_cmd(cmd_ul_tnv);
      break;
    case 3:
      printf(" User                             Ce\n");
      net_put_cmd(cmd_ul_cef);
      break;
  }
  for(;;)
  {
    char str[STR_LEN_LN + 1];
    int status;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
      break;
    if(str[0] == ':')
      printf("%s\n",str + 1);
  }
  net_put_cmd(cmd_quit);

  return 0;
}

