#include <stdio.h>
#include <stdlib.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
#include "net_client_wrapper.h"
#include "userstat_sub.h"
#include "misc.h"

int main(int argc,char *argv[])
{
  char *username = NULL;
  register int x;

  for(x = 1;x < argc;x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          printf(
            WELCOME DISCLAIMER
            "Usage: clob_userstat <options> <username>\n"
            " -h          Display this help info\n"
            " -a <host>   Hostname to connect to (default: localhost)\n"
            "\n");
          return 0;
        case 'a':
          if((x + 1) < argc)
          {
            addr = argv[x + 1];
            x++;
          }
          break;
      }
    }
    else
    {
      username = argv[x];
      break;
    }
  }

  if(username == NULL)
  {
    printf("Missing username parameter. Aborting.\n");
    exit(-1);
  }

  init_and_connect();
  if(net_get_us_hr() == CO_SUCCESSFUL)
    user_stat(username);
  net_put_cmd(cmd_quit);

  return 0;
}
