/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* clob_userstats
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <string.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/ll_bt.h"
#include "../common/common_client.h"
#include "net_client_wrapper.h"
#include "userstat_sub.h"
#include "misc.h"

typedef struct
{
  char user[STR_USER_LEN + 1];
} tuser;

tll *user_ll = NULL;

/***************************************************************************
*
***************************************************************************/
void append_user(char *name)
{
  tuser user;

  int cmp_func(tll *n)
  {
    if(strcmp(name,((tuser *)(n->entry))->user) < 0)
      return 1;
    return 0;
  }

  strcpy(user.user,name);
  ll_append_sorted(&user_ll,&user,sizeof(tuser),cmp_func);
}

void list_stats(void)
{
  tll *user_ll2;

  user_ll2 = user_ll;
  for(;;)
  {
    tuser *p;

    p = ll_read_entry(&user_ll2);
    if(p == NULL)
      break;
    user_stat(p->user);
  }
}

void get_all_users(void)
{
  net_put_cmd(cmd_gumu);
  for(;;)
  {
    char str[STR_LEN_LN + 1];
    int status;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
      break;
    if(str[0] == ':')
      append_user(str + 2);
  }

  list_stats();
}

void get_group(char *groupname)
{
  char str[STR_LEN_LN + 1];

  sprintf(str,"%s %s",cmd_gusug,groupname);
  net_put_cmd(str);
  for(;;)
  {
    int status;

    net_get_entry(str);
    if(net_parse_ret_code(str,&status))
      break;
    if(str[0] == ':')
      append_user(str + 2);
  }

  list_stats();
}

/***************************************************************************
*
***************************************************************************/
int main(int argc,char *argv[])
{
  char *groupname = NULL;
  register int x;

  for(x = 1;x < argc;x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          printf(
            WELCOME DISCLAIMER
            "Usage: clob_userstats <options> <groupname>\n"
            " -h          Display this help info\n"
            " -a <host>   Hostname to connect to (default: localhost)\n"

            "\n");
          return 0;
        case 'a':
          if((x + 1) < argc)
          {
            addr = argv[x + 1];
            x++;
          }
          break;
      }
    }
    else
    {
      groupname = argv[x];
      break;
    }
  }

  init_and_connect();
  if(groupname == NULL)
    get_all_users();
  else
    get_group(groupname);

  net_put_cmd(cmd_quit);

  return 0;
}
