/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* wrapper functions for common_client networking routines.
*
* printf wrapper
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"

/***************************************************************************
*
***************************************************************************/
void fatal_memory_error_cb(void)
{
  printf("Fatal malloc() error. Unable to alloc memory. Aborting.\n");
  exit(-1);
}

void net_get_entry_cb(void)
{
  printf("Error: Network Error. Aborting.\n");
  exit(-1);
}

/***************************************************************************
* cmd wrappers
***************************************************************************/
int net_get_us_hr(void)
{
  register int s;

  s = common_net_get_us_hr();
  if(s == CO_RECORD_LOCKED)
    printf("General Settings locked.\n");
  return s;
}

int net_get_us(char *user,int type)
{
  return common_net_get_us(user,type);
}

int net_get_um(char *user)
{
  register int s;

  s = common_net_get_um(user);
  if(s == CO_RECORD_LOCKED)
    printf("'%s' is locked.\n",user);

  return s;
}

int net_get_gstat(void)
{
  return common_net_get_gstat();
}

void net_get_stime(int *s,int *t)
{
  common_net_get_stime(s,t);
}

void net_tpurge(void)
{
  if(common_net_tpurge() == CO_RECORD_LOCKED)
    printf("Unable to perform Total Purge. Record locks exist.\n");
}

void net_dpurge(void)
{
  if(common_net_dpurge() == CO_RECORD_LOCKED)
    printf("Unable to perform Daily Purge. Record locks exist.\n");
}

void net_archive(void)
{
  common_net_archive();
}
