/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* sub routines for clob_dpurge
*
* this is a set of routines at can be applied to other utilties with the
* same parameter requirement.
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
#include "net_client_wrapper.h"
#include "misc.h"

void print_help(char *pn)
{
  printf(
    WELCOME DISCLAIMER
    "Usage: %s <options>\n"
    " -h          Display this help info\n"
    " -a <host>   Hostname to connect to (default: localhost)\n"
    " -p <passwd> Password\n"
    "\n",pn);
}

void purge_sub(int argc,char *argv[])
{
  char str[STR_LEN_LN],password[STR_GEN_LEN + 1] = "";
  register int x;

  for(x = 1;x < argc;x++)
  {
    if(argv[x][0] == '-')
    {
      switch(argv[x][1])
      {
        case 'h':
          print_help(argv[0]);
          exit(0);
        case 'a':
          if((x + 1) < argc)
            addr = argv[x + 1];
          break;
        case 'p':
          if((x + 1) < argc)
          {
            /*
             * blott out password so no one can see it in process table
             */
            strncpy(password,argv[x + 1],STR_GEN_LEN);
            password[STR_GEN_LEN] = 0;
            memset(argv[x + 1],'*',strlen(password));
          }
          break;
      }
    }
  }

  if(!password[0])
  {
    printf("Missing password parameter. Aborting.\n");
    exit(-1);
  }

  init_and_connect();

  sprintf(str,"%s %s",cmd_pass,password);
  net_put_cmd(str);
  if(net_get_ret() != CO_SUCCESSFUL)
  {
    printf("Password incorrect. Aborting program.\n");
    exit(-1);
  }
}
