/***************************************************************************
****************************************************************************
****************************************************************************
*
* Clobberd - By Jason Nunn
* Copyright (C) Jason Nunn
*
* Clobberd comes under the GNU General Public License. Please read the
* COPYING notice in this distribution.
*
* ================================================================
* userstat sub routines
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "../common/defs.h"
#include "../common/common.h"
#include "../common/common_client.h"
#include "net_client_wrapper.h"

void user_stat(char *user)
{
  char str1[STR_LEN],str2[STR_LEN],*str3,str4[STR_LEN];
  double i;
  register int us_f = 0;

  void na_strs(void)
  {
    strcpy(str1,na_label);
    strcpy(str2,na_label);
  }

  void exempt_strs(void)
  {
    strcpy(str1,exempt_label);
    strcpy(str2,exempt_label);
  }

  double diff_v(double lim,double used)
  {
    double x;

    x = lim - used;
    if(x < 0)
      x = 0;
    return x;
  }

  if(net_get_um(user) != CO_SUCCESSFUL)
    return;

  if(net_get_us(user,1) == CO_SUCCESSFUL)
    us_f = 1;

  printf("User                : %s\n",um.user);

  str3 = ctime((time_t *)&(um.last_active));
  if(str3 != NULL)
    printf("Last On             : %s",str3);

  printf("Total Connections   : %d\n",um.t_connections);
  printf("Daily Connections   : %d\n",um.d_connections);

  str_hh_mm(us_hr.grace_time,str2);
  printf("Grace Time          : %s\n",str2);

  printf("Grace Volume (Mb)   : %d\n",us_hr.grace_volume);

  if(us_hr.flags.flag.min_free_dialin_exempt)
    strcpy(str2,exempt_label);
  else
    sprintf(str2,"%d",us_hr.min_free_dialins);
  printf("Minimum Free Dialins: %s\n",str2);

  if(!us_f)
    strcpy(str2,na_label);
  else
    if(us.flags.flag.exempt_act_timeout)
      strcpy(str2,exempt_label);
    else
      str_hh_mm(us.act_timeout,str2);
  printf("Activity Timeout    : %s\n",str2);

  if(!us_f)
    strcpy(str2,na_label);
  else
    if(us.flags.flag.exempt_expiry_date)
      strcpy(str2,exempt_label);
    else
      compose_date(&(us.expiry_date),str2);
  printf("Expiry Date         : %s\n",str2);

  if(!us_f)
    strcpy(str2,na_label);
   else
     if(us.flags.flag.exempt_nice)
       strcpy(str2,exempt_label);
     else
       sprintf(str2,"%d",us.nice_factor);
  printf("Niceness            : %s\n",str2);

/* TT used*/
  str_hh_mm(um.tt_used,str4);
  if(!us_f)
    na_strs();
  else
  {
    if(us.flags.flag.exempt_total_time)
      exempt_strs();
    else
    {
      str_hh_mm(diff_v(us.tt_lim,um.tt_used),str1);
      str_hh_mm(us.tt_lim,str2);
    }
  }
  printf("Total Time (hhh:mm) : %s (Left: %s) (Lim: %s)\n",str4,str1,str2);

/* TD used*/
  str_hh_mm(um.dt_used,str4);
  if(!us_f)
    na_strs();
  else
    if(us.flags.flag.exempt_daily_time)
      exempt_strs();
    else
    {
      if(um.dt_zone_limit == -1)
        na_strs();
      else
      {
        str_hh_mm(diff_v(um.dt_set_limit,um.dt_used),str1);
        str_hh_mm(um.dt_set_limit,str2);
      }
    }
  printf("Daily Time (hhh:mm) : %s (Left: %s) (Lim: %s)\n",str4,str1,str2);

/*t_ul*/
  i = rnd2meg64(um.t_ul);
  if(!us_f)
    na_strs();
  else
    if(us.flags.flag.exempt_total_ul_lim)
      exempt_strs();
    else
    {
      sprintf(str1,"%.2f",diff_v(us.t_ul_lim,i));
      sprintf(str2,"%d",us.t_ul_lim);
    }
  printf("Total Uploads (Mb)  : %.2f (Left: %s) (Lim: %s)\n",i,str1,str2);

/*t_dl*/
  i = rnd2meg64(um.t_dl);
  if(!us_f)
    na_strs();
  else
    if(us.flags.flag.exempt_total_dl_lim)
      exempt_strs();
    else
    {
      sprintf(str1,"%.2f",diff_v(us.t_dl_lim,i));
      sprintf(str2,"%d",us.t_dl_lim);
    }
  printf("Total Dnloads (Mb)  : %.2f (Left: %s) (Lim: %s)\n",i,str1,str2);

/*d_ul*/
  i = rnd2meg64(um.d_ul);
  if(!us_f)
    na_strs();
  else
    if(us.flags.flag.exempt_daily_ul_lim)
      exempt_strs();
    else
    {
      sprintf(str1,"%.2f",diff_v(us.d_ul_lim,i));
      sprintf(str2,"%d",us.d_ul_lim);
    }
  printf("Daily Uploads (Mb)  : %.2f (Left: %s) (Lim: %s)\n",i,str1,str2);

/*d_dl*/
  i = rnd2meg64(um.d_dl);
  if(!us_f)
    na_strs();
  else
    if(us.flags.flag.exempt_daily_dl_lim)
      exempt_strs();
    else
    {
      sprintf(str1,"%.2f",diff_v(us.d_dl_lim,i));
      sprintf(str2,"%d",us.d_dl_lim);
    }
  printf("Daily Dnloads (Mb)  : %.2f (Left: %s) (Lim: %s)\n",i,str1,str2);

/**/
  if(!us_f)
    strcpy(str2,na_label);
  else
    strcpy(str2,us.flags.flag.instant_purge_dt ? yes_label : no_label);
  printf("Purge Daily Settings: %s\n",str2);

  if(!us_f)
    strcpy(str2,na_label);
  else
    strcpy(str2,us.flags.flag.clobber_mult_logins ? yes_label : no_label);
  printf("Kill Multiple logins: %s\n",str2);

  if(!us_f)
    strcpy(str2,na_label);
  else
    strcpy(str2,us.flags.flag.banned ? yes_label : no_label);
  printf("Banned              : %s\n",str2);

  printf("\n");
}
