/* debug.c -- Parallel Libra Tester debug routines.
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 01/08/96
 * Update:   29/08/96
 * V1.0 PV003
 * NOTES
 * BUGS
 * TODO
 *    - debug_perror implementation
 * MODIFICATION-HISTORY
 *    10/12/98  schaefer Applying new RCS scheme.
 * $Id: debug.c,v 1.1 1998/12/10 17:22:43 schaefer Exp $
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "types.h"
#include "debug_if.h"

/* Private type definitions */

/* Private function definitions */

/* Private variables */

/* Function implementation */

char *debug_level_descr(debug_level_t level) {
   switch (level) {
      case DEBUG_INFO:  return "INFO";
                        break;
      case DEBUG_NOTICE:  return "NOTICE";
                        break;
      case DEBUG_WARN:  return "WARN";
                        break;
      case DEBUG_ERROR: return "ERROR";
                        break;
      case DEBUG_FATAL: return "FATAL";
                        break;
      default:          return "UNKNOWN";
                        break;
   }
   /* NOT REACHED */
}

char *debug_perror(void) {
   return strerror(errno);
}


