#ifndef DEBUG_IF_H
#define DEBUG_IF_H
/* debug_if.h -- Parallel Libra Tester debug definitions.
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 01/08/96
 * Update:   29/08/96
 * V1.0 PV003
 * NOTES
 *    - debug_level, of type debug_level_t, is used by this module.
 *      see main.c
 *    - no parallelism protection. Output might be mixed.
 * BUGS
 * TODO
 * MODIFICATION-HISTORY
 *    10/12/98  schaefer Applying new RCS scheme.
 * $Id: debug_if.h,v 1.1 1998/12/10 17:22:35 schaefer Exp $
 */

/* Type definitions */
typedef enum { DEBUG_INFO,
	       DEBUG_NOTICE,
               DEBUG_WARN,
               DEBUG_ERROR,
               DEBUG_FATAL
              } debug_level_t;


/* Macros */
#define DEBUG_FORMAT "[%s] %s/%s %s: %s.\n"

#define DEBUG_LEVEL_DESCR(level) debug_level_descr(level)

#define MESSAGE_PERROR debug_perror()

#define MESSAGE(level, module, file, operation, description) \
   if (debug_level <= level) { \
      fprintf(stderr, DEBUG_FORMAT, \
              DEBUG_LEVEL_DESCR(level), \
              module, file, operation, description); \
      fflush(stderr); \
   }

#define MESSAGE_SIMPLE(level, text) \
   if (debug_level <= level) { \
      fprintf(stderr, "%s", text); \
      fflush(stderr); \
   }

#define IFDEBUG(level) if (debug_level <= level) {
#define ENDIFDEBUG }

/* External variables */

#ifndef debug_level
extern debug_level_t debug_level;
#endif

/* Fonction definitions */

/* NAME
 *    debug_level_descr
 * DESCRIPTION
 *    Translates a debug_level_t to a string.
 * RESULT
 *    (null terminated) constant string
 * NOTES
 * BUGS
 * TODO
 */
char *debug_level_descr(debug_level_t level);

/* NAME
 *    debug_perror
 * DESCRIPTION
 *    Gives perror as a string.
 * RESULT
 *    (null terminated) constant string
 * NOTES
 *    - Use locally allocated storage which is overwritten
 *      at each call.
 * BUGS
 * TODO
 */
char *debug_perror(void);

#endif
