#ifndef MC_IF_H
#define MC_IF_H
/* mc_if.h -- Parallel Libra Tester Medium Changer Object definitions.
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 01/08/96
 * Update:   09/09/96
 * V1.0 PV005
 * NOTES
 * BUGS
 * TODO
 * MODIFICATION-HISTORY
 *    10/12/98  schaefer Applying new RCS scheme.
 * $Id: mc_if.h,v 1.1 1998/12/10 17:07:28 schaefer Exp $
 */

/* Type definitions */

#define MC_ELEMENT_INVALID 255 /* should be enforced */
typedef unsigned char mc_element_t;

typedef enum { MC_RESULT_OK,
               MC_RESULT_SCSI_ERROR1, /* scsi.c low level */
               MC_RESULT_SCSI_ERROR2, /* errcode, device specific */
               MC_RESULT_SCSI_NOT_READY,
               MC_RESULT_SCSI_HARD_ERROR,
               MC_RESULT_SCSI_ILLEGAL,
               MC_RESULT_SCSI_ATTENTION,
               MC_RESULT_FATAL
             } mc_result_t;

/* Macros */

#define MC_ELEMENT_TO_STRING(x) mc_element_to_string(x)
#define MC_RESULT_DESCR(r) mc_result_descr(r)

/* Function definitions */

/* NAME
 *    mc_set_mc_device
 * DESCRIPTION
 *    Sets the Medium Changer UNIX device name.
 * RESULT
 *    void
 * NOTES
 * BUGS
 * TODO
 */
void mc_set_mc_device(char *device_name);

/* NAME
 *    mc_set_tape_device
 * DESCRIPTION
 *    Sets the Storage Element UNIX device name.
 * RESULT
 *    void
 * NOTES
 * BUGS
 * TODO
 */
void mc_set_tape_device(char *device_name, mc_element_t elt);

/* NAME
 *    mc_element_to_string
 * DESCRIPTION
 *    Gives a string representation of an element.
 * RESULT
 *    (null terminated) constant string
 * NOTES
 *    - Use locally allocated storage which is overwritten
 *      at each call. 
 * BUGS
 * TODO
 */
char *mc_element_to_string(mc_element_t e);

/* NAME
 *    mc_result_descr
 * DESCRIPTION
 *    Gives a string representation of a MC error.
 * RESULT
 *    (null terminated) constant string
 * NOTES
 * BUGS
 * TODO
 */
char *mc_result_descr(mc_result_t result);

/* NAME
 *    mc_data_transfer_element_to_device
 * DESCRIPTION
 *    Gives UNIX filename for a given data transfer element.
 * RESULT
 *    (null terminated) constant string or NULL
 * NOTES
 *    - Use locally allocated storage which is overwritten
 *      at each call. 
 * BUGS
 * TODO
 */
char *mc_data_transfer_element_to_device(mc_element_t storage_element);

/* NAME
 *    mc_get_data_transfer_elements
 * DESCRIPTION
 *    Fills in number limited array of available tape drive elements
 *    and status (full, empty). NULL pointers are handled correctly,
 *    like 0 number.
 * RESULT
 *    MC_RESULT_OK if everything ok, else mc_result_t.
 * NOTES
 * BUGS
 * TODO
 */
mc_result_t mc_get_data_transfer_elements(mc_element_t *array, int number,
                                          BOOL *tape_full_array);

/* NAME
 *    mc_storage_elements
 * DESCRIPTION
 *    Fills in number limited array of available storage elements.
 *    and status (full, empty). NULL pointers are handled correctly,
 *    like 0 number. 
 * RESULT
 *    MC_RESULT_OK if everything ok, else mc_result_t.
 * NOTES
 * BUGS
 * TODO
 */
mc_result_t mc_storage_elements(mc_element_t *array, int number,
                                BOOL *elt_full_array);


/* NAME
 *    mc_initialize
 * DESCRIPTION
 *    Executes a INITIALIZE_ELEMENT_STATUS command.
 * RESULT
 *    MC_RESULT_OK if everything ok, else mc_result_t.
 * NOTES
 * BUGS
 * TODO
 */
mc_result_t mc_initialize(void);

/* NAME
 *    mc_unload
 * DESCRIPTION
 *    Unloads the pack.
 * RESULT
 *    MC_RESULT_OK if everything ok, else mc_result_t.
 * NOTES
 * BUGS
 * TODO
 */
mc_result_t mc_unload(void);

/* NAME
 *    mc_move_medium
 * DESCRIPTION
 *    Executes the MOVE_MEDIUM command.
 * RESULT
 *    MC_RESULT_OK if everything ok, else mc_result_t.
 * NOTES
 * BUGS
 * TODO
 */
mc_result_t mc_move_medium(mc_element_t transport_element,
                           mc_element_t source_address,
                           mc_element_t destination_address);

/* NAME
 *    mc_position
 * DESCRIPTION
 *    Executes the POSITION command.
 * RESULT
 *    MC_RESULT_OK if everything ok, else mc_result_t.
 * NOTES
 *    - This is mainly needed for dumb autochangers which have no
 *      abilility to eject the drive by themselves, such as the Adic.
 *      Those need a POSITION for the drive, then a POSITION for the
 *      pack, then an EJECT via SCSI to the drive, and then the MOVE MEDIUM.
 *      The Libra OL8, OL16 and NTL series want just the MOVE MEDIUM.
 * BUGS
 * TODO
 */
mc_result_t mc_position(mc_element_t transport_element,
                        mc_element_t destination_address);


/* NAME
 *    mc_read_element_status
 * DESCRIPTION
 *    Executes the read element status and updates various
 *    structures pointed to, if they are not NULL.
 *    Arrays will be terminated by an invalid element if
 *    necessary. If dump is TRUE, will also print to the screen
 *    in a libra2 compatible fashion.
 * RESULT
 *    MC_RESULT_OK if everything ok, else mc_result_t.
 * NOTES
 * BUGS
 *    - Overflow would simply not signal, but will not overwrite
 *      innocent memory if the num_XXX are right.
 *    - Too much magic inside
 * TODO
 */
mc_result_t mc_read_element_status(mc_element_t *stg_elt_array,
                                   int num_stg_elt,
                                   BOOL *full_stg,
                                   mc_element_t *xfer_elt_array,
                                   int num_xfer_elt,
                                   BOOL *full_xfer_array,
                                   BOOL dump);

/* NAME
 *    mc_inquiry
 * DESCRIPTION
 * RESULT
 * NOTES
 * BUGS
 * TODO
 */
mc_result_t mc_inquiry(char *buffer, int *len);

#define MC_SCSI_INQUIRY_VENDOR 8
#endif
