/* mt_operations_if.h -- Common ``mt''-like operations interface definitions.
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 12/11/96
 * Update:   12/11/96
 * V1.0 PV001
 * DESCRIPTION
 *    This module is a low-cost, fast replacement to the old mt script
 *    for common tape operations.
 * NOTES
 * BUGS
 * TODO
 * MODIFICATION-HISTORY
 *    10/12/98  schaefer Applying new RCS scheme.
 * $Id: mt_operations_if.h,v 1.1 1998/12/10 17:22:15 schaefer Exp $
 */
#ifndef MT_OPERATIONS_IF_H
#define MT_OPERATIONS_IF_H

/* Type definitions */

/* Fonction definitions */

/* NAME
 *    mt_do
 * DESCRIPTION
 *    Ensures the tape is online and the block size is variable.
 * RESULT
 *    TRUE if ok.
 * NOTES
 * BUGS
 * TODO
 */
BOOL mt_do(char *tape);

/* NAME
 *    mt_is_online
 * DESCRIPTION
 *    Returns TRUE if the tape is online. If the argument do_wait is
 *    TRUE, waits til online.
 * RESULT
 *    TRUE if online.
 * NOTES
 * BUGS
 * TODO
 */
BOOL mt_is_online(char *tape, BOOL do_wait);

/* NAME
 *    mt_setblk
 * DESCRIPTION
 *    Returns TRUE if the setblk command succeeded.
 * RESULT
 *    TRUE if setblk succeeded.
 * NOTES
 * BUGS
 * TODO
 */
BOOL mt_setblk(char *tape, int block_size);

/* NAME
 *    mt_get_retry_count
 * DESCRIPTION
 *    Returns the retry count of the drive.
 * RESULT
 *    -1 if no retry count could be returned.
 * NOTES
 * BUGS
 * TODO
 */
int mt_get_retry_count(char *tape);

#endif
