#ifndef PLT_IF_H
#define PLT_IF_H
/* plt_if.h -- Parallel Libra Tester definitions.
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 01/08/96
 * Update:   10/12/98
 * V1.0 PV004
 * NOTES
 * BUGS
 * TODO
 * MODIFICATION-HISTORY
 *    10/12/98  schaefer  Implemented POSITION for Adic
 * $Id: plt_if.h,v 1.1 1998/12/10 17:05:52 schaefer Exp $
 */

typedef enum { PLT_DO_RANDOM,
               PLT_DO_SEQ,
               PLT_DO_QUICK,
               PLT_DO_SEQUENTIAL_H, /* non portable */
               PLT_DO_SEQUENTIAL_L, /* non portable */
               PLT_DO_16x16,
               PLT_DO_ADSM_1,
               PLT_DO_ADSM_2,
               PLT_DO_LABEL,
             } plt_do_t;

typedef enum { PLT_CMD_UNLOAD,
               PLT_CMD_LOAD,
               PLT_CMD_MOVE_MEDIUM,
               PLT_CMD_POSITION
             } plt_dir_cmd_t;

typedef struct {
   plt_dir_cmd_t cmd;
   int arg1, arg2, arg3;
} plt_direct_cmd_t;

/* Type definitions */
typedef enum { TEST_SUCCEEDED,
               TEST_FAILED,
               TEST_FATAL /* software error */
             } plt_test_result_t;

/* Communication with the tape objects */
typedef enum { PLT_CMD_GET_TAPE,
               PLT_CMD_GIVE_TAPE,
               PLT_CMD_FAIL, /* non correctable media errors */
               PLT_CMD_FATAL, /* fatal software error */
               PLT_CMD_ENDING
             } plt_cmd_t;

typedef enum { PLT_RESULT_OK,
               PLT_RESULT_END
             } plt_result_t;

typedef struct {
   plt_result_t result;
   int arg;
} plt_to_tape_t;

/* Macros */

#define PLT_PLT_CMD_TO_STRING(x) (x == PLT_CMD_GET_TAPE) ? "GET_TAPE" \
                                  : (x == PLT_CMD_GIVE_TAPE) ? "GIVE_TAPE" \
                                  : (x == PLT_CMD_FAIL) ? "FAIL" \
                                  : (x == PLT_CMD_FATAL) ? "FATAL" \
                                  : (x == PLT_CMD_ENDING) ? "ENDING" : "UNK"

/* Fonction definitions */

/* NAME
 *    plt_initialize
 * DESCRIPTION
 *    This function initializes the plt module and does a get element
 *    status. If the argument get_tapes is true, we start by getting
 *    all tapes in place. If the second argument skip_initialization is
 *    true, we do not ask the library to verify its element status.
 *    However we still initialize the elements.
 * RESULT
 *    BOOL
 * NOTES
 * BUGS
 * TODO
 */
BOOL plt_initialize(BOOL get_tapes, BOOL skip_initialization);

/* NAME
 *    plt_do_test
 * DESCRIPTION
 *    This function performs the Parallel Libra Test specified
 *    and returns its result.
 * RESULT
 *    plt_test_result_t
 * NOTES
 *    - Implement time limit, see specification ../SPEC
 * BUGS
 * TODO
 */
plt_test_result_t plt_do(plt_do_t what);


/* NAME
 *    plt_direct_command
 * DESCRIPTION
 *    This function performs a direct command returns its result.
 * RESULT
 *    BOOL
 * NOTES
 * BUGS
 * TODO
 */
BOOL plt_direct_command(plt_direct_cmd_t cmd);

#endif
