/* process.c -- Parallel Libra Tester process routines.
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 01/08/96
 * Update:   01/08/96
 * V1.0 PV001
 * NOTES
 * BUGS
 *    - should also implement the end and the wait()
 * TODO
 * MODIFICATION-HISTORY
 *    10/12/98  schaefer Applying new RCS scheme.
 * $Id: process.c,v 1.1 1998/12/10 17:22:05 schaefer Exp $
 */

#include <stdio.h>
#include <unistd.h>
#include "types.h"
#include "debug_if.h"
#include "process_if.h"

BOOL process_create(fd_t from_father, fd_t to_father,
                    fd_t close_me1, fd_t close_me2,
                    void entry_point(fd_t from_father, fd_t to_father)) {

   switch (fork()) {
      case -1:
         MESSAGE(DEBUG_FATAL, "plt", "process", "fork()", 
                 MESSAGE_PERROR);
         return FALSE;
         break;
      case 0:
         /* CHILD */
         MESSAGE(DEBUG_INFO, "plt", "process", "child", "born");
         close(close_me1);
         close(close_me2);
         entry_point(from_father, to_father);
         exit(0);
         break;
      default:
         close(from_father);
         close(to_father);
         return TRUE;
         break;
   }
   /* NOT REACHED */
}
