#! /bin/sh

# $Id: adic_browse.sh,v 1.1 1998/12/10 17:05:11 schaefer Exp $

PLT=./plt
DRIVE_A=/dev/st0 # Element 2
DRIVE_B=/dev/st1 # Element 3
CHANGER=/dev/sgc
ELEMENT_DRIVE_A=2
ELEMENT_DRIVE_B=3
FIRST_SLOT=15 # really 4
LAST_SLOT=18
DEBUG=WARN

# For ADIC, both yes. For DILOG NTL or OL8 would be both no.
MANUAL_EJECT=yes
POSITIONNING=yes

# Check the drive after insert ?  For ADIC or DILOG OL8, set to yes.
# For DILOG NTL, set to no (yes also works).
CHECK_DRIVE=yes

# We wait upto this time on load for the tape to be ready.
# BUGS
#    - At this time no real timeout on changer.
MAX_RETRIES=30
CHECK_SLEEP_DELAY=2

# BUGS
#    - Should only load present slot. This needs support from plt to
#      report slots.
# NOTES
#    - Assuming pack full and drives empty.

#$PLT --debug $DEBUG --medium_changer $CHANGER --direct_command load
#if [ $? != 0 ]; then
#   echo "ERROR: Initialization failed"
#   exit 1
#fi

I=`expr $FIRST_SLOT - 1`

while [ $I -lt $LAST_SLOT ]
do
   I=`expr $I + 1`

   # Insert
   $PLT --debug $DEBUG --medium_changer $CHANGER --no_initialization --direct_command move_medium 0 $I $ELEMENT_DRIVE_A
   if [ $? != 0 ]; then
      echo "ERROR: Media movement (insert) failed"
      exit 1
   fi
   RETRIES=0

   if [ $CHECK_DRIVE = yes ]; then
      RESULT=no
      while [ $RETRIES -lt $MAX_RETRIES ]
      do
	 mt -f $DRIVE_A status > /dev/null 2>&1
	 if [ $? = 0 ]; then
	    RESULT=yes
	    break
	 fi
	 sleep $CHECK_SLEEP_DELAY
	 RETRIES=`expr $RETRIES + 1`
      done

      if [ $RESULT = no ]; then
	 echo "ERROR: Drive checking timeout"
	 exit 1
      fi
   fi

   # Retrieve

   # We do the positionning, even if this is not needed in this case since
   # we didn't move.

   if [ $POSITIONNING = yes ]; then
      # Order is important for ADIC (see p65). In a retrieve, the
      # drive is full and thus must be moved last.
      $PLT --debug $DEBUG --medium_changer $CHANGER --no_initialization --direct_command position 0 $I
      if [ $? != 0 ]; then
	 echo "ERROR: Positionning (slot) failed"
	 exit 1
      fi  
      $PLT --debug $DEBUG --medium_changer $CHANGER --no_initialization --direct_command position 0 $ELEMENT_DRIVE_A
      if [ $? != 0 ]; then
	 echo "ERROR: Positionning (drive) failed"
	 exit 1
      fi   
   fi

   if [ $MANUAL_EJECT = yes ]; then
      # Adic needs manual eject.
      mt -f /dev/st0 offline
      if [ $? != 0 ]; then
	 echo "ERROR: Cannot eject"
	 exit 1
      fi
   fi

   # Actual movement
   $PLT --debug $DEBUG --medium_changer $CHANGER --no_initialization --direct_command move_medium 0 $ELEMENT_DRIVE_A $I
   if [ $? != 0 ]; then
      echo "ERROR: Media movement (retrieve) failed"
      exit 1
   fi
done

exit 0
