#! /bin/sh
 # libra_test.sh -- Testing the libras
 # Marc SCHAEFER <schaefer@dilog.ch>
 # Creation: 29/08/96
 # Update:   29/08/96
 # V1.0 PV001
 # NOTES
 # BUGS
 # TODO

if [ $# != 0 ]; then
   echo "$0"
   echo "$0: bad args."
   exit 2
fi

DEVICE=/dev/sgc
PLT="plt -d NOTICE -m $DEVICE"
PLT_DIRECT="$PLT --direct_command"
LABEL=disabled
WRITE=disabled
CONTINUOUS=disabled

while :
do
   cat << EOF

1. LOAD
2. UNLOAD
?. POSITION
4. MOVE MEDIUM
5. TEST MENU
6. READ ELEMENT STATUS
?. EXCHANGE MEDIUM
?. MODE SENSE
0. QUIT
EOF
   read Command
   case $Command in
      0) break;;
      1) $PLT_DIRECT load;;
      2) $PLT_DIRECT unload;;
      4) echo -n "FROM: "
         read FROM
         echo -n "TO: "
         read TO
         $PLT_DIRECT move_medium 0 $FROM $TO;;
      5) while :
         do
            cat << EOF
TEST MENU

?. Automatic test
2. Higher sequential
3. Lower sequential
4. Random
5. Label tapes
6. Test 16x16
7. Higher/lower sequential.
?. Alternating test
9. Change mode (now: labels $LABEL)
??. Param test (0x56)
11. Change tape mode (now: write $WRITE)
12. ADSM-like test
13. ADSM-like test 2
??. Change retry mode (now: retry %s)
15. Quick alignment test.
16. Continuous mode (now: continuous $CONTINUOUS)
0.  Previous menu
EOF
            if [ "$LABEL" = "enabled" ]; then
                     DO_LABEL=--check_labels
            else
                     DO_LABEL=
            fi

            if [ "$WRITE" = "enabled" ]; then
                     DO_WRITE=--write
            else
                     DO_WRITE=
            fi

            if [ "$CONTINUOUS" = "enabled" ]; then
                     DO_CONTINUOUS=--continuous
            else
                     DO_CONTINUOUS=
            fi

            PLT_NORMAL="$PLT $DO_LABEL $DO_WRITE $DO_CONTINUOUS --operation"
            read Command
            case $Command in
               2) $PLT_NORMAL seq_h ;;
               3) $PLT_NORMAL seq_l ;;
               4) $PLT_NORMAL random ;;
               5) $PLT_NORMAL label ;;
               6) $PLT_NORMAL 16x16 ;;
               7) $PLT_NORMAL seq ;;
               9) if [ "$LABEL" = "enabled" ]; then
                     LABEL=disabled
                  else
                     LABEL=enabled
                  fi;;
              11) if [ "$WRITE" = "enabled" ]; then
                     WRITE=disabled
                  else
                     WRITE=enabled
                  fi;;
              12) $PLT_NORMAL adsm_1 ;;
              13) $PLT_NORMAL adsm_2 ;;
              15) $PLT_NORMAL quick ;;
              16) if [ "$CONTINUOUS" = "enabled" ]; then
                     CONTINUOUS=disabled
                  else
                     CONTINUOUS=enabled
                  fi;;
               0) break;;
            esac
         done;;
      6) $PLT_DIRECT elt_status;;
   esac
done
