#! /bin/sh
 # test_clean.sh -- Test libra8 with cleaning
 # Marc SCHAEFER <schaefer@dilog.ch>
 # Creation: 31/08/96
 # Update:   31/08/96
 # V1.0 PV001
 # NOTES
 # BUGS
 # TODO
 # BASED-ON
 #    libra_test.sh V1.0 PV001 of 29/08/96

if [ $# != 0 ]; then
   echo "$0"
   echo "$0: bad args."
   exit 2
fi

DEVICE=/dev/sgb
PLT="plt -d NOTICE -m $DEVICE --direct_command move_medium 0 "

echo "libra8 loaded ?"
read answer

while :
do
   echo -n "Starting the test cycle, loading cleaning tape ..."
   $PLT 9 1

   sleep 45

   $PLT 1 9

   echo "probably done"
   echo ""

   for j in 1 2 3 4 5 6
   do
   for i in 2 3 4 5 6 7 8
   do
      $PLT $i 1
      if [ $? != 0 ]; then
         exit
      fi
      wait_tape_ready.sh /dev/st0
      dd if=/dev/zero of=/dev/st0 bs=1024 count=2000

      $PLT 1 $i
      if [ $? != 0 ]; then
         exit
      fi 
   done
   done
done