#ifndef SCSI_IF_H
/* scsi.c -- Parallel Libra Tester low level SCSI function definitions.
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 01/08/96
 * Update:   03/10/96
 * V1.0 PV003
 * NOTES
 *    - see sg
 * BUGS
 * TODO
 * $Id: scsi_if.h,v 1.4 1999/04/01 16:06:24 schaefer Exp $
 */

#ifdef __linux
#include <linux/version.h>

#if LINUX_VERSION_CODE >= 131099
#include <scsi/sg.h>
#else
#ifndef OLD_KERNEL
#include "/usr/src/linux/include/scsi/sg.h"
#else
#include <linux/../../drivers/scsi/sg.h>
#endif
#endif
#endif /* __linux */

/* Type definitions */

/* Macros */

#ifndef __linux
/* Emulate Linux (partly) */
#define SG_SENSE_LEN 16
struct sg_header {
  int pack_len;    /* length of incoming packet <4096 (including header) */
  int reply_len;   /* maximum length <4096 of expected reply */
  int pack_id;     /* id number of packet */
  int result;      /* 0==ok, otherwise refer to errno codes */
  unsigned int twelve_byte:1; /* Force 12 byte command length for group 6 & 7 co
mmands  */
  unsigned int other_flags:31;                  /* for future use */
  unsigned char sense_buffer[SG_SENSE_LEN]; /* used only by reads */
  /* command follows then data for command */   
};
#endif /* !__linux */

#define SCSI_OFF sizeof(struct sg_header)

/* Function definitions */

/* NAME
 *    scsi_handle_scsi_cmd
 * DESCRIPTION
 *    Processes a complete SCSI command.
 * RESULT
 *    TRUE if succeeded
 * NOTES
 *    - Taken from libra2.c,  in turn taken from
 *      Linux kernel.
 * BUGS
 *    - Should use the messaging macros.
 * TODO
 */
BOOL scsi_handle_scsi_cmd(char *generic_device,
                          unsigned cmd_len,
                          unsigned in_size,
                          unsigned char *i_buff,
                          unsigned out_size,
                          unsigned char *o_buff);

#endif
