/* timer.c -- Time subsystem
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 29/08/96
 * Update:   18/10/96
 * V1.0 PV003
 * NOTES
 * BUGS
 * TODO
 * MODIFICATION-HISTORY
 *    10/12/98  schaefer  Applying new RCS scheme.
 * $Id: time.c,v 1.1 1998/12/10 17:14:16 schaefer Exp $
 */

#include <stdio.h>
#include <time.h>
#include "types.h"
#include "debug_if.h"
#include "time_if.h"

/* Private variables */

static time_time_t start_time;

void time_init(void) {
   time(&start_time);
}

/* BUGS
 *    - Does not handle well wrap-out of start_time,
 *      next event in 2037, so ...
 */
time_time_t time_elapsed_time(void) {
   time_t current;

   time(&current);
   return (time_time_t) (current - start_time);
}

void time_show_elapsed_time(void) {
   time_time_t elapsed;

   elapsed = time_elapsed_time();
   printf("(%ld:%2.2ld)", elapsed / 60, elapsed % 60);
}
