/* (C) Marc SCHAEFER, 1998.
 * Parts have been done within DILOG SA
 * Released under the GPL
 */

/* IO read operation; number of operation restart as argument.
 * If BENCHIO_IOCTL_FLAGS_DIRECT_LOW is set, we
 * send the command to the first SCSI low level driver directly.
 * If BENCHIO_IOCTL_FLAGS_DIRECT_MIDDLE is set, we
 * send the command to the middle level driver (through scsi_do_cmd().
 * If BENCHIO_IOCTL_FLAGS_DIRECT_HIGH is set, we send to the specified
 * high-level block device.
 */

#ifdef BENCHIO_ENABLE_HIGH_DIRECT
#error "@@@ doesn't work, needs support in Linux drivers for direct I/O."
#endif /* BENCHIO_ENABLE_HIGH_DIRECT */

#define BENCHIO_IOCTL_MASK_CMD   0xF
#define BENCHIO_IOCTL_MASK_FLAGS 0xF0

#define BENCHIO_IOCTL_FLAGS_DIRECT_LOW    0
#define BENCHIO_IOCTL_FLAGS_DIRECT_MIDDLE 0x80
#ifdef BENCHIO_ENABLE_HIGH_DIRECT
#define BENCHIO_IOCTL_FLAGS_DIRECT_HIGH   0x40
#endif /* BENCHIO_ENABLE_HIGH_DIRECT */

/* Do a single I/O operation, block until done */
#define BENCHIO_IOCTL_DO_READ  0
#define BENCHIO_IOCTL_DO_WRITE 1

/* Do multiple I/O operation, for a kernel / user benchmark comparison */
#define BENCHIO_IOCTL_DO_READ_MULTIPLE 2
#define BENCHIO_IOCTL_DO_WRITE_MULTIPLE 3

/* Misc setup */

#define BENCHIO_IOCTL_SET_BUFFER_SIZE 10
#define BENCHIO_IOCTL_NOPE 11
#define BENCHIO_IOCTL_SET_LBA 12
#ifdef BENCHIO_ENABLE_HIGH_DIRECT
#define BENCHIO_IOCTL_SET_DEVICE 13 /* For DIRECT_HIGH */
#endif /* BENCHIO_ENABLE_HIGH_DIRECT */

#define BENCHIO_DEVICE_NAME "/dev/benchio"


