#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <time.h>
#include <sys/timeb.h>
#include <stdlib.h>

#include "benchio.h"

#define BUFFER_SIZE 65536 /* multiple of 512, max 65536 for current impl */
#define BLOCK_SIZE 512
#define BUFFER_STEPS 1000

/* Private function definitions */

static void do_benchmark(int fd, int cmd, unsigned long int max_lba);

/* Function implementation */
int main(int argc, char **argv) {
   int fd;
   if (argc == 2) {
      unsigned long int max_lba;

      max_lba = atol(argv[1]);

      fd = open(BENCHIO_DEVICE_NAME, O_RDWR);

      if (fd != -1) {
	 int error;

	 if ((error = ioctl(fd,
			    BENCHIO_IOCTL_SET_BUFFER_SIZE,
			    BUFFER_SIZE))) {
	    perror("BENCHIO_IOCTL_SET_BUFFER_SIZE error");
	 }     
	 else {
	    printf("READ\n");
	    do_benchmark(fd, BENCHIO_IOCTL_DO_READ_MULTIPLE, max_lba);

	    printf("WRITE\n");
	    do_benchmark(fd, BENCHIO_IOCTL_DO_WRITE_MULTIPLE, max_lba);
	 }

	 close(fd);
      }
      else {
	 perror("open");
      }

      return 0;
   }
   else {
      fprintf(stderr, "%s lba-size\n%s: bad args.\n", argv[0], argv[0]);
      return 2;
   }
}

static void do_benchmark(int fd, int cmd, unsigned long int max_lba) {
   struct timeb started;
   unsigned long int ms_delta;
   unsigned long int old_lba = 0;
   unsigned long int lba = 0;
   int error;

   if ((error = ioctl(fd, BENCHIO_IOCTL_SET_LBA, 0))) {
      perror("BENCHIO_IOCTL_SET_LBA error");
   }  
   else {
      ftime(&started);

      lba += BUFFER_STEPS * (BUFFER_SIZE / BLOCK_SIZE); /* yep */
   
      while (!error && (lba < max_lba)) {
	 struct timeb ended;

	 error = ioctl(fd,
		       cmd
		       | BENCHIO_IOCTL_FLAGS_DIRECT_LOW,
		       BUFFER_STEPS);
	 lba += BUFFER_STEPS * (BUFFER_SIZE / BLOCK_SIZE);

	 ftime(&ended);
	 ms_delta = ((ended.time - started.time) * 1000)
		     + (ended.millitm - started.millitm);
#define MIN_DELAY 20000 /* 20 sec */
	 if ((ms_delta > MIN_DELAY) || ((lba >= max_lba) && ms_delta)) {
	    printf("Upto LBA %ld : %ld bytes/s.\n",
		   lba,
		   (((lba - old_lba) * 512) / ms_delta) * 1000);
	    old_lba = lba;
	    ftime(&started);
	 }

	 if (error) {
	    perror("ioctl");
	 }
      }
   }
}
