#! /bin/sh

if [ $# != 1 ]; then
   echo "$0 < file out.ps"
   echo "$0: bad args."
   exit 2
fi

READ_FILE=/tmp/r_$$
WRITE_FILE=/tmp/w_$$
DATA_FILE=$1

rm -f $READ_FILE $WRITE_FILE $DATA_FILE

cat - | (
   CURR_FILE=$READ_FILE
   while :
   do
      read line
      if [ $? != 0 ]; then
         break
      fi
      set - $line
      case $1 in
         READ) ;;
         WRITE) CURR_FILE=$WRITE_FILE;;
         *) echo "`echo $3 / 2048 | bc` `echo $5 / 1048576 | bc`" >> $CURR_FILE;;
      esac
   done)

(echo set terminal postscript
 echo set output \"$DATA_FILE\"
 echo plot \"$READ_FILE\" title \'reading\' with lines, \"$WRITE_FILE\" title \'writing\' with lines ) | gnuplot


rm -f $READ_FILE $WRITE_FILE

