module general();



endmodule



module dll_standard (CLKIN, RESET, CLK2X, CLK4X, LOCKED);
input CLKIN, RESET;
output CLK2X, CLK4X, LOCKED;

wire CLKIN_w, RESET_w, CLK2X_dll, CLK4X_dll, LOCKED2X;
wire LOCKED2X_delay, RESET4X;
wire logic1;

assign logic1 = 1'b1;

//IBUFG clkpad (.I(CLKIN), .O(CLKIN_w));
//IBUF  rstpad (.I(RESET), .O(RESET_w));

CLKDLL dll2x (.CLKIN(CLKIN), .CLKFB(CLK2X), .RST(RESET), 
              .CLK0(), .CLK90(), .CLK180(), .CLK270(),
              .CLK2X(CLK2X_dll), .CLKDV(), .LOCKED(LOCKED2X));

BUFG   clk2xg (.I(CLK2X_dll),  .O(CLK2X));
SRL16  rstsrl (.D(LOCKED2X), .CLK(CLK2X), .Q(LOCKED2X_delay), 
               .A3(logic1), .A2(logic1), .A1(logic1), .A0(logic1));

assign RESET4X = !LOCKED2X_delay;

CLKDLL dll4x (.CLKIN(CLK2X), .CLKFB(CLK4X), .RST(RESET4X), 
              .CLK0(), .CLK90(), .CLK180(), .CLK270(),
              .CLK2X(CLK4X_dll), .CLKDV(), .LOCKED(LOCKED_dll));

BUFG   clk4xg (.I(CLK4X_dll),  .O(CLK4X));
OBUF   lckpad (.I(LOCKED_dll), .O(LOCKED));

endmodule

