module tx_uart(clock,
data, data_strobe,
tx_data, cts_out, dsr_out, tx_empty, test);

input clock;
input [7:0] data;
input data_strobe;
output tx_data;
output cts_out;
output dsr_out;
output tx_empty;
output test;

reg cts_out;
reg dsr_out;
wire clock;
wire tx_empty;
wire test;

// generate uart 1 x baudrate clock 
reg [15:0] u1count;
reg u1clock;
always @(posedge clock)
begin
u1count = u1count + 1;
//  50000000 / 19200 = 2604

// 19200 baud = 1302
// 57600 baud = 434
// 115200 baud = 217
if(u1count >= 1302)
begin
	u1count = 0;
	u1clock = !u1clock;
	end
end // always

reg start;
reg empty;
reg loaded;
always @(posedge clock) // data_strobe)
begin
	if(data_strobe) start = 1;
	else if(loaded) start = 0;
end


reg [9:0] tx_shift_reg; // 1 start, 8 data, 1 stop bit
integer i;
always @(posedge u1clock)
begin
cts_out = 1;
dsr_out = 1;
if(start)
	begin
	tx_shift_reg [9] = 1; // stop bit
	tx_shift_reg [8:1] = data [7:0]; // data
	tx_shift_reg [0] = 0; // start bit
	i = 0;
	empty = 0;
	loaded = 1;
	end
else
	begin
	loaded = 0;
	if(i < 10)
		begin
		tx_shift_reg = tx_shift_reg >> 1;
		tx_shift_reg [9] = 1;
		i = i + 1;
		end
	else
		begin
		empty = 1;
		end
	end
end // always

assign tx_data = tx_shift_reg [0];
assign tx_empty = empty;
assign test = tx_shift_reg[2];

endmodule // tx_uart



module rx_uart(clock, divider, rx_serial_data, rx_strobe, rx_data_out, rx_available,
	test1, test2);
input clock;
input [15:0] divider;
input rx_serial_data;
input rx_strobe;
output [7:0] rx_data_out;
output rx_available;
output test1;
output test2;

wire [15:0] divider;
wire rx_data;
wire rx_strobe;
reg [7:0] rx_data_out;
reg rx_available;
wire test1;
wire test2;

// generate uart 4 x baudrate clock 
reg [15:0] u4count;
reg u4clock;
always @(posedge clock)// 50000000 / 9600 = 5208
begin
u4count = u4count + 1;
if(u4count >= divider) //651)
	begin
	u4count = 0;
	u4clock = !u4clock;
	end
end // always

reg [9:0] rx_shift_register;
reg rregl;
reg [3:0] bitpos;
reg [2:0] sample_count;

// process rx_strobe
always @(rx_strobe or rregl)
begin
if(rx_strobe == 1) rx_available = 0;
else if(rregl == 1) rx_available = 1;
end // always

// read in bits, at posedge baudrate gen,
// so half a period after sync, in the middle of a rx bit
always @(posedge u4clock)
begin
case(bitpos)
	0: // idle
		begin
		rregl = 0;
		if(rx_serial_data == 0)
			begin
			sample_count = 0;
			bitpos = 1;
			end
		end				                                                                     
	10: // stop bit
		begin
		bitpos = 0;
		rregl = 1;
		rx_data_out = rx_shift_register;
		end
	default: // data bits
		begin
		if(sample_count == 1 && bitpos >= 2)
			begin
			rx_shift_register[ bitpos - 2 ] = rx_serial_data;
			end
		if(sample_count == 3) bitpos = bitpos + 1;
		end
endcase

sample_count = sample_count + 1;
if(sample_count == 4) sample_count = 0;

end // always

assign test1 = u4clock; //bitpos[0];
assign test2 = rregl; //sample_count[0];

endmodule // rx_uart


