<?php

/* filter.php: Page for setting values and calling the XXS filter
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: filter.php,v 1.8 2004/01/27 19:01:18 sailfrog Exp $
*/

function hm_filter_html ($body, $level=1) {
    require('htmlfilter.inc');
    $tag_list = Array( true, 

            /* ONLY these tags are allowed */
            'b', 'i', 'strong', 'p', 'small', 'table', 'th', 'td', 'tr', 'hr', 'center', 
            'h1', 'h2', 'h3', 'h4', 'h5', 'br', 'div');
   
    $rm_tags_with_content = Array( 'script', 'style', 'applet', 
                                   'embed', 'head', 'frameset');
    $self_closing_tags =  Array( 'img', 'br', 'hr', 'input');
    $force_tag_closing = false;
    /*
        filter level values:
         1 default level, no images, no links
         2 images only
         3 links only
         4 links and images
    */
    $rm_attnames = Array(
        '/.*/' =>
        Array(
              '/target/i',
              '/href/i',
              '/src/i',
              '/^on.*/i',
              '/^dynsrc/i',
              '/^datasrc/i',
              '/^data.*/i'
              )
        );
    $add_attr_to_tag = Array();

    switch ($level) {
        case 1:
            break;
        case 2:
            $rm_attnames = Array(
                '/.*/' =>
                Array(
                      '/target/i',
                      '/^on.*/i',
                      '/href/i',
                      '/^dynsrc/i',
                      '/^datasrc/i',
                      '/^data.*/i'
                      )
                );
            array_push($tag_list, 'img');
            $add_attr_to_tag = Array();
            break;
        case 3:
            $rm_attnames = Array(
                '/.*/' =>
                Array(
                      '/target/i',
                      '/^on.*/i',
                      '/src/i',
                      '/^dynsrc/i',
                      '/^datasrc/i',
                      '/^data.*/i'
                      )
                );
            array_push($tag_list, 'a');
            $add_attr_to_tag = Array( '/^a$/i' => Array('target' => '"_new"'));
            break;
        case 4:
            $rm_attnames = Array(
                '/.*/' =>
                Array(
                      '/target/i',
                      '/^on.*/i',
                      '/^dynsrc/i',
                      '/^datasrc/i',
                      '/^data.*/i'
                      )
                );
            array_push($tag_list, 'a', 'img');
            $add_attr_to_tag = Array( '/^a$/i' => Array('target' => '"_new"'));
            break;
        default:
            break;
    }
    $bad_attvals = Array(
        '/.*/' =>
            Array(
	        '/.*/' =>
	          Array(
	                Array(
                          '/^([\'\"])\s*\S+\s*script\s*:*(.*)([\'\"])/i',
                          '/^([\'\"])\s*https*\s*:(.*)([\'\"])/i',
			     ),
		        Array(
                      '\\1blah:\\2\\3',
                      '\\1http:\\2\\3',
		             )
			),     
              '/^style/i' =>
                  Array(
                        Array(
                              '/expression/i',
                              '/behaviou*r/i',
                              '/binding/i',
                              '/url\(([\'\"]*)\s*https*:.*([\'\"]*)\)/i',
                              '/url\(([\'\"]*)\s*\S+script:.*([\'\"]*)\)/i'
                             ),
                        Array(
                              'idiocy',
                              'idiocy',
                              'idiocy',
                              'url(\\1http://securityfocus.com/\\2)',
                              'url(\\1http://securityfocus.com/\\2)'
                             )
                        )
              )
        );

    $trusted = sanitize($body, 
                        $tag_list, 
                        $rm_tags_with_content,
                        $self_closing_tags,
                        $force_tag_closing,
                        $rm_attnames,
                        $bad_attvals,
                        $add_attr_to_tag
                        );
    return $trusted;
}

?>
