<?php

/* compose.php: Page for creating and sending messages
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: compose.php,v 1.173 2004/04/29 01:58:56 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'compose');

/* set ini values and check/get the SESSION vars */
$clear = false;
if (isset($hm_input['new']) && $hm_input['new'] == 1) {
    $clear = true;
}
if (hm_session_continue($hm_input['id'], $config_file, $clear)) {
    $config = $_SESSION['config'];
}
$hm_input['id'] = session_id();
$str = $_SESSION['str'];

/* check for simple option and set flag */
$simple = false;
if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 'true')
   || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 'true')) {
    $simple = true;
}

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config, 
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* get unseen messages */
$unseen = hm_unseen_status ($imap_stream, $_SESSION['folders']);

/* get contacts */
if (isset($hm_input['search_terms']) && $hm_input['search_terms'] != '' && 
    !isset($hm_input['list'])) {
    $search = $hm_input['search_terms'];
    $search_terms = hm_htmlize($search);
}
else {
    $search = false;
    $search_terms = '';
}
$contacts = hmw_get_contacts($_SESSION['user'], $config['settings_dir'], $hasty_key,
                             $config, $search);

/* set field values for a reply or forward */
if ((isset($hm_input['reply']) && $hm_input['reply'] == 1) ||
    (isset($hm_input['forward']) && $hm_input['forward'] == 1) ||
    (isset($hm_input['draft']) && $hm_input['draft'] == 1) ||
    (isset($hm_input['bounce']) && $hm_input['bounce'] == 1)) {
    hm_select_mailbox($imap_stream, $hm_input['mailbox']);
    if (isset($hm_input['part']) && $hm_input['part'] != 1) {
        $structure_temp = hm_get_struct($imap_stream, $hm_input['uid']);
        $structure = &hm_in_multi_array($hm_input['part'], $structure_temp, array(),
                     true);
        if ($structure && $structure[0] != '') {
            $parent_part = $structure[0];
            $structure[0] = $structure[1];
            unset($structure[1]);
        }
        else {
            $structure = $structure_temp;
            $parent_part = false;
        }
    }
    else {
        $structure = hm_get_struct($imap_stream, $hm_input['uid']);
        $parent_part = false;
        $hm_input['part'] = 1;
    }

    /* reply formatting */
    if (isset($hm_input['reply'])) {
        if (isset($hm_input['html_part'])) {
            $get_part = $hm_input['part'];
        }
        else {
            $get_part = false;
        }
        $result = &hm_find_display_part($imap_stream, $structure, $hm_input['uid'], 
                                       $get_part, true);
        if (isset($hm_input['html_part'])) {
            $result[1] = str_replace(array("\n", '</td>', '&nbsp;', '&gt;', '&lt;'),
                                     array('', ' ', ' ', '>', '<'), $result[1]);
            $result[1] = "\n".strip_tags(str_replace(
                                     array('<br>', '</th>', '</tr>', '</li>', '</ul>',
                                           '<BR>', '</TH>', '</TR>', '</LI>', '</UL>',
                                           '</DIV>',  '</div>'),
                                     "\n", $result[1]));
            $result[1] = &hm_text_cleanup($result[1], true, true);
        }
        $hm_input['part'] = $result[0];
        $code_page = false;
        $charset_convert = false;
        $charset = false;
        $utf8 = false;
        if (isset($result[2][4]) && $result[2][4] && $str['charset'] == 'UTF-8') {
            $charset = strtolower($result[2][4]);
            if (isset($_SESSION['charsets'][$charset])) {
                $code_page = $_SESSION['charsets'][$charset];
                $charset_convert = true;
            }
        }
        if ($charset == 'utf-8') {
            $utf8 = true;
        }
        $message = hm_special_chars($result[1], $str['charset'], $charset_convert,
                                    $code_page, $utf8);

        /* checking for list reply */
        $headers = hm_get_full_header($imap_stream, $hm_input['uid'], $parent_part);
        if (!isset($hm_input['list_reply'])) {
            if (isset($headers['reply-to'])) {
                $to = stripslashes($headers['reply-to']);
            }
            elseif (isset($headers['from'])) {
                $to = stripslashes($headers['from']);
            }
            else {
                $to = '';
            }
        }
        else {
            $to = $hm_input['list_reply'];
        }
        /* clean out the to field for smtp compliance */
        if (preg_match("/(.+\s|)([^\s]+\@[^\s]+)(\s.+|)/", $to, $regs)) {
            $clean = array();
            for ($i=1;$i<4;$i++) {
                if (strpos($regs[$i], '@') !== false && $regs[$i]{0} != '"') {
                    $clean[$i] = $regs[$i];
                }
                elseif (strlen($regs[$i]) > 0) {
                    $clean[$i] = '&quot;'.trim(str_replace(array('"', '&quot;'), '',
                                 $regs[$i])).'&quot;';
                }
            }
            $to = implode(" ", $clean);
        }
        
        /* reply quote line */
        if (isset($headers['date'])) {
            if (isset($_SESSION['settings']['date_string'])) {
                $date_string = $_SESSION['settings']['date_string'];
            }
            else {
                $date_string = 'F j, g:i a';
            }
            $date = date($date_string, (strtotime($headers['date'])));
        }
        else {
            $date = 'an unknown date';
        }
        if (isset($headers['from'])) {
            $person = $headers['from'];
        }
        else {
            $person = 'an unknown user';
        }
        $message = "On $date $person wrote:".$message;

        /* subject */
        if (isset($headers['subject'])) {
            if (!preg_match("/^re:/i", $headers['subject'])) {
                $subject = "Re: ".$headers['subject'];
            }
            else {
                $subject = $headers['subject'];
            }
        }
        else {
            $subject = 'Re: '.$str[229];
        }

        /* messageid/replyto/etc */
        if (isset($headers['message-id'])) {
            $messid = $headers['message-id'];
        }
        else {
            $messid = '';
        }
        if (isset($headers['in-reply-to'])) {
            $inreplyto = $headers['in-reply-to'];
        }
        else {
            $inreplyto = '';
        }
        if (isset($headers['references'])) {
            $refs = $headers['references'];
        }
        else {
            $refs = '';
        }

        /* try to find the matching from address */
        if (isset($hm_input['list_reply'])) {
            $header_test = hm_get_full_header($imap_stream, $hm_input['uid'], 
                                              false);
        }
        else {
            $header_test = $headers;
        }
        $match = false;
        $fields = array('to', 'cc', 'delivered-to');
        foreach ($fields as $field) {
            if (isset($header_test[$field])) {
                for ($i=0;$i<$_SESSION['settings']['profile_count'];$i++) {
                    if ($_SESSION['profiles'][$i]['from_address'] != '') {
                        $test_addy = $_SESSION['profiles'][$i]['from_address'];
                        if (preg_match("/$test_addy/", $header_test[$field])) {
                            $match = true;
                            $index = $i;
                            break 2;
                        }
                    }
                }
            }
        }
        $cc = '';

        /* if reply to all is set */
        if (isset($hm_input['all']) && $hm_input['all'] == 1) {
            $string = '';
            if (isset($headers['cc'])) {
                $string .= ' '.$headers['cc'];
            }
            if (isset($headers['to'])) {
                $string .= ' '.$headers['to'];
            }
            if (preg_match_all(
                    "/([\.\-\_[:alnum:]]+@[\.\-\_[:alnum:]]{2,}\.[[:alnum:]]{2,})/i", 
                    $string, $matches)) {
                if (isset($matches[1])) {
                    $cc_array = array_unique($matches[1]);
                    $cc = implode(', ', $cc_array);
                }
            }
        }
        $bcc = '';
    }

    /* forwarded message */
    elseif (isset($hm_input['forward'])) {
        $result = &hm_find_display_part($imap_stream, $structure, $hm_input['uid'], false,
                                       false, true);
        $hm_input['part'] = $result[0];
        $code_page = false;
        $charset_convert = false;
        $charset = false;
        $utf8 = false;
        if (isset($result[2][4]) && $result[2][4] && $str['charset'] == 'UTF-8') {
            $charset = strtolower($result[2][4]);
            if (isset($_SESSION['charsets'][$charset])) {
                $code_page = $_SESSION['charsets'][$charset];
                $charset_convert = true;
            }
        }
        if ($charset == 'utf-8') {
            $utf8 = true;
        }
        $message_body = hm_special_chars($result[1], $str['charset'], $charset_convert,
                                    $code_page, $utf8);
        $message_summary = "\n        ------  Original Message  ------\n";

        $headers = hm_get_full_header($imap_stream, $hm_input['uid'], $parent_part);
        if (isset($headers['subject'])) {
            $subject = $headers['subject'];
            $message_summary .= 'Subject: '.$subject."\n";
            $subject = 'Fwd: '.$subject;
        }
        else {
            $message_summary .= 'Subject: '.$subject."\n";
            $subject = 'Fwd: '.$str[229];
        }
        if (isset($headers['to'])) {
            $fto = $headers['to'];
            $message_summary .= $str[25].':      '.$fto."\n";
        }
        if (isset($headers['from'])) {
            $ffrom = $headers['from'];
            $message_summary .= $str[22].':    '.$ffrom."\n";
        }
        if (isset($headers['date'])) {
            $message_summary .= $str[23].':    '.hm_htmlize($headers['date'])."\n";
        }
        $message = $message_summary."\n".$message_body;
        $cc = '';
        $bcc = '';
        $to = '';
        $refs = '';
        $messid = '';
        $inreplyto = '';

        /* format forwarded attachments */
        if (count($structure) > 1) {
            $_SESSION['forward_flag'] = 'true';
            foreach($structure as $part_num => $info_array) {
                if ($part_num != $hm_input['part']) {
                    $part = hm_get_message_part ($imap_stream, $hm_input['uid'], 
                                                $part_num);
                    if (preg_match("/[^\r]\n/", $part)) {
                        $part = str_replace("\n", "\r\n", $part);
                    }
                    $part = rtrim($part)."\r\n";
                    if ($structure[$part_num]['type'] == 'message') {
                        $head = hm_get_full_header($imap_stream, $hm_input['uid'],
                                                   $part_num, true);
                        $part = "\r\n".$head."\r\n\r\n".$part;
                    }
                    $rawsize = strlen($part);
                    if ($structure[$part_num]['rawsize'] == '') {
                        $structure[$part_num]['rawsize'] = $rawsize;
                    } 
                    $temp_file_name = md5(uniqid(rand(),1));
                    if ($rawsize > 0 && 
                                 $fp = fopen ($_SESSION['config']['settings_dir'].
                                 "attachments/$temp_file_name", 'w')) {
                        fputs($fp, $part, strlen($part));
                        fclose($fp);
                        $_SESSION['attachments'][$temp_file_name] = array( 
                                  'name'     => $structure[$part_num]['name'],
                                  'type'     => $structure[$part_num]['type'].'/'.
                                                $structure[$part_num]['subtype'],
                                  'size'     => $structure[$part_num]['rawsize'],
                                  'rawsize'     => $rawsize,
                                  'encoding' => $structure[$part_num]['encoding']);
                        if ($structure[$part_num]['type'].'/'.
                            $structure[$part_num]['subtype'] != 'message/digest') {
                            $_SESSION['attachments'][$temp_file_name]['header'] =
                                "Content-Type: ".$structure[$part_num]['type'].
                                '/'.$structure[$part_num]['subtype'].
                                '; name="'.$structure[$part_num]['name']."\"\r\n".
                                'Content-Disposition: attachment; filename="'.
                                $structure[$part_num]['name']."\"\r\n";
                        }
                        if (substr($_SESSION['attachments'][$temp_file_name]['type'], 
                            0, 7) != 'message') {
                            $_SESSION['attachments'][$temp_file_name]['header'] .=
                                'Content-Transfer-Encoding: '.
                                $_SESSION['attachments'][$temp_file_name]['encoding'].
                                "\r\n\r\n";
                        }
                    }
                }
            }
        }
    }
    
    /* resuming a draft */
    elseif (isset($hm_input['draft'])) {
        $result = &hm_find_display_part($imap_stream, $structure, $hm_input['uid'], false, false, true);
        $message = hm_htmlize($result[1]);
        $headers = hm_get_full_header($imap_stream, $hm_input['uid'], $parent_part);
        if (isset($headers['subject'])) {
            $subject = $headers['subject'];
        }
        else {
            $subject = '';
        }
        if (isset($headers['to'])) {
            $to = $headers['to'];
        }
        else {
            $to = '';
        }
        if (isset($headers['cc'])) {
            $cc = $headers['cc'];
        }
        else {
            $cc = '';
        }
        if (isset($headers['from'])) {
            $match = false;
            for ($i=0;$i<$_SESSION['settings']['profile_count'];$i++) {
                if (isset($_SESSION['profiles'][$i]['from_address'])) {
                    $test_addy = $_SESSION['profiles'][$i]['from_address'];
                    if (preg_match("/$test_addy/", $headers['from'])) {
                        $match = true;
                        $index = $i;
                        break;
                    }
                }
            }
        }
        $bcc = '';
        $refs = '';
        $messid = '';
        $inreplyto = '';
    }

    /* send fake message bounce */
    elseif (isset($hm_input['bounce'])) {
        function decode($string) {
            $string = strtr($string, 
                array_flip(get_html_translation_table(HTML_ENTITIES)));
            $string = preg_replace("/&#([0-9]+);/me", "chr('\\1')", $string);
            return $string;
        }
        $bail = false;
        $headers = hm_get_full_header($imap_stream, $hm_input['uid'], $parent_part);
        $to = false;
        if (isset($headers['reply-to'])) {
            $to = stripslashes(decode($headers['reply-to']));
        }
        elseif (isset($headers['from'])) {
            $to = stripslashes(decode($headers['from']));
        }
        else {
            $bail = true;
        }
        if (!isset($headers['subject'])) {
            $subj = '';
        }
        else {
            $subj = decode($headers['subject']);
        }
        if (!isset($headers['date'])) {
            $dat = '';
        }
        else {
            $dat = $headers['date'];
        }
        if (!isset($headers['to'])) {
            $sender = '';
        }
        else {
            $sender = decode($headers['to']);
        }
        if ($sender != '') {
            $domain = substr(strstr($sender, '@'), 1);
        }
        else {
            $domain = $config['domain'];
        }
        $message = "\nThis is an automated message from the  SMTP server at ".
                   $domain."\n".
                   "Your message could not be delivered due to permanent errors:\n".
                   '  550 unknown user '.$sender."\n\nMessage summary:\n".
                   "  Subject: ".$subj."\n  Date: ".$dat."\n  From: ".$to."\n".
                   "  To: ".$sender."\n";
        $cc = '';
        $bcc = '';
        $subject = 'failure notice';
        $messid = '' ;
        $inreplyto = '';
        $refs = '';
        $reply = false;
        $from = 'MAILER-DAEMON@'.$domain;
        if (!$bail) {
            if (!hm_send_mail($to, $cc, $bcc, $subject, $message, $from, $inreplyto,
                              $messid, $refs, $reply, $config, $config_file, true,
                              $version, $hasty_key, $imap_stream)) {
                $bounce = 'no';
            }
            else {
                $bounce = 'yes';
            }
            header('Location: '.$_SESSION['config']['hostname'].
                   $_SESSION['config']['install_path'].
                   'message.php?uid='.$hm_input['uid'].
                   '&id='.$hm_input['id'].
                   '&bounce_notice='.$bounce.
                   '&mailbox='.$hm_input['mailbox']);
            exit;
        }
        else {
            header('Location: '.$_SESSION['config']['hostname'].
                   $_SESSION['config']['install_path'].
                   'message.php?uid='.$hm_input['uid'].
                   '&id='.$hm_input['id'].
                   '&bounce_notice=no'.
                   '&mailbox='.$hm_input['mailbox']);
            exit;
        }
    }
}

/* blank form */
else {
    if (isset($hm_input['to'])) {
        $to = hm_htmlize($hm_input['to']);
    }
    else {
        $to = '';
    }
    $cc = '';
    $bcc = '';
    $subject = '';
    $message = '';
    $messid = '' ;
    $inreplyto = '';
    $refs = '';
}

/* check for from addresses set in the user settings */
$emtpy = true;
if (isset($_SESSION['profiles'][0]['from_address']) &&
    $_SESSION['profiles'][0]['from_address'] != '') {
    $emtpy = false;
}

/* If 'Send' was clicked */
if (isset($hm_input['send'])) {
    if (!isset($hm_input['to']) || $hm_input['to'] == '') {
     $_SESSION['notices'][] = $str[167];

        $cc =       hm_htmlize($hm_input['cc']);
        $bcc =      hm_htmlize($hm_input['bcc']);
        $subject =  hm_htmlize($hm_input['subject']);
        $message =  $hm_input['message'];
    }
    else {
        if (isset($hm_input['reply_send'])) {
            $reply = true;
        }
        else {
            $reply = false;
        }
        if (!hm_send_mail($hm_input['to'], $hm_input['cc'], $hm_input['bcc'], 
                          $hm_input['subject'], $hm_input['message'],
                          $hm_input['from'], $hm_input['inreplyto'],
                          $hm_input['messid'], $hm_input['refs'], $reply, $config,
                          $config_file, false, $version, $hasty_key, $imap_stream)) {

            $refs = '';
            $messid = '';
            $inreplyto = '';
            $to =       hm_htmlize($hm_input['to']);
            $cc =       hm_htmlize($hm_input['cc']);
            $bcc =      hm_htmlize($hm_input['bcc']);
            $subject =  hm_htmlize($hm_input['subject']);
            $message =  $hm_input['message'];
            if (isset($hm_input['refs'])) {
                $refs = $hm_input['refs'];
            }
            if (isset($hm_input['messid'])) {
                $messid = $hm_input['messid'];
            }
            if (isset($hm_input['inreplyto'])) {
                $inreplyto = $hm_input['inreplyto'];
            }
            if (isset($hm_input['reply_send'])) {
                $hm_input['reply'] = 1;
            }
        }
        else {
            if ($reply) {
                header("Location: ".$_SESSION['config']['hostname'].
                       $_SESSION['config']['install_path'].
                       "message.php?uid=".$hm_input['uid'].
                       "&id=".$hm_input['id'].
                       "&reply_notice=yes".
                       "&mailbox=".$hm_input['mailbox']);
                exit;
            }
            else {
                if (isset($_SESSION['attachments'])) {
                    foreach ($_SESSION['attachments'] as $name => $vals) {
                        if (file_exists($_SESSION['config']['settings_dir'].
                                        "attachments/".$name)) {
                            unlink($_SESSION['config']['settings_dir'].
                                    "attachments/".$name);
                            clearstatcache();
                        }
                    }
                    $_SESSION['attachments'] = array();
                    unset($_SESSION['attachments']);
                }
            }
        }        
    }
}

/* adding an address from the contact list */
elseif (isset($hm_input['to_add']) || isset($hm_input['cc_add']) ||
        isset($hm_input['bcc_add'])) {
    $refs = '';
    $messid = '';
    $inreplyto = '';
    $to =       hm_htmlize($hm_input['to']);
    $cc =       hm_htmlize($hm_input['cc']);
    $bcc =      hm_htmlize($hm_input['bcc']);
    $added = '';
    if (!empty($hm_input['addresses'])) {
        foreach($hm_input['addresses'] as $index) {
            if (isset($contacts[$index])) {
                if ($added != '') {
                    $added .= ', ';
                }
                $added .= $contacts[$index][1];
            }
        }
        switch (true) {
            case isset($hm_input['to_add']):
                if ($to != '') {
                    $to .= ', ';
                }
                $to .= hm_htmlize($added);
                break;
            case isset($hm_input['cc_add']):
                if ($cc != '') {
                    $cc .= ', ';
                }
                $cc .= hm_htmlize($added);
                break;
            case isset($hm_input['bcc_add']):
                if ($bcc != '') {
                    $bcc .= ', ';
                }
                $bcc .= hm_htmlize($added);
                break;
        }
    }
    $subject =  hm_htmlize($hm_input['subject']);
    $message =  $hm_input['message'];

    if (isset($hm_input['refs'])) {
        $refs = $hm_input['refs'];
    }
    if (isset($hm_input['messid'])) {
        $messid = $hm_input['messid'];
    }
    if (isset($hm_input['inreplyto'])) {
        $inreplyto = $hm_input['inreplyto'];
    }
    if (isset($hm_input['reply_send'])) {
        $hm_input['reply'] = 1;
    }
}

/* contacts search */
elseif (isset($hm_input['search']) || isset($hm_input['list'])) {
    $refs = '';
    $messid = '';
    $inreplyto = '';
    $to =       hm_htmlize($hm_input['to']);
    $cc =       hm_htmlize($hm_input['cc']);
    $bcc =      hm_htmlize($hm_input['bcc']);
    $subject =  hm_htmlize($hm_input['subject']);
    $message =  $hm_input['message'];

    if (isset($hm_input['refs'])) {
        $refs = $hm_input['refs'];
    }
    if (isset($hm_input['messid'])) {
        $messid = $hm_input['messid'];
    }
    if (isset($hm_input['inreplyto'])) {
        $inreplyto = $hm_input['inreplyto'];
    }
    if (isset($hm_input['reply_send'])) {
        $hm_input['reply'] = 1;
    }
}

/* adding signature */
elseif (isset($hm_input['sig'])) {
    $refs = '';
    $messid = '';
    $inreplyto = '';
    $to =       hm_htmlize($hm_input['to']);
    $cc =       hm_htmlize($hm_input['cc']);
    $bcc =      hm_htmlize($hm_input['bcc']);
    $subject =  hm_htmlize($hm_input['subject']);
    $index = 'no';
    if (isset($hm_input['from'])) {
        for ($i=0;$i<$_SESSION['settings']['profile_count'];$i++) {
            if (isset($_SESSION['profiles'][$i]['from_address']) &&
                $hm_input['from'] == $i) {
                $index = $i;
                break;
            }
        }
    }
    if (is_numeric($index)) {
        $message .= $hm_input['message']
                    ."\n\n".
                    hm_htmlize($_SESSION['profiles'][$index]['sig']);
    }
    else {
        $message =  $hm_input['message'];
    }
    if (isset($hm_input['refs'])) {
        $refs = $hm_input['refs'];
    }
    if (isset($hm_input['messid'])) {
        $messid = $hm_input['messid'];
    }
    if (isset($hm_input['inreplyto'])) {
        $inreplyto = $hm_input['inreplyto'];
    }
    if (isset($hm_input['reply_send'])) {
        $hm_input['reply'] = 1;
    }
}

/* saving draft */
elseif (isset($hm_input['save']) && $hm_input['save'] == $str[163]) {
    $from_address = $_SESSION['profiles'][$hm_input['from']]['from_address'];
    if (isset($_SESSION['profiles'][$hm_input['from']]['from_name']) &&
        $_SESSION['profiles'][$hm_input['from']]['from_name'] != '') {
        $from_name = '"'.$_SESSION['profiles'][$hm_input['from']]['from_name'].'"';
    }
    else {
        $from_name = '';
    }
    /* properly format the body text */
    $lines = split("\n", $hm_input['message']);
    $imaplines = array();
    foreach($lines as $string) {
        if (strlen($string) > 78) {
            $imaplines[] = rtrim(implode("\r\n", hm_split_line($string, 76, false, true)),
                           "\n")."\r\n";
        }
        else {
            $imaplines[] = rtrim($string, "\r\n")."\r\n";
        }
    }
    $draft_message  = "Date: ".date("r")."\r\n".
                     "From: $from_name <$from_address>\r\n".
                     "Subject: ".$hm_input['subject']."\r\n".
                     "To: ".$hm_input['to']."\r\n";
    if ($hm_input['cc'] != '') {
        $draft_message .= "Cc: ".$hm_input['cc']."\r\n";
    }
    $draft_message .= "X-Mailer: Hastymail 0.6-CVS\r\n".
                      "MIME-Version: 1.0\r\n".
                      "Content-Type: text/plain\r\n\r\n".
                      implode('', $imaplines)."\r\n";
    hm_save_message ($draft_message, $imap_stream, 'draft'); 
    $refs = '';
    $messid = '';
    $inreplyto = '';
    $to =       hm_htmlize($hm_input['to']);
    $cc =       hm_htmlize($hm_input['cc']);
    $bcc =      hm_htmlize($hm_input['bcc']);
    $subject =  hm_htmlize($hm_input['subject']);
    $message =  $hm_input['message'];
    if (isset($hm_input['refs'])) {
        $refs = $hm_input['refs'];
    }
    if (isset($hm_input['messid'])) {
        $messid = $hm_input['messid'];
    }
    if (isset($hm_input['inreplyto'])) {
        $inreplyto = $hm_input['inreplyto'];
    }
    if (isset($hm_input['reply_send'])) {
        $hm_input['reply'] = 1;
    }
}

/* adding attachments */
elseif (isset($hm_input['attach'])) {
    if (isset($_FILES['attachment']['tmp_name']) &&
        is_uploaded_file($_FILES['attachment']['tmp_name'])) {
        if (!isset($_SESSION['attachments'])) {
            $_SESSION['attachments'] = array();
        }
        $content = '';
        $temp_file_name = md5(uniqid(rand(),1));
        $rawsize = 0;
        if (is_readable($_FILES['attachment']['tmp_name'])) {
            if ($fp_input = fopen($_FILES['attachment']['tmp_name'], "rb")) {
                $fp_output = fopen ($_SESSION['config']['settings_dir'].
                             "attachments/$temp_file_name", 'w');
                while(!feof($fp_input)) {
                    $chunk = fread($fp_input, 24);
                    $new_chunk = chunk_split(base64_encode($chunk));
                    $rawsize += strlen($new_chunk);
                    fputs($fp_output, $new_chunk);
                }
                fclose($fp_input);
                fclose($fp_output);
            }
        }
        if ($rawsize > 0) {
            $_SESSION['attachments'][$temp_file_name] = array( 
                               'name'     => $_FILES['attachment']['name'],
                               'type'     => $_FILES['attachment']['type'],
                               'size'     => $_FILES['attachment']['size'],
                               'rawsize'  => $rawsize,
                               'encoding' => 'base64');        
            if ($_FILES['attachment']['type'] != 'message/digest') {
                $_SESSION['attachments'][$temp_file_name]['header'] =
                "Content-Type: ".$_FILES['attachment']['type'].
                '; name="'.$_FILES['attachment']['name']."\"\r\n".
                'Content-Disposition: attachment; filename="'.
                $_FILES['attachment']['name']."\"\r\n";
            }
            if (substr($_FILES['attachment']['type'], 
                0, 7) != 'message') {
                $_SESSION['attachments'][$temp_file_name]['header'] .=
                    'Content-Transfer-Encoding: base64'."\r\n\r\n";
            }
        }
        else {            
            $_SESSION['notices'][] = $str[170];
        }
    }
    else {
      $_SESSION['notices'][] = $str[170];
    }
    $refs = '';
    $messid = '';
    $inreplyto = '';
    $to =       hm_htmlize($hm_input['to']);
    $cc =       hm_htmlize($hm_input['cc']);
    $bcc =      hm_htmlize($hm_input['bcc']);
    $subject =  hm_htmlize($hm_input['subject']);
    $message =  $hm_input['message'];
    if (isset($hm_input['refs'])) {
        $refs = $hm_input['refs'];
    }
    if (isset($hm_input['messid'])) {
        $messid = $hm_input['messid'];
    }
    if (isset($hm_input['inreplyto'])) {
        $inreplyto = $hm_input['inreplyto'];
    }
    if (isset($hm_input['reply_send'])) {
        $hm_input['reply'] = 1;
    }
}
elseif (isset($hm_input['delete'])) {
    if (isset($hm_input['attachment'])) {
        if (file_exists($_SESSION['config']['settings_dir']."attachments/".
                        $hm_input['attachment'])) {
            unlink($_SESSION['config']['settings_dir']."attachments/".
                   $hm_input['attachment']);
            clearstatcache();
        }
        if (isset($_SESSION['attachments'][$hm_input['attachment']])) {
            unset($_SESSION['attachments'][$hm_input['attachment']]);
        }
    }
    $refs = '';
    $messid = '';
    $inreplyto = '';
    $to =       hm_htmlize($hm_input['to']);
    $cc =       hm_htmlize($hm_input['cc']);
    $bcc =      hm_htmlize($hm_input['bcc']);
    $subject =  hm_htmlize($hm_input['subject']);
    $message =  $hm_input['message'];
    if (isset($hm_input['refs'])) {
        $refs = $hm_input['refs'];
    }
    if (isset($hm_input['messid'])) {
        $messid = $hm_input['messid'];
    }
    if (isset($hm_input['inreplyto'])) {
        $inreplyto = $hm_input['inreplyto'];
    }
    if (isset($hm_input['reply_send'])) {
        $hm_input['reply'] = 1;
    }
}

/* no from address then set a default and warn the user */
if ($emtpy) {
    if (strstr($_SESSION['user'], '@')) {
        $_SESSION['profiles'][0]['from_address'] = $_SESSION['user'];
    }
    else {
        $_SESSION['profiles'][0]['from_address'] = $_SESSION['user']."@".
                                                   $config['domain'];
        $_SESSION['notices'][] = $str[168].'<br>'.$str[169].': '.
                                 $_SESSION['profiles'][0]['from_address'];
    }
}

/* check for missing folders */
hm_check_folders($imap_stream);

/* toolbar */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, $str[15]);


/* log out of imap */
if (is_resource($imap_stream)) {
    hm_imap_logout($imap_stream);
}

/* compose form */
if (isset($_SESSION['config']['max_file_size']))  {
    $max = $_SESSION['config']['max_file_size'];
}
else {
    $max = '2097152';
}

echo '<br><form enctype="multipart/form-data" action="compose.php" method="post">
     <input type="hidden" name="MAX_FILE_SIZE" value="',$max,'">
     <input type="hidden" value="',hm_htmlize($refs),
     '" name="refs">
     <input type="hidden" value="',hm_htmlize($messid),
     '" name="messid">
     <input type="hidden" value="',hm_htmlize($inreplyto),'" name="inreplyto">
     <input type="hidden" value="',$hm_input['id'],'" name="id">
     <input type="hidden" value="',$hm_input['mailbox'],'" name="mailbox">',"\n";
if (isset($hm_input['uid'])) {
   echo '     <input type="hidden" value="',$hm_input['uid'],'" name="uid">',"\n";
}
if (isset($hm_input['reply']) && $hm_input['reply'] == 1) {
    echo '<input type="hidden" value="1" name="reply_send">',"\n";
}
if (!$simple) {
    echo '<table align="center" cellpadding="3">
   <tr>
      <td valign="top" height="1%">
      <table class="tables2" cellpadding="0" cellspacing="1" width="100%">
         <tr>
            <td>
            <table align="center" class="tables1" cellpadding="1" cellspacing="4" ',
            'width="100%">
               <tr>
                  <td align="right">
                  <small><b>',$str[25],':</b></small>
                  </td>
                  <td>
                  <input type="text" name="to" value="',
                  str_replace('"', '&quot;', $to),'" class="text" tabindex="1">
                  </td>
               </tr>
               <tr>
                  <td align="right">
                  <small><b>',$str[87],':</b></small>
                  </td>
                  <td>
                  <input type="text" name="cc" value="',
                  str_replace('"', '&quot;', $cc),'" class="text" tabindex="2">
                  </td>
               </tr>
               <tr>
                  <td align="right">
                  <small><b>',$str[88],':</b></small>
                  </td>
                  <td>
                  <input type="text" name="bcc" value="',
                  str_replace('"', '&quot;', $bcc),'" class="text" tabindex="3">
                  </td>
               </tr>
               <tr>
                  <td align="right" width="20%">
                  <small><b>',$str[22],':</b></small>
                  </td>
                  <td>
                  <select name="from" class="select2" tabindex="4">',"\n";
}
else {
    echo '       ',$str[25],':  
          <input type="text" size="45" name="to" value="',
          str_replace('"', '&quot;', $to),'" class="text">
          <br>',$str[87],
          ': <input type="text" name="cc" size="45" value="',
          str_replace('"', '&quot;', $cc),'" class="text">
          <br>',$str[88],
          ': <input type="text" name="bcc" size="45" value="',
          str_replace('"', '&quot;', $bcc),'" class="text">
          <br>',$str[22],': <select name="from" class="select2">',"\n";
}
for($i=0;$i<$_SESSION['settings']['profile_count'];$i++) {
    if (isset($_SESSION['profiles'][$i]['from_address']) &&
        $_SESSION['profiles'][$i]['from_address'] != '') {
        echo "                 <option class=\"option2\" ";
        if (isset($match) && $match) {
            if (isset($index) && $index == $i) {
                echo "SELECTED ";
            }
        }
        elseif (isset($hm_input['from'])) {
            if ($hm_input['from'] == $i) {
                echo "SELECTED ";
            }
        }
        echo "value=\"$i\">";
        if (isset($_SESSION['profiles'][$i]['from_name']) &&
            $_SESSION['profiles'][$i]['from_name'] != '') {
            echo "\"",$_SESSION['profiles'][$i]['from_name'],"\" ";
        }                      
        echo                   $_SESSION['profiles'][$i]['from_address'],
                               "</option>\n";
    }
} 
echo '                  </select>',"\n";
if (!$simple) {
    echo '                  </td>
               </tr>
            </table>
            </td>
         </tr>
      </table>
      </td>
      <td rowspan="3" valign="top">
      <table align="center" class="tables2" cellpadding="0" cellspacing="1" width="100%">
         <tr>
            <td>
            <table align="center" class="tables1" cellpadding="1" cellspacing="4" ',
            'width="100%">
               <tr>
                  <td align="center" colspan="2" class="tables1" nowrap>
                  &nbsp;<input type="submit" name="to_add" class="button1" value="',
     $str[25],'">
                  &nbsp;<input type="submit" name="cc_add" class="button1" value="',
     $str[87],'">
                  &nbsp;<input type="submit" name="bcc_add" class="button1" value="',
     $str[88],'">
                  &nbsp;
                  </td>
               </tr>
               <tr>
                  <td colspan="2">
                  &nbsp;<input type="text" class="text2" size="35" name="search_terms" value="',
                  $search_terms,'">
                  </td>
               </tr>
               <tr>
                  <td colspan="2" align="center">
                  <input type="submit" class="button1" name="search" value="',$str[11],'">
                  &nbsp;&nbsp;
                  <input type="submit" class="button1" name="list" value="',$str[288],'">
                  </td>
               </tr>
               <tr>
                  <td align="center" colspan="2">
                  <select name="addresses[]" multiple size="20">';
}
else {
    echo '                  <br>',$str[14],': <select name="addresses[]">';
}
echo '                     <option disabled class="option2" value="">',
                           '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
                           '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
                           $str[161],
                           '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
                           '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
                           '</option>',"\n";
if (count($contacts) > 0) {
    foreach($contacts as $array) {
        if (!isset($array[3])) {
            $array[3] = '';
        }
        $title = hm_htmlize($array[1].'   '.$array[2].'   '.$array[3]);
        echo '<option value="',$array[0],'" ',
             'title="',$title,'">',
             hm_htmlize($array[2]),"</option>\n";
    }
}   
echo '                  </select>',"\n";
if (!$simple) {
    echo '                  </td>
               </tr>
               <tr>
                  <td align="center" colspan="2" class="tables1" nowrap>',"\n";
}
echo '                  &nbsp;<input type="submit" name="to_add" class="button1" value="',
     $str[25],'">
                  &nbsp;<input type="submit" name="cc_add" class="button1" value="',
     $str[87],'">
                  &nbsp;<input type="submit" name="bcc_add" class="button1" value="',
     $str[88],'">
                  &nbsp;',"\n";
if (!$simple) {
    echo '                  </td>
               </tr>',"\n";
}

if (isset($_SESSION['attachments']) && count($_SESSION['attachments']) > 0) {
    if (!$simple) {
        echo '               <tr>
                  <td colspan="2">
                  <br>
                  </td>
               </tr>
               <tr>
                  <td align="center" colspan="2">
                  <b>',$str[166],':</b>
                  </td>
               </tr>',"\n";
    }
    else {
        echo '<br>',$str[166],'<br>';
    }
    foreach($_SESSION['attachments'] as $index => $array) {
        $size = hm_size_format($array['size']);
        if (!$simple) {
            echo '               <tr class="tables2">
                  <td>
                  <input type="radio" name="attachment" value="',$index,'">
                  <font class="font1">',
                  $array['name'],'</font>
                  </td>
                  <td align="center">
                  <font class="font1">',$size,'</font>
                  </td>
               </tr>',"\n";
        }
        else {
            echo '          <input type="radio" name="attachment" value="',$index,'">
                  ',$array['name'],' ',$size;
        }
    }
    if (!$simple) {
        echo '               <tr>
                  <td colspan="2" align="center">
                  <input type="submit" name="delete" value="',$str[4],'" class="button1">
                  </td>
               </tr>
            </table>
            </td>
         </tr>
      </table>',"\n";
    }
    else {
        echo '        <input type="submit" name="delete" value="',$str[4],'" class="button1">';
    }
}
elseif (!$simple) {
    echo '            </table>
            </td>
         </tr>
      </table>',"\n";
}

if (!$simple) {
    echo '      </td>
   </tr>
   <tr>
      <td>
      <table class="tables2" cellpadding="0" cellspacing="1" width="100%">
         <tr>
            <td>
            <table align="center" class="tables1" cellpadding="1" ',
            'cellspacing="4" width="100%">
               <tr>
                  <td align="right" width="20%">
                  <small><b>',$str[21],':</b></small>
                  </td>
                  <td>
                  <input type="text" name="subject" value="',
                  str_replace('"', '&quot;', $subject),
                  '" class="text" tabindex="5">
                  </td>
               </tr>
            </table>
            </td>
         </tr>
      </table>
      </td>
   </tr>
   <tr>
      <td valign="top">
      <table class="tables2" cellpadding="0" cellspacing="1" width="100%">
         <tr>
            <td>
            <table align="center" class="tables1" cellpadding="1" ',
            'cellspacing="4" width="100%">
               <tr>
                  <td width="20%" valign="top">
                  <br>
                  &nbsp;<input type="submit" name="send" value="',$str[162],
                  '" class="button1" tabindex="7">
                  <br><br>
                  &nbsp;<input type="submit" name="sig" value="',$str[164],
                  '" class="button1" tabindex="8">';
    if (isset($_SESSION['settings']['drafts_folder'])) {
        echo '                  <br><br>
                  &nbsp;<input type="submit" name="save" value="',$str[163],
                  '" class="button1" tabindex="9">';
    }
    echo '                  </td>
                  <td nowrap>
                  <textarea class="composetext" name="message" cols="75" rows="20" tabindex="6">',
                  $message,'</textarea>
                  <br><br>
                  <input name="attachment" class="text2" type="file" size="45" tabindex="10">
                  &nbsp;&nbsp;&nbsp;
                  <input type="submit" name="attach" class="button1" value="',$str[165],'" tabindex="11">
                  <br><br>
                  </td>
               </tr>
            </table>
            </td>
         </tr>
      </table>
      </td>
   </tr>
</table>
</form>
</body>
</html>';
}
else {
    echo '<br>
Subject: <input type="text" name="subject" value="',
str_replace('"', '&quot;', $subject),'" size="45"><br>
<textarea name="message" cols="75" rows="20">',
$message,'</textarea><br>
<input type="submit" name="send" value="',$str[162],'">
<input type="submit" name="sig" value="',$str[164],'" ><br>
<input name="attachment" type="file" size="45"
<input type="submit" name="attach" value="',$str[165],'"><br>
</form>
</body>
</html>';
}
?>
