<?php

/* contacts.php: E-mail Address book
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: contacts.php,v 1.52 2004/03/25 19:11:07 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'contacts');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file)) {
    $config = $_SESSION['config'];
}
$hm_input['id'] = session_id();
$str = $_SESSION['str'];

/* check for simple option and set flag */
$simple = false;
if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 'true')
   || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 'true')) {
    $simple = true;
}

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config,
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* get unseen status */
$unseen = hm_unseen_status($imap_stream, $_SESSION['folders']);

/* defaults */
$addy = '';
$name = '';
$info = '';
$update = false;
$update_index = false;

/* adding from the message view page */
if (isset($hm_input['prep'])) {
    $addy = hm_htmlize($hm_input['prep_addy']);
}

/* if adding an address */
if (isset($hm_input['add']) || isset($hm_input['update'])) {
    $addy = $hm_input['addresses'];
    $addy = str_replace(array("\n", "\r", ','), ' ', $addy);
    $addy = preg_replace("/\s{2,}/", ' ', $addy);
    $addy = implode(', ', split(' ', $addy));
    
    if ($str['charset'] == 'UTF-8') {
        $name = utf8_encode($hm_input['name']);
        $info = utf8_encode($hm_input['info']);
    }
    else {
        $name = $hm_input['name'];
        $info = $hm_input['info'];
    }
    if ($addy == '') {
        $_SESSION['notices'][] = $str[159];
        if (isset($hm_input['update'])) {
            $update_index = $hm_input['update_index'];
            $update = true;
        }
    }
    elseif ($name == '') {
        $_SESSION['notices'][] = $str[158];
        if (isset($hm_input['update'])) {
            $update_index = $hm_input['update_index'];
            $update = true;
        }
    }
    elseif (strstr($addy.$name.$info, '|')) {
        $_SESSION['notices'][] = $str[157];
        if (isset($hm_input['update'])) {
            $update_index = $hm_input['update_index'];
            $update = true;
        }
    }
    elseif (!strstr($addy, '@')) {
        $_SESSION['notices'][] = $str[156];
        if (isset($hm_input['update'])) {
            $update_index = $hm_input['update_index'];
            $update = true;
        }
    }
    else {
        $contacts = hm_get_contacts($_SESSION['user'], $config['settings_dir']);
        if (isset($hm_input['update'])) {
            $contacts[$hm_input['update_index']] = 
                array($hm_input['update_index'], $addy, $name, $info);
            $write = hm_write_contacts($_SESSION['user'], $config['settings_dir'],
                                       $contacts);
            if (!$write) {
                $_SESSION['notices'][] = $str[153];
                $update_index = $hm_input['update_index'];
                $update = true;
            }
            else {
                $addy = '';
                $name = '';
                $info = '';
                $_SESSION['notices'][] = $str[152];
            }
        }
        elseif (isset($hm_input['add'])) {
            $index = count($contacts);
            $new = array($index, $addy, $name, $info);
            array_push($contacts, $new);
            $write = hm_write_contacts($_SESSION['user'], $config['settings_dir'],
                                       $contacts);
            if (!$write) {
                $_SESSION['notices'][] = $str[155];
            }
            else {
                $addy = '';
                $name = '';
                $info = '';
                $_SESSION['notices'][] = $str[154];
            }
        }
    }
}
elseif (isset($hm_input['delete'])) {
    if (isset($hm_input['index'])) {
        $contacts = hm_get_contacts($_SESSION['user'], $config['settings_dir']);
        if (isset($contacts[$hm_input['index']])) {
            array_splice($contacts, $hm_input['index'], 1); 
            $write = hm_write_contacts($_SESSION['user'], $config['settings_dir'], 
                                       $contacts);
            $_SESSION['notices'][] = $str[255];
        }
    }
}
elseif (isset($hm_input['edit'])) {
    if (isset($hm_input['index'])) {
        $contacts = hm_get_contacts($_SESSION['user'], $config['settings_dir']);
        if (isset($contacts[$hm_input['index']])) {
            $addy = $contacts[$hm_input['index']][1];
            $name = $contacts[$hm_input['index']][2];
            $info = $contacts[$hm_input['index']][3];
            $update = true;
            $update_index = $hm_input['index'];
        }
    }
}

/* toolbar */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, $str[146]);

/* form for adding new contacts */
echo '<br><form method="post" action="contacts.php">
<input type="hidden" name="id" value="',$hm_input['id'],'">
<input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">',"\n";
if (!$simple) {
    echo '<table align="center">
   <tr>
      <td valign="top">
      <table class="tables2" cellpadding="2" cellspacing="0" width="100%">
         <tr>
            <td colspan="2" align="center">',"\n";
}
if ($update) {
    echo '            ',$str[151];
}
else {
    echo '            ',$str[148];
}
if (!$simple) {
    echo '            </td>
         </tr>
         <tr>
            <td class="tables1">
            <table align="center" class="tables1" cellpadding="1" ', 
            'cellspacing="4" width="100%">
               <tr>
                  <td>
                  ',$str[144],'
                  </td>
                  <td>
                  <small>(',$str[142],')</small>
                  </td>
               </tr>
               <tr>
                  <td align="center" colspan="2">
                  <textarea class="text" name="addresses" rows="3" cols="50">'
                  ,hm_htmlize($addy),'</textarea>
                  </td>
               </tr>
               <tr>
                  <td>
                  ',$str[93],'
                  </td>
                  <td>
                  <small>(',$str[142],')</small>
                  </td>
               </tr>
               <tr>
                  <td align="center" colspan="2">
                  <input type="text" name="name" class="text" value="',
                  hm_htmlize($name),'">
                  </td>
               </tr>
               <tr>
                  <td>
                  ',$str[150],'
                  </td>
                  <td>
                  <small>(',$str[143],')</small>
                  </td>
               </tr>
               <tr>
                  <td align="center" colspan="2">
                  <input type="text" name="info" class="text"', 
                  ' value="',hm_htmlize($info),'">
                  </td>
               </tr>
               <tr>
                  <td align="center" colspan="2">',"\n";
}
else {
    echo $str[144], ' (',$str[142],')<br>
                  <textarea class="text" name="addresses" rows="3" cols="50">',hm_htmlize($addy),'</textarea><br>
                  ',$str[93],' (',$str[142],')<br>
                  <input type="text" name="name" class="text" value="',
                  hm_htmlize($name),'"><br>
                  ',$str[150],' (',$str[143],')<br>
                  <input type="text" name="info" class="text"', 
                  ' value="',hm_htmlize($info),
                  '"><br>';
}
if ($update) {
    echo '                  <input type="submit" name="update" class="button1" ',
                            'value="',$str[61],'">
                  <input type="hidden" value="',$update_index,'" name="update_index">',
                  "\n";
}
else {
    echo '                  <input type="submit" name="add" class="button1" ',
                            'value="',$str[43],'">',"\n";
}
if (!$simple) {
    echo '                  </td>
               </tr>
            </table>
            </td>
         </tr>
      </table>
      </td>
   </tr>
</table>',"\n";
}
else {
    echo '<br>';
}

/* table of existing contacts */
$contacts = hm_get_contacts($_SESSION['user'], $config['settings_dir']);
if (!$simple) {
    echo '<br>
<table align="center" width="95%">
   <tr>
      <td valign="top">
      <table class="tables2" cellpadding="2" cellspacing="0" width="99%">
         <tr>
            <td colspan="2" align="center">
            ',$str[147],'
            </td>
         </tr>
         <tr>
            <td class="tables1">
            <table align="center" class="tables1" cellpadding="4" ', 
            'cellspacing="1" width="100%">
               <tr>
                  <td>
                  </td>
                  <td>
                  ',$str[101],'
                  </td>
                  <td>
                  ',$str[93],'
                  </td>
                  <td>
                  ',$str[149],'
                  </td>
               </tr>',"\n";
}
else {
    echo '<br>',$str[147],'<br>';
}
if (!empty($contacts)) {
    foreach ($contacts as $index => $array) {
        if (!$simple) {
            echo '               <tr class="tables5">
                  <td>
                  <input type="radio" name="index" value="',$index,'">
                  </td>
                  <td>
                  ',hm_htmlize($array[1]),'
                  </td>
                  <td>
                  ',hm_htmlize($array[2]),'
                  </td>
                  <td>
                  ',hm_htmlize($array[3]),'
                  </td>
               </tr>',"\n";
        }
        else {
            echo '
                  <input type="radio" name="index" value="',$index,'">
                  ',hm_htmlize($array[1]),'
                  ',hm_htmlize($array[2]),'
                  ',hm_htmlize($array[3]),'<br>';
        }
    }
}
else {
    if (!$simple) {
        echo '               <tr class="tables5">
                  <td colspan="4" align="center">
                  ', $str[160],'
                  </td>
               </tr>',"\n";
    }
    else {
        echo '<br>',$str[160],'<br>';
    }
}
if (!$simple) {
    echo '               <tr>
                  <td colspan="4" align="center">
                  <input type="submit" name="delete" value="',$str[4],'" class="button1">
                  &nbsp;
                  <input type="submit" name="edit" value="',$str[145],
                    '" class="button1">
                  </td>
               </tr>
            </table>
            </td>
         </tr>
      </table>
      </td>
   </tr>
</table>',"\n";
}
else {
    echo '<input type="submit" name="delete" value="',$str[4],'" class="button1">
          <input type="submit" name="edit" value="',$str[145],'" class="button1">';
}
    
echo '</form>
</body>
</html>';

hm_imap_logout($imap_stream); 

?>
