<?php

/* download.php: page to format message parts for download
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: download.php,v 1.16 2004/05/03 05:03:23 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'download');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file, true, true)) {
    $config = $_SESSION['config'];
}

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config, 
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* select the mailbox for imap */
hm_select_mailbox($imap_stream, $hm_input['mailbox']);

/* send HTTP headers for this part */
header('Pragma: ');
header('Cache-Control: cache');
header("Cache-control: private");
header("Content-type: ".$hm_input['type'].'/'.$hm_input['subtype']);
header("Content-Disposition: filename=\"".trim($hm_input['name'])."\""); 

if (!isset($hm_input['decode'])) {
    $decode = false;
}
else {
    $decode = $hm_input['decode'];
}

/* output message part */
hm_output_message_part ($imap_stream, $hm_input['uid'], $hm_input['part'], $decode);

/* logout of imap and exit */
hm_imap_logout($imap_stream);

exit;

?>
