<?php

/* folders.php: Page to add/delete IMAP folders
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: folders.php,v 1.96 2004/04/30 04:33:53 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'folders');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file)) {
    $config = $_SESSION['config'];
}
$hm_input['id'] = session_id();
$str = $_SESSION['str'];
$sort_types = $str['sort_types'];

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config, 
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* check for simple option and set flag */
$simple = false;
if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 'true')
   || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 'true')) {
    $simple = true;
}

/* create a new folder */
if (isset($hm_input['create'])) {
    if ($hm_input['newfolder'] != '') {
        if (!isset($hm_input['allow_subs'])) {
            $hm_input['allow_subs'] = 'no';
        }
        if (isset($config['utf7_decode'])) {
            $hm_input['newfolder'] = imap_utf7_encode(utf8_decode(
                                     $hm_input['newfolder']));
        }
        $_SESSION['notices'][] = hm_create_folder($hm_input['newfolder'], $imap_stream, 
                                   $hm_input['parent'], $hm_input['allow_subs']);
        $_SESSION['folders'] = hm_boxlist($imap_stream);
        $_SESSION['dsp_folders'] = hm_folder_dsp($_SESSION['folders']);
        if (isset($config['utf7_decode'])) {
            $hm_input['newfolder'] = imap_utf7_encode(utf8_decode(
                                     $hm_input['newfolder']));
        }
    }
}

/* delete a folder */
elseif (isset($hm_input['delete'])) {
    $box_list = hm_boxlist($imap_stream, false, 'all');
    $subs = false;
    $sub_list = '';
    $delim = $_SESSION['delimiter'];
    foreach ($box_list as $box) {
        if ($box != $hm_input['delfolder'] && substr($box, 0, 
            strlen($hm_input['delfolder'].$delim)) 
                    == $hm_input['delfolder'].$delim) {
            $sub_list = "$box<br>";
            $subs = true;
        }
    }
    if (!$subs) {
        /* get unseen messages */
        $unseen = hm_unseen_status ($imap_stream, $_SESSION['folders']);

        /* toolbar */
        hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, $str[13]);
       
        /* add a check for drafts folder deletion here */
        if (isset($_SESSION['settings']['sent_folder']) &&
            $_SESSION['settings']['sent_folder'] == urlencode($hm_input['delfolder'])) {
            $warn = $str[135]."\n";
        }
        else {
            $warn = '';
        }
        if (isset($_SESSION['settings']['trash_folder']) &&
           $_SESSION['settings']['trash_folder'] == urlencode($hm_input['delfolder'])) {
            $warn2 = $str[136]."\n";
        }
        else {
            $warn2 = '';
        }
        echo '<br>
<form>
<table align="center" class="tables4">
   <tr>
      <td align="center">
      <br>',$str[137],'
      </td>
   </tr>
   <tr>
      <td align="center">
      ',$warn,'
      </td>
   </tr>
   <tr>
      <td align="center">
      ',$warn2,'
      </td>
   </tr>
   <tr>
      <td align="center">
      <font class="font2">',$str[138],'<br><br>';
        if (isset($config['utf7_decode'])) {
            echo utf8_encode(imap_utf7_decode($hm_input['delfolder']));
        }
        else {
            echo $hm_input['delfolder'];
        }
        echo ' ?</font><br>
      <input type="hidden" name="id" value="',$hm_input['id'],'">
      <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">
      <input type="hidden" name="delfolder" value="',$hm_input['delfolder'],'">
      <br><input type="submit" class="button1" name="confirm_del" value="',$str[139],'">
      <br><br>
      </td>
   </tr>
</table>
</form>
</body>
</html>';
        exit;
    }
    else {
        $_SESSION['notices'][] = '['.$hm_input['delfolder'].']'.
                                 $str[243].':<br>'.$sub_list;
    }
}

/* confirmed delete folder */
elseif (isset($hm_input['confirm_del'])) {
    $_SESSION['notices'][] = $tmp = hm_delete_folder($hm_input['delfolder'], 
                                                   $imap_stream, $config['settings_dir']);
    hm_check_folders($imap_stream);
    $_SESSION['folders'] = hm_boxlist($imap_stream);
    $_SESSION['dsp_folders'] = hm_folder_dsp($_SESSION['folders']);
}
elseif (isset($hm_input['rename'])) {
    if (isset($hm_input['rename_new']) && trim($hm_input['rename_new']) != '') {
        $_SESSION['notices'][] = hm_rename_folder($hm_input['rename_folder'], 
                                   $imap_stream, trim($hm_input['rename_new']), 
                                   $config['settings_dir']);
    }
    $_SESSION['folders'] = hm_boxlist($imap_stream);
    $_SESSION['dsp_folders'] = hm_folder_dsp($_SESSION['folders']);
}

/* update settings */
elseif (isset($hm_input['update'])) {
    $hidden = array();
    $new_mail_folders = array();
    $sorts = array();
    $sorts_tmp = array();
    $full_list = hm_boxlist($imap_stream, false, 'all');
    sort($full_list);
    foreach($_POST as $key => $value) {
        if (substr($key, 0, 5) == 'hide_' && $value == 'on') {
            $hidden[] = $full_list[substr($key, 5)];
        }
        if (substr($key, 0, 5) == 'sort_' && $value != 'ARRIVAL') {
            $sorts[urlencode($full_list[substr($key, 5)])] = $value;
        }
        if (substr($key, 0, 4) == 'new_' && $value == 'on') {
            $new_mail_folders[] = $full_list[substr($key, 4)];
        }
    }
    array_unshift($new_mail_folders, 'INBOX');
    $new_mail_folders = array_diff($new_mail_folders, $hidden);
    $sorts = array_diff($sorts, $hidden);
    if (!empty($sorts)) {
        $_SESSION['settings']['sort'] = $sorts;
    }
    else {
        if (isset($_SESSION['settings']['sort'])) {
            $_SESSION['settings']['sort'] = array();
            unset($_SESSION['settings']['sort']);
        }
    }
    $_SESSION['settings']['new_mail_folders'] = $new_mail_folders;
    if (!empty($hidden)) {
        $_SESSION['settings']['hidden'] = $hidden;
        $_SESSION['folders'] = array_diff($full_list, $hidden);
        $_SESSION['dsp_folders'] = hm_folder_dsp($_SESSION['folders']);
    }
    else {
        $_SESSION['settings']['hidden'] = array();
        unset($_SESSION['settings']['hidden']);
        $_SESSION['folders'] = $full_list;
        $_SESSION['dsp_folders'] = hm_folder_dsp($_SESSION['folders']);
    }
    hm_write_settings($_SESSION['user'], $config['settings_dir']);
    $_SESSION['sort_data'] = array();
    $_SESSION['notices'][] = $str[118];
}

/* get unseen messages */
$unseen = hm_unseen_status ($imap_stream, $_SESSION['folders']);

/* if the folder list update was selected */
if (isset($hm_input['Update'])) {
    if (isset($_SESSION['missing_folders_flag'])) {
        $_SESSION['missing_folders_flag'] = 0;
        unset($_SESSION['missing_folders_flag']);
    }  
    if (isset($_SESSION['missing_folders'])) {
        $_SESSION['missing_folders'] = array();
        unset($_SESSION['missing_folders']);
    }
    $new = array();
    $modified = array();
    $_SESSION['folders'] = hm_boxlist($imap_stream, true, 'all');
    $_SESSION['dsp_folders'] = hm_folder_dsp($_SESSION['folders']);
}

else {
    /* get updated folder list */
    if (!isset($_SESSION['folders'])) {
        $_SESSION['folders'] = hm_boxlist($imap_stream, true, 'all');
        $_SESSION['dsp_folders'] = hm_folder_dsp($_SESSION['folders']);
        $new = array();
        $modified = array();
    }
    else {
        $updated_list = hm_boxlist($imap_stream, true, 'all');
        $new = (array_diff($updated_list, $_SESSION['folders']));
        if (isset($_SESSION['missing_folders'])) {
            $modified = $_SESSION['missing_folders'];
        }
        else {
            $modified = array();
        }
    }
}

/* toolbar */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, $str[13]);
$full_list = hm_boxlist($imap_stream, false);
$full_list_dsp = hm_folder_dsp($full_list);

/* if the folder list needs to be updated */
if (!empty($new) || !empty($modified)) {
    echo '<br><center><big><font class="font2">',$str[244],'
</font></big></center>',"\n";
    if (!empty($new)) {
        echo '<br><center>',$str[245],':';
        foreach ($new as $new_folder) {
            echo " <b>$new_folder</b>";
        }
        echo "</center>\n";
    }
    if (!empty($modified)) {
        echo '<br><center>',$str[140],':';
        foreach ($modified as $new_folder) {
            echo " <b>$new_folder</b>";
        }
        echo "</center>\n";
    }
    echo '<form action="folders.php" method="post">
<br><center><input class="button1" type="submit" name="Update" value="',$str[61],'">
<input type="hidden" name="id" value="',$hm_input['id'],'">
</form><br>',"\n";
}

/* folder options form */
else {
    $delim = $_SESSION['delimiter'];
    echo '<form action="folders.php" method="post"><br>',"\n";
if (!$simple) {
echo '<table class="tables1" width="70%" align="center" cellpadding="2" cellspacing="1">
   <tr class="tables2">
      <td colspan="3" align="center">
      ',$str[121],'
      </td>
   </tr>
   <tr>
      <td colspan="3">
      &nbsp;
      </td>
   </tr>
   <tr>
      <td nowrap>
      &nbsp;&nbsp;&nbsp;
      ',$str[123],'
      </td>
      <td align="right" valign="top">
      <input type="text" size="30" class="text2" name="newfolder">
      &nbsp;&nbsp;&nbsp;
      </td>
      <td align="center" rowspan="3" valign="top">
      <input type="submit" name="create" class="button1" value="',$str[132],'">
      <input type="hidden" name="id" value="',$hm_input['id'],'">
      &nbsp;&nbsp;
      </td>
   </tr>',"\n";
}
else {
    echo $str[123],'
<input type="text" size="30" name="newfolder">
<input type="submit" name="create" value="',$str[132],'">
<input type="hidden" name="id" value="',$hm_input['id'],'"><br>',"\n";
}

if (isset($_SESSION['delimiter']) && $_SESSION['delimiter'] == '/') {
    if (!$simple) {
        echo '   <tr>
      <td nowrap>
      &nbsp;&nbsp;&nbsp;
      ',$str[124],'
      </td>
      <td align="right">
      <input type="radio" name="allow_subs" value="yes">
      ',$str[125],' 
      <input type="radio" checked name="allow_subs" value="no">
      ',$str[126],'
      &nbsp;&nbsp;&nbsp;
      </td>
   </tr>',"\n";
    }
    else {
        echo $str[124],':&nbsp;
      ',$str[125],'<input type="radio" name="allow_subs" value="yes">
      ',$str[126],'<input type="radio" checked name="allow_subs" value="no"><br>',"\n";
    }
}
$can_have_subs = hm_boxlist ($imap_stream, false, 'can_have_kids');
$can_have_subs_dsp = hm_folder_dsp($can_have_subs);
if (!$simple) {
    echo '   <tr>
      <td nowrap>
      &nbsp;&nbsp;&nbsp;',"\n";
}
echo '      ',$str[127];
if (!$simple) {
    echo '      </td>
      <td align="right">',"\n";
}
echo '      <select name="parent">',"\n";
foreach ($can_have_subs as $value) {
    if ($value == 'INBOX') {
        echo "      <option value=\"$value\">",$str[141],"</option>\n";
    }
    else {
        if (isset($config['utf7_decode'])) { 
            echo "      <option value=\"$value\">",
                 utf8_encode(imap_utf7_decode($can_have_subs_dsp[$value])), "</option>\n";
        }
        else {
            echo "      <option value=\"$value\">",$can_have_subs_dsp[$value],
                 "</option>\n";
        }
    }
}
echo '      </select>',"\n";
if (!$simple) {
    echo '      &nbsp;&nbsp;&nbsp;
      </td>
   </tr>
   <tr>
      <td colspan="3">
      &nbsp;
      </td>
   </tr>
   <tr>
      <td nowrap>
      &nbsp;&nbsp;&nbsp;',"\n";
}
else {
    echo '<br>';
}
echo '      ',$str[128],"\n";
if (!$simple) {
    echo '      </td>
      <td align="right">',"\n";
}
echo '      <select name="delfolder">',"\n";
    $del_list = hm_boxlist ($imap_stream, false, 'all');
    $del_list_dsp = hm_folder_dsp($del_list);
    array_shift($del_list);
    foreach ($del_list as $value) {
        echo "      <option value=\"$value\">";
        if (!$simple && substr_count($del_list_dsp[$value], $delim) > 0) {
            $pos = strrpos($del_list_dsp[$value], $delim);
            echo str_repeat('&nbsp;', intval($pos/2)),'|_ ';
            if (isset($config['utf7_decode'])) {
                echo utf8_encode(imap_utf7_decode(substr($del_list_dsp[$value], 
                     ($pos + 1)))),"\n";
            }
            else {
                echo substr($del_list_dsp[$value], ($pos + 1)),"\n";
            }
        }
        else {
            if (isset($config['utf7_decode'])) {
                echo utf8_encode(imap_utf7_decode($del_list_dsp[$value]));
            }
            else {
                echo $del_list_dsp[$value];
            }
        }
        echo "</option>\n";
    }
    echo '      </select>',"\n";
if (!$simple) {
    echo '      &nbsp;&nbsp;&nbsp;
      </td>
      <td align="center">';
}
echo '      <input type="submit" class="button1" name="delete" value="',$str[4],'">';
if (!$simple) {
    echo '      &nbsp;&nbsp;
      </td>
   </tr>
   <tr>
      <td colspan="3">
      &nbsp;
      </td>
   </tr>
   <tr>
      <td nowrap>
      &nbsp;&nbsp;&nbsp;
      ',$str[240],'
      </td>
      <td align="right">',"\n";
}
else {
    echo '<br>',$str[240],'&nbsp;';
}
echo '      <select name="rename_folder">',"\n";
    foreach ($del_list as $value) {
        echo "      <option value=\"$value\">";
        if (!$simple && substr_count($del_list_dsp[$value], $delim) > 0) {
            $pos = strrpos($del_list_dsp[$value], $delim);
            echo str_repeat('&nbsp;', intval($pos/2)),'|_ ';
            if (isset($config['utf7_decode'])) {
                 echo utf8_encode(imap_utf7_decode(substr($del_list_dsp[$value],
                      ($pos + 1)))),"\n";
            }
            else {
                 echo substr($del_list_dsp[$value], ($pos + 1)),"\n";
            }
        }
        else {
            if (isset($config['utf7_decode'])) {
                echo utf8_encode(imap_utf7_decode($del_list_dsp[$value]));
            }
            else {
                echo $del_list_dsp[$value];
            }
        }
        echo "</option>\n";
    }
    echo '      </select>
      -&gt;<input class="text2" type="text" name="rename_new" size="25">',
      '&nbsp;&nbsp;&nbsp;',"\n";
if (!$simple) {
echo '      </td>
      <td align="center">
      <input type="submit" class="button1" value="',$str[239],'" name="rename">
      &nbsp;&nbsp;
      </td>
   </tr>
   <tr>
      <td colspan="3">
      <br>
      </td>
   </tr>
</table>',"\n";
}
else {
    echo '<input type="submit" name="rename" value="',$str[239],'">',"\n";
}
echo '</form>',"\n";

    /* per folder options */
    sort($full_list);
    if (isset($_SESSION['settings']['hidden'])) {
        $hidden = $_SESSION['settings']['hidden'];
    }
    else {
        $hidden = array();
    }
    if (isset($_SESSION['settings']['sort'])) {
        $sort = $_SESSION['settings']['sort'];
    }
    else {
        $sort = array();
    }
    if (isset($_SESSION['config']['client_sort']) && 
              $_SESSION['config']['client_sort'] == 'true') {
        $sort_types = $str['client_sort_types'];
    }
    echo '<br><form method="post" action="folders.php">
<input type="hidden" name="id" value="',$hm_input['id'],'">',"\n";
if (!$simple) {
echo '<table class="tables1" width="60%" align="center" cellpadding="1" cellspacing="1">
   <tr class="tables2">
      <td align="center" colspan="6">
      ',$str[122],'
      </td>
   </tr>
   <tr>
      <td colspan="5" class="tables1">
      <br>
      </td>
   </tr>
   <tr class="tables1">
      <td align="center" colspan="2">
      ',$str[129],'
      </td>
      <td align="center">
      ',$str[130],'
      </td>
      <td align="center">
      ',$str[131],'
      </td>
      <td align="center">
      ',str_replace(' ', '<br>', $str[265]),'
      </td>
   </tr>',"\n";
}
else {
    echo '<table><tr><td>',$str[129],'</td><td>',$str[130],'</td><td>',$str[131],
         '</td></tr>',"\n";
}
foreach ($full_list as $key => $folder) {
    if (in_array($folder, $_SESSION['nosel_folders'])) {
        $nosel = true;
    }
    else {
        $nosel = false;
    }
    $hide_controls = false;
    if (in_array($folder, $hidden)) {
        $hide_controls = true;
    }
    if (!$simple) {
        echo '   <tr class="tables5">
      <td class="tables1" width="20">
      </td>
      <td width="20%" nowrap>',"\n";
        if ($hide_controls) {
            echo '<font style="{color:#555555}">';
        }
        if (!$simple && substr_count($full_list_dsp[$folder], $delim) > 0) {
            $pos = strrpos($full_list_dsp[$folder], $delim);
            echo str_repeat('&nbsp;', $pos),'|_ ';
            if (isset($config['utf7_decode'])) {
                 echo utf8_encode(imap_utf7_decode(substr($full_list_dsp[$folder], 
                      ($pos + 1)))),"\n";
            }
            else {
                 echo substr($full_list_dsp[$folder], ($pos + 1)),"\n";
            }
        }
        else {
            if (isset($config['utf7_decode'])) {
                echo '&nbsp;&nbsp;',utf8_encode(imap_utf7_decode(
                     $full_list_dsp[$folder]));
            }
            else {
                echo '&nbsp;&nbsp;',$full_list_dsp[$folder];
            }
        }
        if ($hide_controls) {
            echo '</font>';
        }
        echo '      </td>
      <td class="tables5" align="center" valign="middle">',"\n";
    }
    else {
        echo '<tr><td>',$folder,'</td><td>',"\n";
    }
    if ($folder != 'INBOX') {
        echo "      <input type=\"checkbox\" ";
        if ($hide_controls) {
            echo ' CHECKED ';
        }
        echo "name=\"hide_",$key,"\">\n";
    }
    if (!$hide_controls) {
        if (!$simple) {
            echo '      </td>
      <td class="tables5" align="center">';
            if (!$nosel) {
                echo '      <select class="text2" name="sort_',$key,'">',"\n";
            }
        }
        elseif (!$nosel) {
            echo '</td><td>
<select class="text2" name="sort_',$key,'">',"\n";
        }
        if (!$nosel) {
        foreach ($sort_types as $index => $value) {
            echo "      <option class=\"text2\" ";
            if (array_key_exists(urlencode($folder), $sort) && 
                $sort[urlencode($folder)] == $index) {
                echo "SELECTED ";
            }
            echo "value=\"",$index,"\">",
                        $value,"</option>\n";
        }
        echo '      </select>',"\n";
        }
        if (!$simple) {
            echo '      </td>
      <td align="center">',"\n";

            if (!in_array($folder, $_SESSION['nosel_folders']) &&
                $folder != 'INBOX') {
            echo '      <input type="checkbox" name="new_'.$key.'"';
                if (isset($_SESSION['settings']['new_mail_folders']) &&
                    in_array($folder, $_SESSION['settings']['new_mail_folders'])) {
                    echo ' CHECKED>';
                }
            else {
                echo '>';
            }
            }
            echo '
      </td>
      <td class="tables1" width="20">
      </td>
   </tr>',"\n";
        }
        else {
            echo '</td></tr>';
        }
    }
    else {
        echo '</td><td colspan="2" class="tables5">',"\n";
    }
}
if (!$simple) {
    echo '   <tr>
      <td colspan="5" class="tables1" align="center">
      <br>
      <input class="button1" type="submit" name="update" value="',$str[103],'">
      <br><br>
      </td>
   </tr>
</table>',"\n";
}
else {
    echo '</table>
      <br>
<input class="button1" type="submit" name="update" value="',$str[103],'">';
}
echo '</form>',"\n";
} 
echo '</body>
</html>';

hm_imap_logout($imap_stream); 

?>
