<?php

/*  iframe.php: Simple page to keep the PHP session alive
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: iframe.php,v 1.4 2003/08/26 03:57:57 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'iframe');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file, false, true)) {
    $config = $_SESSION['config'];
}
$str = $_SESSION['str'];

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");             

/* meta tag to refresh the session to keep it from inactivity timeouts */
echo '
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=',$str['charset'],'">
<meta HTTP-EQUIV="refresh" content="300;url=', $config['hostname'],
    $config['install_path'], 'iframe.php?id=',session_id(),'">
</head>
<body>
</body>
</html>'

?>
