<?php

/* login.php: Login page, pretty basic 
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: login.php,v 1.36 2004/03/23 20:39:29 sailfrog Exp $
*/

require_once('../lib/constant.php');
require_once('../lib/general.php');

ob_start();

$simple = false;
if (isset($_SERVER['HTTP_USER_AGENT']) && (!isset($config['no_auto_simplify']) || 
    $config['no_auto_simplify'] != 'true')) {
    if (hm_browser_type ($_SERVER['HTTP_USER_AGENT'])) {
        $simple = true;
    }
}

$page_start = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>Hastymail</title>
  <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=ISO-8859-1">';
if (!$simple) {
    $page_start .= '
  <link rel="stylesheet" type="text/css" href="../themes/default.css">';
}
echo '
  <link rel="SHORTCUT ICON" href="../images/hastymail.ico">
</head>
<body>'."\n";

if (!is_readable($config_file)) {
    echo $page_start, '<br><br><center>
<h3>Configuration Read Error</h3>
<br>
Configuration file not found or unreadable.
<br>Please contact your system administrator to investigate the issue.',"\n";
}
else {
    require_once('../lib/session.php');
    $config = hm_get_config($config_file);
    if (isset($config['default_lang'])) {
        $str = hm_translate($config['default_lang']);
    }
    else {
        $str = hm_translate('en_US');
    }
    if (isset($config['page_title'])) {
        $page_start = str_replace('<title>Hastymail</title>',
                                   '<title>'.$config['page_title'].' '.$str[92].
                                   '</title>',$page_start);
        $title = $config['page_title'];
    }
    else {
        $page_start = str_replace('<title>Hastymail</title>', '<title>Hastymail '.
                                   $str[92].'</title>',$page_start);
        $title = 'Hastymail ';
    }
    if (isset($config['force_ssl']) && $config['force_ssl'] == 'true') {
        if ($_SERVER['SERVER_PORT'] != '443') {
            header("Location:https://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF']);
        }
    }
    $page_start = str_replace('ISO-8859-1', $str['charset'], $page_start);
    $servers = array();
    foreach($config as $name => $value) {
        if (substr($name, 0, 3) == 'alt') {
            $alt = substr($name, 4, 1);
            if (!isset($servers[$alt])) {
                $servers[$alt] = array();
            }
            $servers[$alt][substr($name, 6)] = $value;
        }
    }
    if (isset($config['default_theme']) && $config['default_theme'] != '') {
        $page_start = str_replace('default.css', $config['default_theme'], $page_start);
    }
    echo $page_start,'<form method="post" action="mailbox.php">
<br>';
    if (isset($config['login_banner']) && $config['login_banner'] != 'false' &&
        $config['login_banner'] != '' && !$simple) {
        if (isset($config['banner_type'])) {
            if ($config['banner_type'] == 'image') {
                echo '<center><img src="../images/',$config['login_banner'],
                     '"></center>',"\n";
            }
            elseif ($config['banner_type'] == 'text') {
                echo '<center>',$config['login_banner'],'</center>';
            }
        }
    }
    else {
        echo '<br>';
    }
    if (!$simple) {
        echo '<br><br>
<table border="0" align="center" cellpadding="6" cellspacing="0" class="tables2">
   <tr class="tables1">
      <td  colspan="2" align="center">
      <h3><font>',$title,' ',$str[92],'</font></h3>
      </td>
   </tr>
   <tr class="tables2">
      <td  colspan="2" align="center">
      &nbsp;
      </td>
   </tr>
   <tr class="tables2">
      <td align="right">
      <small><b>',$str[93],':</b></small>&nbsp;
      </td>
      <td align="center">
      <input type="text" class="text2" name="user">
      </td>
   </tr>
   <tr class="tables2">
      <td align="right">
      <small><b>',$str[94],':</b></small>&nbsp;
      </td>
      <td align="center">
      <input type="password" class="text2" name="pass">
      </td>
   </tr>',"\n";
}
else {
    echo '      <br><br><center><small><b>',$str[93],':</b></small>&nbsp;
      <input type="text" class="text2" name="user"><br>
      <small><b>',$str[94],':</b></small>&nbsp;
      <input type="password" class="text2" name="pass"><br>';
}
if (!empty($servers)) {
    if (!$simple) {
        echo '   <tr class="tables2">
      <td align="right">
      <small><b>&nbsp;',$str[287],'</b></small>&nbsp;
      </td>
      <td align="center">';
    } 
    echo '      <select name="alt_server" class="select3">
         <option value="0">';
    if (isset($config['imap_server_label']) && $config['imap_server_label'] != 'false') {
        echo $config['imap_server_label'];
    }
    else {
        echo $config['imap_server'];
    }
    echo "</option>\n";
    foreach ($servers as $index => $array) {
        if (isset($array['imap_server_label']) && $array['imap_server_label'] !=
            'false') {
            $value = $array['imap_server_label'];
        }
        else {
            $value = $array['imap_server'];
        } 
        echo '         <option value="',$index,'">',$value,
             "</option>\n";
    }
    echo '      </select>',"\n";
    if (!$simple) {
        echo '  </td>
   </tr>',"\n";
    }
}
if (!$simple) {
    echo '   <tr class="tables2">
      <td colspan="2" align="center">
      <input type="submit" name="login" class="button1" value="',$str[92],'">
      </td>
   </tr>
</table>';
}
else {
    echo '<br><input type="submit" name="login" class="button1" value="',$str[92],'">
</center>';
}
echo '</form>',"\n";
}
echo '</body>
</html>',"\n";

?>
