<?php

/* logout.php:  Clean up and logout
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: logout.php,v 1.23 2004/05/05 06:22:16 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'logout');

$config = hm_get_config($config_file);
if (isset($config['page_title'])) {
    $title = $config['page_title'];
}
else {
    $title = 'Hastymail';
}
if (isset($hm_input['id'])) {
    $id = $hm_input['id'];
}
else {
    if (isset($config['default_lang'])) {
        $str = hm_translate($config['default_lang']);
    }
    else {
        $str = hm_translate('en_US');
    }
    if (isset($config['default_theme']) && $config['default_theme'] != '') {
        $style = $config['default_theme'];
    }
    else {
        $style = 'default.css';
    }
    if (isset($config['signout_url']) && $config['signout_url'] != '') {
        header ("Location:".$config['signout_url']);
        exit;
    }
    echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
   <title>
      ',$title,' Logout
   </title>
  <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=',$str['charset'],'">
  <link rel="stylesheet" type="text/css" href="../themes/',$style,'">
  <link rel="SHORTCUT ICON" href="../images/hastymail.ico">
</head>
<body>
<table align="center">
   <tr>
      <td align="center">
      <br><br><br><b>',$str[95],'</b>
      </td>
   </tr>
   <tr>
      <td align="center">
      <small><a href="',$config['hostname'],$config['install_path'],'login.php"',
      '>',$str[96],'</a></small>
      </td>
   </tr>
</table>
</body>
</html>',"\n";
    exit;
}
    
hm_session_logout($id, $config_file);
if (isset($config['default_lang'])) {
    $str = hm_translate($config['default_lang']);
}
else {
    $str = hm_translate('en_US');
}

if (isset($config['signout_url']) && $config['signout_url'] != '') {
    header ("Location:".$config['signout_url']);
    exit;
}
if (isset($config['default_theme']) && $config['default_theme'] != '') {
    $style = $config['default_theme'];
}
else {
    $style = 'default.css';
}
echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
   <title>',$title,' ',$str[97],'</title>
   <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=ISO-8859-1">
   <link rel="stylesheet" type="text/css" href="../themes/',$style,'">
   <link rel="SHORTCUT ICON" href="../images/hastymail.ico">
</head>
<body>
<table align="center">
   <tr>
      <td align="center">
      <br><br><br><b>',$str[95],'</b>
      </td>
   </tr>
   <tr>
      <td align="center">
      <small><a href="',$config['hostname'],$config['install_path'],'login.php"',
      '>',$str[96],'</a></small>
      </td>
   </tr>
</table>
</body>
</html>';

?>
