<?php

/* mailbox.php: main page that displays the message list for the selected mailbox 
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: mailbox.php,v 1.315 2004/04/30 04:33:53 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'mailbox');

/* Login to Hastymail */
if (isset($hm_input['login'])) {
    $imap_stream = hm_hastymail_login($hm_input, $config_file, $hasty_key);
    if (empty($_SESSION['settings'])) {
        $_SESSION['settings'] = $defaults;
    }
    $config = $_SESSION['config'];
    $str = $_SESSION['str'];
    if (isset($_SERVER['HTTP_USER_AGENT'])) {
        if (!isset($config['no_auto_simplify']) || 
            $config['no_auto_simplify'] != 'true') {
            if (hm_browser_type ($_SERVER['HTTP_USER_AGENT'])) {
                $_SESSION['auto_simplify'] = 'true';
            }
        }
        if (isset($config['enable_nn4_workarounds']) && 
            $config['enable_nn4_workarounds'] == 'true' &&
            substr($_SERVER['HTTP_USER_AGENT'], 0, 9) == 'Mozilla/4' &&
            !strstr($_SERVER['HTTP_USER_AGENT'], 'MSIE')) {
            $_SESSION['settings']['css_file'] = 'smokesky_nn4.css';
            $_SESSION['nn4_warning'] = true;
        }
    }
    
    /* get the folder list */
    $_SESSION['folders'] = hm_boxlist($imap_stream, true, 'all');

    if (!isset($_SESSION['settings']['new_mail_folders'])) {
        $_SESSION['settings']['new_mail_folders'] = array ('INBOX');
    }
    /* very first time we are logging in, check for autocreate folder
       settings */
    if (isset($_SESSION['first_login'])) {
        $_SESSION['settings'] = array_merge($_SESSION['settings'], $defaults);
        require_once('../lib/imap_3.php');
        hm_autocreate_folders($imap_stream, $config);
        hm_write_settings($_SESSION['user'], $config['settings_dir']); 
    }
    if (!isset($_SESSION['dsp_folders'])) {
        $_SESSION['dsp_folders'] = hm_folder_dsp($_SESSION['folders']);
    }

    /* redirect to non-standard start page */
    if (isset($_SESSION['settings']['start_page']) && 
        $_SESSION['settings']['start_page'] != '' &&
        $_SESSION['settings']['start_page'] != 'mailbox.php') {
        hm_imap_logout($imap_stream);
        header("Location: ".$_SESSION['config']['hostname'].
                $_SESSION['config']['install_path'].
                $_SESSION['settings']['start_page'].
                '?id='.session_id().'&amp;mailbox=INBOX');
        exit;
    }
    else {
        header("Location: ".$_SESSION['config']['hostname'].
                $_SESSION['config']['install_path'].'mailbox.php?id='.
                session_id().'&amp;mailbox=INBOX');
        exit;
    }
}
/* already logged in, so restart the session */
else {
    hm_session_continue($hm_input['id'], $config_file);
    $config = $_SESSION['config'];
    $str = $_SESSION['str'];
    if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config,
                                      $hasty_key, false, false)) {
        hm_logged_out($config_file); 
    }
}

/* check some values and setup some basic vars */

$config = $_SESSION['config'];
$hm_input['id'] = session_id();
$sort_types = $str['sort_types'];
if (isset($_SESSION['caps']) && !stristr($_SESSION['caps'], 'THREAD')) {
    $sort_types = array_slice($sort_types, 0, -2);
}

/* move to destination */ 
if (isset($_SESSION['move_to_destination'])) {
    $dest = $_SESSION['move_to_destination'];
}
else {
    $dest = 'INBOX';
}
if (isset($hm_input['move']) || isset($hm_input['copy'])) {
    $dest = $hm_input['destination'];
}
if (isset($hm_input['move2']) || isset($hm_input['copy2'])) {
    $dest = $hm_input['destination2'];
}
$_SESSION['move_to_destination'] = $dest;

/* check for simple option and set flag */
$simple = false;
if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 'true')
   || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 'true')) {
    $simple = true;
}

/* default page number */
if (!isset($hm_input['page_num'])) {
    $hm_input['page_num'] = 0;
}
/* if the lower set of controls were used */
if (isset($hm_input['submit_page2'])) {
    $hm_input['submit_page'] = $hm_input['submit_page2'];
    $hm_input['page'] = $hm_input['page2'];
}
/* check to see if we loaded this page from a prev/next button */
switch (true) {
    /* prev */
    case (isset($hm_input['prev']) && isset($hm_input['psubmit'])):
        $hm_input['page_num'] = $hm_input['prev'];
        break;
    /* next */
    case (isset($hm_input['next']) && isset($hm_input['nsubmit'])):
        $hm_input['page_num'] = $hm_input['next'];
        break;
    /* jump to page */
    case (isset($hm_input['submit_page'])): 
        $hm_input['page_num'] = $hm_input['page'];
        break;
    /* nada */
    default:
        break;
    }

/* if we are moving/copying/deleting/etc. messages */
$resort = false;
$large = false;
$sort = false;

if (!isset($hm_input['uid_string'])) {
    $uid_string = '';
}
else {
    $uid_string = $hm_input['uid_string'];
}
$action = false;
switch (true) {
    case isset($hm_input['purge']):
        $action = 'delete';
        $hm_input['selection_type'] = 'all';
        break;
    case isset($hm_input['move2']):
        $hm_input['selection_type'] = $hm_input['selection_type2'];
        $hm_input['destination'] = $hm_input['destination2'];
    case isset($hm_input['move']):
        $action = 'move';
        break;
    case isset($hm_input['sort2']):
        $hm_input['sort_type'] = $hm_input['sort_type2'];
    case isset($hm_input['sort']):
        $action = 'sort';
        break;
    case isset($hm_input['delete2']):
        $hm_input['selection_type'] = $hm_input['selection_type2'];
    case isset($hm_input['delete']):
        $action = 'delete';
        break;
    case isset($hm_input['read2']):
        $hm_input['selection_type'] = $hm_input['selection_type2'];
    case isset($hm_input['read']):
        $action = 'read';
        break;
    case isset($hm_input['unread2']):
        $hm_input['selection_type'] = $hm_input['selection_type2'];
    case isset($hm_input['unread']):
        $action = 'unread';
        break;
    case isset($hm_input['copy2']):
        $hm_input['selection_type'] = $hm_input['selection_type2'];
        $hm_input['destination'] = $hm_input['destination2'];
    case isset($hm_input['copy']):
        $action = 'copy';
        break;
    default:
        break;
}
/* process message action */
if ($action) {
    $tmp_box = hm_select_mailbox($imap_stream, $hm_input['mailbox']);
    if (isset($tmp_box) && $tmp_box != $hm_input['mailbox']) {
        $hm_input['mailbox'] = $tmp_box;
    }
    $resort = true;
    if (isset($hm_input['selection_type'])) {
        /* selected messages */
        if ($hm_input['selection_type'] == 'marked') {
            $dsp_count = 0;
            foreach($_POST as $index => $value) {
                if ($value == 'mark') {
                    $dsp_count++;
                    $uid_string .= $index.',';
                }
            }
        }
        /* one page of messages */
        elseif($hm_input['selection_type'] == 'page') {
            $dsp_count = count(split(",", $hm_input['page_string']));
            $uid_string = $hm_input['page_string'];
        }
        /* all messages */
        elseif($hm_input['selection_type'] == 'all') {
            $sort_tmp = $_SESSION['sort_data'][$hm_input['mailbox']];
            $dsp_count = count($sort_tmp[2]);
            if ($dsp_count > 1000) {
                $large = $hm_input['mailbox'];
            }
            $uid_string = implode(',', $sort_tmp[2]);
            unset($sort_tmp);
        }
    }
    elseif (isset($hm_input['uid_delete'])) {
        $dsp_count = 1;
        $uid_string = $hm_input['uid_delete'];
    }
    elseif (isset($hm_input['uid_move'])) {
        $dsp_count = 1;
        $uid_string = $hm_input['uid_move'];
    }
    if ($dsp_count > 1) {
        $dsp_end = $str[18];
    }
    else {
        $dsp_end = $str[26];
    }
    $srt = false;
    if (isset($hm_input['sort_type'])) {
        $srt = $hm_input['sort_type'];
    }
    if (!isset($hm_input['destination'])) {
        $hm_input['destination'] = '';
    }
    $sort = hm_message_controls ($action, $imap_stream, $uid_string, 
                                   $hm_input['destination'], $large, $srt, 
                                   urldecode($hm_input['mailbox']), $dsp_count, $dsp_end);
}

/* update counts and check the cache */
$unseen = hm_unseen_status ($imap_stream, $_SESSION['folders']);
$tmp_box = hm_select_mailbox($imap_stream, $hm_input['mailbox']);
if (isset($tmp_box) && $tmp_box != $hm_input['mailbox']) {
    $hm_input['mailbox'] = $tmp_box;
}
$cache = hm_check_cache($hm_input['mailbox']);

/* get the sort information for this mailbox/page */
if ($sort) {
    $_SESSION['settings']['sort'][$hm_input['mailbox']] = $sort;
}
if (isset($_SESSION['settings']['sort']) 
          && array_key_exists($hm_input['mailbox'], $_SESSION['settings']['sort'])) {
    $sort = $_SESSION['settings']['sort'][$hm_input['mailbox']];
} 
else {
    $sort = 'ARRIVAL';
}
if ($cache && !$resort) {
    $sort_info = $_SESSION['sort_data'][$hm_input['mailbox']];
}
else {
    if (isset($_SESSION['thread_data'][$hm_input['mailbox']])) {
        unset($_SESSION['thread_data'][$hm_input['mailbox']]);
    }
    $sort_info = &hmw_get_sort_info($imap_stream, $sort, $hm_input['mailbox']);
}

/* check for missing folders */
hm_check_folders($imap_stream);

/* toolbar and any status messages */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, 
           urldecode($hm_input['mailbox']));

/* create the contols for the top of the message table */
echo '<form action="mailbox.php" method="post">',"\n";
if (is_array($sort_info) && !empty($sort_info)) {
    if (!array_key_exists($hm_input['page_num'], $sort_info[1])) {
        $hm_input['page_num'] = 0;
    }
    $dsp_folders = $_SESSION['dsp_folders'];
if (!$simple) {
    echo '
<table width="99%" align="center" cellpadding="2" cellspacing="4" class="tables5">
   <tr>
      <td>
      <table width="99%" align="center" cellpadding="1" cellspacing="6" class="tables5">
         <tr>
            <td class="tables2" width="15%" nowrap>
            &nbsp;&nbsp;&nbsp;<b>';
    if (isset($config['utf7_decode'])) {
        echo utf8_encode(imap_utf7_decode($dsp_folders[urldecode($hm_input['mailbox'])]));
    }
    else {
        echo $dsp_folders[urldecode($hm_input['mailbox'])];
    }
    echo '</b>
            &nbsp;&nbsp;
            </td>
            <td class="tables2" nowrap>
             &nbsp;&nbsp;',"\n";
}

/* previous page button */
if ($hm_input['page_num'] > 0) {
    echo '            <input type=submit name="psubmit" ',
                              "class=\"button1\" value=\"&lt;&lt;&lt;\">\n";
    $hm_input['prev'] = $hm_input['page_num'] - 1;
    echo '            <input type="hidden" name="prev" value="',$hm_input['prev'],'">
            <input type="hidden" name="id" value="',$hm_input['id'],'">
            <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">',"\n";
}
elseif (!$simple) {
    echo '            <input type="button" disabled="disabled" ',
                             "value=\"&lt;&lt;&lt;\" class=\"button2\">\n";
}

/* page button */
echo '            <input type="submit" name="submit_page" value="',$str[9],
         '" class="button1">
            <select name="page">',"\n";
foreach ($sort_info[1] as $index => $array) {
    echo "              <option value=\"$index\" ";
    if ($index == $hm_input['page_num']) {
        echo 'SELECTED';
    }
    echo " >",($index+1),"</option>\n";
}
echo "            </select>\n";

/* next page button */
if ($sort_info[0] > $sort_info[1][$hm_input['page_num']][1]) { 
    $next = $hm_input['page_num'] + 1;
    echo '            <input type="submit" name="nsubmit" class="button1" ',
             'value="&gt;&gt;&gt;">
            <input type="hidden" name="next" value="',$next,'">
            <input type="hidden" name="id" value="',$hm_input['id'],'">
            <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],"\">\n";
}
elseif (!$simple) {
    echo '            &nbsp;<input type="button" disabled="disabled" ',
                             "value=\"&gt;&gt;&gt;\" class=\"button2\">\n";
}

/* sort controls */
if (!$simple) {
    echo '            </td>
            <td class="tables2" width="15%" align="right" nowrap>',"\n";
}
else {
    echo '<br>';
}
echo '            <input type="submit" class="button1" name="sort" value="',$str[17],'">
            <select name="sort_type">',"\n";
if (isset($_SESSION['config']['client_sort']) && 
          $_SESSION['config']['client_sort'] == 'true') {
    $sort_types = $str['client_sort_types'];
}
foreach ($sort_types as $key => $value) {
    echo '               <option ';
    if ($sort == $key) {
        echo ' SELECTED ';
    }    
    echo "value=\"$key\">$value</option>\n";
}
echo '            </select>&nbsp;',"\n";

/* get the message headers */
$headers = hm_get_messages (implode(',', $sort_info[1][$hm_input['page_num']][2]), 
                                $imap_stream);
    
/* main mailbox display */
$count = count($headers);
$t_all = false;
if (isset($hm_input['toggle_all'])) {
    $t_all = true;
}
$sort_page = $sort_info[1][$hm_input['page_num']][2];
echo '            <input type="hidden" name="id" value="',$hm_input['id'],'">
            <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">
            <input type="hidden" name="page_string" value="', implode(',', $sort_page),'">
            <input type="hidden" name="page_num" value="',$hm_input['page_num'],'">',"\n";
if (!$simple) {
    echo '            </td>
         </tr>
      </table>
      </td>
   </tr>
   <tr>
      <td>
      <table width="99%" align="center" cellpadding="1" cellspacing="0" class="tables2">
         <tr>
            <td colspan="7" class="tables1">
            <table width="99%" class="tables1" align="center" cellpadding="4" ',
            'cellspacing="0">
               <tr>
                  <td nowrap>';
}
echo '
                  &nbsp;&nbsp;<small>',$sort_info[0],' ',$str[18],
        ' &nbsp;&nbsp;',$str[19],' ',$sort_info[1][$hm_input['page_num']][0],' - ', 
        $sort_info[1][$hm_input['page_num']][1],"</small>\n";
if (!$simple) {
    echo '                  </td>',"\n";
    if (isset($_SESSION['settings']['trash_folder']) &&
        $_SESSION['settings']['trash_folder'] == urldecode($hm_input['mailbox'])) {
        echo '                 <td align="right" nowrap>
                 <input type="submit" value="',$str[20],'" class="button3" name="purge">
                 </td>',"\n";
    }
    echo '                 <td align="right" nowrap>',"\n";
}
else {
    echo '<br>';
}
echo '                  <input class="button3" type="submit" name="toggle_all" ', 
         'value="',$str[246],'">&nbsp;&nbsp;
                      <select name="selection_type" class="select3">
                      <option class="option3" value="marked">',$str[6],'</option>
                      <option class="option3" value="page">',$str[7],'</option>
                      <option class="option3" value="all">',$str[8],'</option>
                  </select>&nbsp;
                  <input type="submit" class="button3" name="read" value="',$str[2],'">
                  <input type="submit" class="button3" name="unread" value="',$str[3],'">
                  <input type="submit" class="button3" name="delete" value="',$str[4],'">
                  &nbsp;<input type="submit" class="button3" name="copy" value="',$str[1],'">-<input type="submit" class="button3" name="move" value="',$str[0],'">-&gt;
                  <select class="select3" name="destination">',"\n";
hm_folder_options($dest, false, $simple, false, 'class="option3"');
echo '                  </select>',"\n";
if (!$simple) {
    echo '                  </td>
               </tr>
            </table>
            </td>
         </tr>
         <tr class="tables2">'."\n";
    hm_start_message_listing($hm_input['mailbox']);
    echo '
         </tr>',"\n";
    if (isset($_SESSION['nn4_warning'])) {
        echo '<tr><td></td><td></td><td class="tables5">
              <img src="../images/trans.gif" height="1" width="350"></td></tr>';
    }
}
else {
    echo '<br><table>';
}

/* loop through the messages */
for ($i=0;$i<$count;$i++) {
    $current = false;
    if (isset($hm_input['uid']) && $hm_input['uid'] == $sort_page[$i]) {
        $current = true;
    }
    hm_print_row($headers[$sort_page[$i]], $simple, $t_all, $hm_input['mailbox'],
                 $hm_input['id'], $sort_page[$i], $sort_info, true, false, false,
                 false, $current, array(), $i);
}
if (!$simple) {
    /* message controls */   
    if ($count >= 15) {
   echo '         <tr>
            <td colspan="7" class="tables1">
            <table width="99%" class="tables1" align="center" cellpadding="4" cellspacing="0">
               <tr>
                  <td nowrap>
                  &nbsp;&nbsp;<small>',$sort_info[0],' ',$str[18],
        ' &nbsp;&nbsp;',$str[19],' ',$sort_info[1][$hm_input['page_num']][0],' - ', 
        $sort_info[1][$hm_input['page_num']][1],'</small>
                  </td>',"\n";
    if (isset($_SESSION['settings']['trash_folder']) &&
        $_SESSION['settings']['trash_folder'] == $hm_input['mailbox']) {
        echo '                 <td align="right" nowrap>
                  <input type="submit" value="',$str[20],'" class="button3" name="purge">
                  </td>';
    }
    echo '                  <td align="right" nowrap>
                  <input class="button3" type="submit" name="toggle_all" ', 
         'value="',$str[246],'">&nbsp;&nbsp;
                  <select name="selection_type2" class="select3">
                     <option class="option3" value="marked">',$str[6],'</option>
                     <option class="option3" value="page">',$str[7],'</option>
                     <option class="option3" value="all">',$str[8],'</option>
                  </select>&nbsp;
                  <input type="submit" class="button3" name="read2" value="',$str[2],'">
                  <input type="submit" class="button3" name="unread2" value="',$str[3],'">
                  <input type="submit" class="button3" name="delete2" value="',$str[4],'">
                  &nbsp;<input type="submit" class="button3" name="copy2" value="',$str[1],'">-<input type="submit" class="button3" name="move2" value="',$str[0],'">-&gt;
                  <select class="select3" name="destination2">';
    hm_folder_options($dest, false, $simple, false, 'class="option3"');
    echo '                   </select>
                  </td>
               </tr>
            </table>
            </td>
         </tr>',"\n";
    }
    echo '      </table>
      </td>
   </tr>
   <tr>
      <td>
      <table width="99%" align="center" cellpadding="1" cellspacing="6" class="tables5">
         <tr>
            <td class="tables2" nowrap width="15%">
            &nbsp;&nbsp;<b>';
    if (isset($config['utf7_decode'])) {
        echo utf8_encode(imap_utf7_decode($dsp_folders[urldecode($hm_input['mailbox'])]));
    }
    else {
        echo $dsp_folders[urldecode($hm_input['mailbox'])];
    }
    echo '</b>
            </td>
            <td class="tables2">
            &nbsp;&nbsp;',"\n";
    if ($hm_input['page_num'] > 0) {
        echo '            <input type=submit name="psubmit" ',
                              "class=\"button1\" value=\"&lt;&lt;&lt;\">\n";
        $hm_input['prev'] = $hm_input['page_num'] - 1;
        echo '            <input type="hidden" name="prev" value="',$hm_input['prev'],'">
            <input type="hidden" name="id" value="',$hm_input['id'],'">
            <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">',"\n";
    }
    else {
        echo '            <input type="button" disabled="disabled" ',
                             "value=\"&lt;&lt;&lt;\" class=\"button2\">\n";
    }
    echo '            <input type="submit" name="submit_page2" value="',$str[9],
        '" class="button1">
            <select name="page2">',"\n";
    foreach ($sort_info[1] as $index => $array) {
        echo "              <option value=\"$index\" ";
        if ($index == $hm_input['page_num']) {
            echo 'SELECTED';
        }
        echo " >",($index+1),"</option>\n";
    }
    echo "            </select>\n";
    if ($sort_info[0] > $sort_info[1][$hm_input['page_num']][1]) { 
        $next = $hm_input['page_num'] + 1;
        echo '            <input type="submit" name="nsubmit" class="button1" ',
             'value="&gt;&gt;&gt;">',"\n";
    }
    else {
        echo '            &nbsp;<input type="button" disabled="disabled" ',
                             "value=\"&gt;&gt;&gt;\" class=\"button2\">\n";
    }
    echo '            </td>
            <td align="right" width="15%" class="tables2" nowrap>
            <input type="submit" class="button1" name="sort2" value="',$str[17],'">
            <select name="sort_type2">',"\n";
    if (isset($_SESSION['config']['client_sort']) && 
              $_SESSION['config']['client_sort'] == 'true') {
        $sort_types = $str['client_sort_types'];
    }
    foreach ($sort_types as $key => $value) {
        echo '               <option ';
        if ($sort == $key) {
            echo ' SELECTED ';
        }    
        echo "value=\"$key\">$value</option>\n";
    }
    echo '            </select>&nbsp;
            </td>
         </tr>';
    }
    else {
        echo '</table>';
    }
}
else {
    if (!$simple) {
        echo '<br>
<table align="center" class="tables4">
   <tr>
      <td height="20%" align="center">
      &nbsp;&nbsp;&nbsp;<b>';
    if (isset($config['utf7_decode'])) {
        echo utf8_encode(imap_utf7_decode(urldecode($hm_input['mailbox'])));
    }
    else {
        echo urldecode($hm_input['mailbox']);
    }
    echo ' </b> ',$str[54],'&nbsp;&nbsp;&nbsp;
      </td>
   </tr>',"\n";
    }
    else {
	    if (isset($config['utf7_decode'])) {
	        echo utf8_encode(imap_utf7_decode(urldecode($hm_input['mailbox'])));
        }
        else {
            echo urldecode($hm_input['mailbox']),' is empty';
        }
    }
}
if (!$simple) {
echo '
      </table>
      </td>
   </tr>
</table>',"\n";
}
echo '</form>
</body>
</html>';

/* close imap connection */
hm_imap_logout ($imap_stream);

?>
