<?php

/* message.php: Page for reading messages 
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: message.php,v 1.342 2004/04/22 04:57:27 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'message');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file)) {
    $config = $_SESSION['config'];
}

/* some basic init stuff */
$hm_input['id'] = session_id();
$str = $_SESSION['str'];

if (isset($hm_input['destination'])) {
    $dest = $hm_input['destination'];
}
elseif (isset($_SESSION['move_to_destination'])) {
    $dest = $_SESSION['move_to_destination'];
}
else {
    $dest = 'INBOX';
}
$_SESSION['move_to_destination'] = $dest;

/* check for full header viewing status */
if (isset($hm_input['full']) && $hm_input['full'] == 'yes') {
    $hm_input['full'] = true;
    $_SESSION['full'] = 'yes';
}
elseif (isset($hm_input['full']) && $hm_input['full'] == 'no') {
    $hm_input['full'] = false;
    $_SESSION['full'] = false;
    unset($_SESSION['full']);
}
elseif (isset($_SESSION['full']) && $_SESSION['full'] == 'yes') {
    $hm_input['full'] = true;    
}
else {
    $hm_input['full'] = false;
}

/* hidden folder view setting */
if (isset($hm_input['hide_folder_preview'])) {
    if ($hm_input['hide_folder_preview'] == 1) {
        $preview_hide = true;
    }
    else {
        $preview_hide = false;
    }
}
else {
    if (isset($_SESSION['hide_folder_preview']) &&
        $_SESSION['hide_folder_preview'] == 1) {
        $preview_hide = true;
    }
    else {
        $preview_hide = false;
    }
}
$_SESSION['hide_folder_preview'] = $preview_hide;
if (isset($_SESSION['settings']['preview_position']) &&
    $_SESSION['settings']['preview_position'] == 1) {
    $preview_pos = 'bottom';
}
else {
    $preview_pos = 'top';
}

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config,
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* check for simple option and set flag */
$simple = false;
if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 'true')
   || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 'true')) {
    $simple = true;
}

/* get unseen info */
$unseen = hm_unseen_status ($imap_stream, $_SESSION['folders']);

/* adjust new message count */
if (isset($hm_input['new']) && $hm_input['new'] == 1) {
    if (isset($unseen[urldecode($hm_input['mailbox'])])) {
        if ($unseen[urldecode($hm_input['mailbox'])] > 0) {
            $unseen[urldecode($hm_input['mailbox'])] -= 1;
        }
    }
}

/* search for message response */
if (isset($hm_input['find_response'])) {
    if (isset($_SESSION['settings']['sent_folder'])) {
        hm_select_mailbox($imap_stream, $_SESSION['settings']['sent_folder']);
        $search = 'SEARCH HEADER in-reply-to '.
        str_replace(array('&gt;', '&lt;'), '', $hm_input['find_response']);
        $res = hm_search_mailbox($imap_stream, $search, false);
        if (strstr($res, ' ')) {
            $res = trim(substr($res, 0, strpos($res, ' ')));
        }
        else {
            $res = trim($res);
        }
        if (is_numeric($res)) {
            $hm_input['mailbox'] = $_SESSION['settings']['sent_folder'];
            $hm_input['uid'] = $res;
        }
        else {
            $_SESSION['notices'][] = $str[254];
        }
    }
}

/* select the mailbox for imap */
hm_select_mailbox($imap_stream, $hm_input['mailbox']);

/* check if we can use the cache */
$cache = hm_check_cache($hm_input['mailbox']);

/* get sort information */
if (!isset($hm_input['page_num'])) {
    $hm_input['page_num'] = '0';
}
if (isset($_SESSION['settings']['sort']) 
          && array_key_exists($hm_input['mailbox'], $_SESSION['settings']['sort'])) {
    $sort = $_SESSION['settings']['sort'][$hm_input['mailbox']];
} 
else {
    $sort = 'ARRIVAL';
}
if ($cache && isset($_SESSION['sort_data'][$hm_input['mailbox']])) {
    $sort_info = $_SESSION['sort_data'][$hm_input['mailbox']];
}
else {
    $sort_info = &hmw_get_sort_info($imap_stream, $sort, $hm_input['mailbox']);
}

/* process move and delete actions */
$action = false;
switch (true) {
    case isset($hm_input['move']):
        $action = 'move';
        break;
    case isset($hm_input['sort']):
        $action = 'sort';
        break;
    case isset($hm_input['delete']):
        $action = 'delete';
        break;
    case isset($hm_input['read']):
        $action = 'read';
        break;
    case isset($hm_input['unread']):
        $action = 'unread';
        break;
    case isset($hm_input['copy']):
        $action = 'copy';
        break;
    default:
        break;
}

if ($action) {
    $dest = false;
    $action_uid = false;
    if (isset($hm_input['destination'])) {
        $dest = $hm_input['destination'];
    }
    if ($action == 'delete') {
        $action_uid = $hm_input['uid_delete'];
    }
    elseif ($action == 'move') {
        $action_uid = $hm_input['uid_move'];
    }
    if ($action_uid) {
    $result = hm_message_controls($action, $imap_stream,
              $action_uid, $dest, false, false, $hm_input['mailbox'], 
              1, $str[26]);
    }   
    if (isset($_SESSION['thread_data'][$hm_input['mailbox']])) {
        unset($_SESSION['thread_data'][$hm_input['mailbox']]);
    }
    $sort_info = &hmw_get_sort_info($imap_stream, $sort, $hm_input['mailbox']);
}

/* bail if the message is gone */
if (!in_array($hm_input['uid'], $sort_info[2])) {
    if ($cache) {
        $sort_info = &hmw_get_sort_info($imap_stream, $sort, $hm_input['mailbox']);
    }
    if (!in_array($hm_input['uid'], $sort_info[2])) {
        $_SESSION['notices'][] = $str[256];
        if (isset($hm_input['search']) && $hm_input['search'] == 1) {
            $_SESSION['notices'][] = $str[216].'<br>'.$str[217];
            header("Location: ".$config['hostname'].$config['install_path'].
                "search.php?id=".$hm_input['id']."&mailbox=".$hm_input['mailbox']);
            exit;
        }
        else {
            $_SESSION['notices'][] = $str[218];
            header("Location: ".$config['hostname'].$config['install_path'].
                "mailbox.php?id=".$hm_input['id']."&mailbox=".$hm_input['mailbox']);
            exit;
        }
    }
}

/* get message structure */
$structure = hm_get_struct($imap_stream, $hm_input['uid']);

/* blah, html default option! */
if (!isset($hm_input['part']) && isset($_SESSION['settings']['html_default']) &&
    $_SESSION['settings']['html_default'] == 'true') {
    foreach ($structure as $index => $array) {
        if (isset($array['subtype']) && $array['subtype'] == 'html') {
            $hm_input['part'] = $index;
            break;
        }
    }
}

/* check for drafts */
$draft = false;
if (isset($_SESSION['settings']['drafts_folder']) && urldecode($hm_input['mailbox']) ==
    $_SESSION['settings']['drafts_folder']) {
    $tmp = &hm_get_messages($hm_input['uid'], $imap_stream);
    $flags = $tmp[$hm_input['uid']][5];
    if (stristr($flags, 'draft')) {
        $draft = true;
    }
}

/* check for full message display on LARGE message parts */
$_SESSION['cutoff'] = 0;
unset($_SESSION['cutoff']);
if (isset($hm_input['big_text'])) {
    $cutoff = false;
    $pview_tag = '&amp;big_text=true';
}
else {
    $cutoff = true;
    $pview_tag = '';
}

/* default is to search for a part, otherwise get the requested part */
if (!isset($hm_input['part'])) {
    $results = &hm_find_display_part($imap_stream, $structure, $hm_input['uid'], false,
                                    false, false, $cutoff);
    $hm_input['top_level'] = $results[0];
    if ($results[1] == "\n\n     ".$str[194]."\n\n" && 
        $structure[1]['type'].$structure[1]['subtype'] == 'texthtml' &&
        isset($_SESSION['settings']['html_only']) &&
        $_SESSION['settings']['html_only'] == 'true') {
        $results = &hm_find_display_part($imap_stream, $structure, $hm_input['uid'], 1,
                                        false, false, $cutoff);
    }
}
else {
    $results = &hm_find_display_part($imap_stream, $structure, $hm_input['uid'], 
                                    $hm_input['part'], false, false, $cutoff);
    $hm_input['top_level'] = 1;
}

/* get the message attributes */
$hm_input['part']= $results[0];
$text_part = $results[1];
$decode = $results[2][0];
$type = $results[2][1];
$subtype = $results[2][2];
$dsp_type = $results[2][3];
if (isset($results[2][5]) && $results[2][5]) {
    $name = $results[2][5];
}
if ($subtype == 'html') {
    $html_flag = '&amp;html_part=true';
    $hm_input['top_level'] = $hm_input['part'];
}
else {
    $html_flag = '';
}
/* setup charset mechanism */
$code_page = false;
$charset_convert = false;
$charset = false;
$utf = false;
if (isset($results[2][4]) && $results[2][4] && $str['charset'] == 'UTF-8') {
    $charset = strtolower($results[2][4]);
    if (isset($_SESSION['charsets'][$charset])) {
        $code_page = $_SESSION['charsets'][$charset];
        $charset_convert = true;
    }
}
if ($charset == 'utf-8') {
    $utf = true;
}

/* get message headers */
$message_headers = hm_get_full_header($imap_stream, $hm_input['uid'], false);
$subject = $str[229];
if (isset($message_headers['subject']) && $message_headers['subject'] != '') {
    $subject = $message_headers['subject'];
}
$date = $str[231];
if (isset($_SESSION['settings']['date_string'])) {
    $date_string = $_SESSION['settings']['date_string'];
}
else {
    $date_string = 'g:i a, F j, Y';
}
if (isset($message_headers['date']) && $message_headers['date'] != '') {
    $date = date($date_string, (strtotime($message_headers['date'])));
}
$from = $str[230];
if (isset($message_headers['from']) && $message_headers['from'] != '') {
    $from = stripslashes($message_headers['from']);
}
$to = $str[232];
if (isset($message_headers['to']) && $message_headers['to'] != '') {
    $to = $message_headers['to'];
}
$cc = false;
if (isset($message_headers['cc']) && $message_headers['cc'] != '') {
    $cc = $message_headers['cc'];
}
/*$xmailer = false;
if (isset($message_headers['x-mailer']) && $message_headers['x-mailer'] != '') {
    $xmailer = $message_headers['x-mailer'];
}
elseif (isset($message_headers['user-agent']) && $message_headers['user-agent'] != '') {
    $xmailer = $message_headers['user-agent'];
}
*/
/* check for mailing list header */
$message_list_reply = false;
if (isset($message_headers['list-post'])) {
    if (preg_match("/&lt;mailto:(.+)&gt;/i", $message_headers['list-post'], $matches)) {
        $message_list_reply = true;
        $message_list_reply_to = $matches[1]; 
    }
}
elseif (isset($message_headers['x-list-post'])) {
    if (preg_match("/&lt;mailto:(.+)&gt;/i", $message_headers['x-list-post'], $matches)) {
        $message_list_reply = true;
        $message_list_reply_to = $matches[1]; 
    }
}
elseif (isset($message_headers['x-mailing-list'])) {
    if (preg_match("/([^\s]+@[^\s]+)/i", $message_headers['x-mailing-list'], $matches)) {
        $message_list_reply = true;
        if (isset($matches[1])) {
            $message_list_reply_to = $matches[1]; 
        }
        else {
            $message_list_reply_to = '';
        }
    }
}

/* message display */
list($hm_input['page_num'], $message_dsp_header) =
          hm_message_header ($sort_info, $hm_input['mailbox'], $imap_stream,
                                         $hm_input['page_num'], $hm_input['id'], 
                                         $hm_input['uid'], $_SESSION['dsp_folders'], 
                                         $simple);


/* reply and bounce notices */
if (isset($hm_input['reply_notice'])) {
    hm_imap_action($imap_stream, $hm_input['uid'], 'ANSWERED');
    $_SESSION['notices'][] = $str[42];
}
elseif (isset($hm_input['bounce_notice'])) {
    if ($hm_input['bounce_notice'] == 'yes') {
        $_SESSION['notices'][] =  $str[223];
    }
    else {
        $_SESSION['notices'][] =  $str[224];
    }
}

/* check for missing folders */
hm_check_folders($imap_stream);

/* toolbar and any status messages */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, $str[26], false, 
           $hm_input['uid']);

/* main message display */
if ($simple) {
    echo $message_dsp_header,'<br>';
}
else {
    echo '<table width="95%" align="center" cellpadding="4" cellspacing="4"',
         ' class="tables5">
   <tr>
      <td align="center" colspan="3">
      <table width="100%" cellpadding="6" cellspacing="4">
         <tr>',"\n",$message_dsp_header;

    /* prev/next/back links for search results */
    if (isset($hm_input['search']) && $hm_input['search'] == 1) {
        echo hm_create_next_previous ($imap_stream, $_SESSION['search_info'],
                                      $hm_input['mailbox'], array ('&lt;&lt;&lt;',
                                      $str[257], '&gt;&gt;&gt;', '<small>', '</small>'), 
                                      $hm_input['uid'], $hm_input['id'], true, 
                                      '&amp;search=1', 'search.php', '', false, false,
                                      '', false, $simple);
    }

    /* prev/next/back links for thread results */
    elseif (isset($hm_input['thread']) && $hm_input['thread'] == 1) {
        echo hm_create_next_previous ($imap_stream, $_SESSION['thread_data'],
                                      $hm_input['mailbox'], array ('&lt;&lt;&lt;',
                                      $str[221], '&gt;&gt;&gt;', '<small>', '</small>'), 
                                      $hm_input['uid'], $hm_input['id'], false, 
                                      '&amp;thread=1', 'thread_view.php', '', true,
                                      false, '', false, $simple);
    }
}

/* prev/next/delete links */
$del_range = array();
if (isset($_SESSION['prev_flag'])) {
    $del_range[] = $_SESSION['prev_flag'];
}
$del_range[] = $hm_input['uid'];
if (isset($_SESSION['next_flag'])) {
    $del_range[] = $_SESSION['next_flag'];
}
echo hm_create_next_previous ($imap_stream, $del_range, $hm_input['mailbox'], 
                              array ('&lt;&lt;&lt;', $str[4], '&gt;&gt;&gt;', '',
                              ''), $hm_input['uid'], $hm_input['id'], false, 
                              '&amp;uid_delete='.$hm_input['uid'].
                              '&amp;delete=1', 'mailbox.php',
                              '&amp;uid_delete='.$hm_input['uid'].'&amp;page_num='.
                              $hm_input['page_num'].'&amp;delete=1', false, 
                              false, 'width="10%"', true, $simple);

if ($simple) {
    echo '&nbsp;&nbsp;&nbsp;<br>';
}
else {
    echo '         </tr>
      </table>',"\n";
    /* folder preview option */
    if (isset($_SESSION['settings']['folder_preview']) &&
        $_SESSION['settings']['folder_preview'] != 'none' &&
        $preview_pos == 'top') {
        if (!$preview_hide) {
            if (isset($hm_input['scroll_uid'])) {
                $scroll_uid = $hm_input['scroll_uid'];
            }
            else {
                $scroll_uid = $hm_input['uid'];
            }
            hm_folder_preview($imap_stream, $scroll_uid, $sort_info, $hm_input['id'],
                              $hm_input['mailbox'], $hm_input['uid']);
        }
    }
    echo '      </td>
   </tr>
   <tr>',"\n";
    /* full/small header links */
    echo '      <td class="tables4" nowrap colspan="2">',"\n";
}
if ($hm_input['full']) {
    echo '      &nbsp;<a class="font2" href="message.php?',
       'uid=',$hm_input['uid'],'&amp;id=',$hm_input['id'],
       '&amp;mailbox=',urlencode($hm_input['mailbox']),'&amp;part=',$hm_input['part'],
       '&amp;full=no&amp;page_num=',$hm_input['page_num'],'">
      ',$str[30],'</a> &nbsp;&nbsp;&nbsp;',"\n";
}
else {
    echo '      &nbsp;<a class="font2" href="message.php?',
       'uid=',$hm_input['uid'],'&amp;id=',$hm_input['id'],'&amp;mailbox=',
       urlencode($hm_input['mailbox']),'&amp;part=',$hm_input['part'],
       '&amp;full=yes','&amp;page_num=',$hm_input['page_num'],'">
      ',$str[29],'</a> &nbsp;&nbsp;&nbsp;',"\n";
}
if ($simple) {
    echo '<br>';
}
if (!$simple) {
    /* raw/normal message links */
    if (isset($hm_input['raw']) && $hm_input['raw'] == 1) {
        echo '      <a class="font2" href="message.php?id=',$hm_input['id'],
       '&amp;part=1&amp;uid=',$hm_input['uid'],'&amp;mailbox=',
       urlencode($hm_input['mailbox']),'">
      ',$str[32],'</a> &nbsp;&nbsp;&nbsp;',"\n";
    }
    else {    
        echo '      <a class="font2" href="message.php?id=',$hm_input['id'],
       '&amp;raw=1&amp;part=1&amp;uid=',$hm_input['uid'],'&amp;mailbox=',
       urlencode($hm_input['mailbox']),'">
      ',$str[31],'</a> &nbsp;&nbsp;&nbsp;',"\n";
    }

    /* thread view */
    if ((isset($_SESSION['config']['client_sort']) && $_SESSION['config']['client_sort']
        == 'false') || !isset($_SESSION['config']['client_sort'])) {
        if (isset($_SESSION['caps']) && stristr($_SESSION['caps'], 'THREAD')) {
            echo '      <a class="font2" href="thread_view.php?id=',$hm_input['id'],
       '&amp;uid=',$hm_input['uid'],'&amp;mailbox=',urlencode($hm_input['mailbox']),'">
      ',$str[33],'</a> &nbsp;&nbsp;&nbsp;';
        }
    }

    /* print view */
    if (isset($hm_input['part_full']) && $hm_input['part_full'] == 'yes') {
        $print_part_full = '&amp;print_part_full=true';
    }
    else {
        $print_part_full = '';
    }

    if (isset($hm_input['full']) && $hm_input['full'] == 'yes') {
        $print_full = '&amp;print_full=true';
    }
    else {
        $print_full = '';
    }
    echo '      <a class="font2" href="print_view.php?id=',$hm_input['id'],
       '&amp;part=',$hm_input['part'],'&amp;uid=',$hm_input['uid'],
       '&amp;mailbox=',urlencode($hm_input['mailbox']),$pview_tag,$print_part_full,
       $print_full,'">
      ',$str[34],"</a> &nbsp;&nbsp;\n";

    /* folder view link */
    if ($preview_hide) {
        echo '<a class="font2" href="message.php?id=',urlencode($hm_input['id']),
             '&amp;uid=',$hm_input['uid'],'&amp;mailbox=',$hm_input['mailbox'],
             '&amp;hide_folder_preview=0">Folder view</a>&nbsp;&nbsp;';
    }
    echo '      </td>
      <td align="center" class="tables2" nowrap width="10%">',"\n";

    /* form for moving messages */
    if (isset($_SESSION['next_flag'])) {
        $form_action = 'message.php';
    }
    else {
        $form_action = 'mailbox.php';
    }
    echo '
      <form action="',$form_action,'" method="post">
      <input type=submit name="move" class="button3" value="',$str[0],'">-&gt;
      <input type="hidden" name="id" value="',$hm_input['id'],'">
      <input type="hidden" name="mailbox" value="',
      urldecode($hm_input['mailbox']),'">
      <input type="hidden" name="uid_move" value="',$hm_input['uid'],'">
      <select class="select3" name="destination">',"\n";
    hm_folder_options($_SESSION['move_to_destination'], false, $simple, false, 
                      'class="option3"');
    echo "      </select>&nbsp;\n";
    if (isset($_SESSION['next_flag'])) {
        echo '      <input type="hidden" name="uid" value="',$_SESSION['next_flag'],
             "\">\n";
    }
    echo '      </form>
      </td>
   </tr>
   <tr>
      <td class="tables4" colspan="3">
      <table width="100%" cellpadding="1" cellspacing="1">
          <tr>',"\n";

}

/* full headers */
if ($hm_input['full'] && !isset($hm_input['raw'])) {
    if (!$simple) {
        echo '
            <td width="100%">
            <table cellpadding="1" cellspacing="0">',"\n";
        foreach ($message_headers as $name => $val) {
            echo '               <tr>
                  <td align="right">
                  <small><b>',preg_replace("/_\d*$/", '', $name),':</b></small>
                  </td> 
                  <td valign="top">
                  &nbsp;<small>',$val,'</small>
                  </td> 
               </tr>',"\n";
        }
        echo '
            </table>
            </td>
         </tr>';
    }
    else {
        echo "            <small>\n";
        foreach ($message_headers as $name => $val) {
            echo preg_replace("/_\d+/", '', $name).':&nbsp;'.$val.'<br>';
        }
        echo "    </small>";
    }
}

/* small headers */
elseif (!isset($hm_input['raw'])) {
    if (!$simple) {
        echo '            <td>
            <table cellpadding="0" cellspacing="0">
               <tr class="tables4">
                  <td valign="top">
                  <font class="font2">',$str[21],':&nbsp;&nbsp;</font>
                  </td>
                  <td valign="top">
                  ',$subject,'
                  </td>
               </tr>
               <tr class="tables4">
                  <td valign="top">
                  <font class="font2">',$str[22],':</font>
                  </td>
                  <td valign="top">
                  ',$from,'
                  </td>
               </tr>
               <tr class="tables4">
                  <td valign="top">
                  <font class="font2">',$str[23],':</font>
                  </td>
                  <td valign="top">
                  ',hm_special_chars($date, $str['charset'], $charset_convert, 
                                     $code_page, $utf),'
                  </td>
               </tr>
               <tr class="tables4">
                  <td valign="top">
                  <font class="font2">',$str[25],':</font>
                  </td>
                  <td valign="top">',"\n";
    }
    else {
        echo $str[21],': ',$subject,
             '<br>',$str[22],': ',
             $from,'<br>',$str[23],': ',
             hm_special_chars($date, $str['charset'], $charset_convert, $code_page,
                              $utf),'<br>',
             $str[25],': ';
    }
    if (strlen($to) > 200) {
        echo '                   ',substr($to, 0, 200 + strpos(substr($to, 200), ',')),
             "...\n";
    }
    else {
        echo '                   ',$to,
             "\n";
    }
    if (!$simple) {
        echo '                  </td>
               </tr>',"\n";
    }
    if ($cc) {
        if (!$simple) {
            echo '               <tr class="tables4">
                  <td valign="top">
                  <font class="font2">',$str[87],':</font>
                  </td>
                  <td valign="top">',"\n";
        }
        if (strlen($cc) > 200) {
            echo '                   ',substr($cc, 0, 200 + strpos(substr($cc, 200), 
                 ',')), "...\n";
        }
        else {
            echo '                   ',$cc,
                 "\n";
        }
        if (!$simple) {
            echo '                  </td>
               </tr>',"\n";
        }
    }
    /*if ($xmailer) {
        if (!$simple) {
            echo '               <tr>
                  <td valign="top">
                  <b>Client:</b>
                  </td>
                  <td valign="top">',"\n";
        }
        echo '                   ',$xmailer,
                 "\n";
        if (!$simple) {
            echo '                  </td>
               </tr>',"\n";
        }
    }*/
    if (!$simple) {
        echo '            </table>
            </td>
         </tr>',"\n";
    }
}
if (!$simple && !isset($hm_input['raw'])) {
    echo '       </table>
       </td>
   </tr>
   <tr>',"\n";
}
elseif (!isset($hm_input['raw'])) {
    echo '<br>';
}
/* reply | reply all | reply to list | forward links */
if (!$simple && !isset($hm_input['raw'])) {
    echo '      <td class="tables4" nowrap colspan="3">',"\n";
}
if (!isset($hm_input['raw'])) {
echo '      &nbsp;
      <a class="font2" href="compose.php?id=',$hm_input['id'],'&amp;reply=1',
         '&amp;part=',$hm_input['top_level'],'&amp;uid=',$hm_input['uid'],$html_flag,
         '&amp;mailbox=',urlencode($hm_input['mailbox']),'">
      ',$str[35],'</a>&nbsp;&nbsp;&nbsp;',"\n";
echo '      <a class="font2" href="compose.php?id=',$hm_input['id'],
      '&amp;reply=1&amp;all=1&amp;part=',$hm_input['top_level'],$html_flag,
      '&amp;uid=',$hm_input['uid'],'&amp;mailbox=',urlencode($hm_input['mailbox']),'">
      ',$str[36],'</a>&nbsp;&nbsp;&nbsp;',"\n";
if ($message_list_reply) {
    echo '      <a class="font2" href="compose.php?id=',$hm_input['id'],
       '&amp;reply=1&amp;list_reply=',urlencode($message_list_reply_to),
       '&amp;part=',$hm_input['top_level'],$html_flag,'&amp;uid=',$hm_input['uid'],
       '&amp;mailbox=',urlencode($hm_input['mailbox']),'">
      ',$str[40],'</a>&nbsp;&nbsp;&nbsp;',"\n";
}
    echo '      <a class="font2" href="compose.php?id=',$hm_input['id'],
       '&amp;forward=1&amp;part=',$hm_input['top_level'],'&amp;uid=',$hm_input['uid'],
       '&amp;mailbox=',urlencode($hm_input['mailbox']),'">
      ',$str[37],'</a>&nbsp;&nbsp;&nbsp;',"\n";
if (isset($config['enable_bounce_option']) && $config['enable_bounce_option'] == 
    'true') {
    echo '      <a class="font2" href="compose.php?id=',$hm_input['id'],
       '&amp;bounce=1&amp;part=',$hm_input['top_level'],'&amp;uid=',$hm_input['uid'],
       '&amp;mailbox=',urlencode($hm_input['mailbox']),'">
      ',$str[222],'</a>&nbsp;&nbsp;&nbsp;',"\n";
}
if ($draft) {
    echo '      <a class="font2" href="compose.php?id=',$hm_input['id'],
       '&amp;draft=1&amp;uid=',$hm_input['uid'],'&amp;mailbox=',
       urlencode($hm_input['mailbox']),'">
      ',$str[247],'</a>&nbsp;&nbsp;&nbsp;',"\n";
}
if (isset($message_headers['message-id'])
    && isset($_SESSION['current_flags']) && stristr($_SESSION['current_flags'], 
    'answered')) {
    echo '      <a class="font2" href="message.php?id=',$hm_input['id'],
       '&amp;find_response=',urlencode($message_headers['message-id']),
       '&amp;uid=',$hm_input['uid'],'&amp;mailbox=',
       urlencode($hm_input['mailbox']),'">
      ',$str[253],'</a>&nbsp;&nbsp;&nbsp;',"\n";
}
if (!$simple) {
    echo '      </td>
   </tr>
   <tr>
      <td class="tables4" colspan="3">',"\n";
}

/* check for rfc header information on nested parts */
$part_decode = false;
if (strstr($hm_input['part'], '.') && array_key_exists(1, $structure)) {
    $part_decode = true;
    $value = &hm_in_multi_array($hm_input['part'], $structure, array(), true); 
    $part_headers = hm_get_full_header($imap_stream, $hm_input['uid'], $value[0]);
    if (!isset($part_headers['content-type'])) {
        $part_headers['content-type'] = '';
    }
    $part_code_page = false;
    $part_charset_convert = false;
    $part_charset = false;
    $part_utf = false;
    if ($part_charset = strstr(strtolower($part_headers['content-type']), 'charset')) {
        if ($str['charset'] == 'UTF-8') {
            $part_charset = substr(strstr($part_charset, '='), 1);
            $part_charset = substr($part_charset, 0, strcspn($part_charset, ' '));
            $part_charset = str_replace(array('"', ';'), '', $part_charset);
            $part_charset = trim($part_charset);
            if (isset($_SESSION['charsets'][$part_charset])) {
                $part_code_page = $_SESSION['charsets'][$part_charset];
                $part_charset_convert = true;
            }
        }
    }
    if ($charset == 'utf-8') {
        $part_utf = true;
    }
   
    /* check for mailing list header */
    if (isset($part_headers['list-post'])) {
        if (preg_match("/<mailto:([^>]+)>/i", $part_headers['list-post'], $matches)) {
            $list_reply = true;
            $list_reply_to = $matches[1]; 
        }
    }
    elseif (isset($part_headers['x-list-post'])) {
        if (preg_match("/<mailto:([^>]+)>/i", $part_headers['x-list-post'], $matches)) {
            $list_reply = true;
            $list_reply_to = $matches[1]; 
        }
    }
    else {
        $list_reply = false;
    }

    /* rfc message headers */
    if (is_array($part_headers)) {
        $feilds = array ('subject', 'from', 'date');
        if (isset($hm_input['part_full']) && !$simple) { 
            $part_full_view = 'yes';
            echo '      <table cellpadding="1" cellspacing="1">',"\n";
            foreach ($part_headers as $key => $value) {
                echo '         <tr>
            <td colspan="2">
            <small>&nbsp;',$key,
            ': ',$value,'</small><br>
            </td>
        </tr>',"\n";
            }
        }
        else {
            if (!$simple) {
                echo '      <table cellpadding="1" cellspacing="1">
         <tr>
            <td>
            <b>&nbsp;&nbsp;&nbsp;',$str[21],':&nbsp;&nbsp;</b>
            </td>
            <td>
            ',$part_headers['subject'],'
            </td>
        </tr>
        <tr>
            <td>
            <b>&nbsp;&nbsp;&nbsp;',$str[22],':</b>
            </td>
            <td>
            ',$part_headers['from'],'
            </td>
        </tr>
         <tr>
            <td>
            <b>&nbsp;&nbsp;&nbsp;',$str[23],':</b>
            </td>
            <td>
            ',date($date_string, ( strtotime($part_headers['date']))),'
            </td>
        </tr>',"\n";
            }
            else {
                echo '<br>',$str[21],': ',$part_headers['subject'],$str['charset'], 
                     '<br>',$str[22],': ',$part_headers['from'],'<br>Date: ',
                     date($date_string, (strtotime($part_headers['date']))),
                     "<br>\n";
            }
        }
        if (!$simple) {
            echo '      </table>
      </td>
   </tr>
   <tr>
      <td class="tables4" colspan="3">
      <table width="100%" cellpadding="1" cellspacing="1">
         <tr>
            <td nowrap colspan="3">&nbsp;',"\n";
        }
        /* full/small/reply/list reply/forward links for rfc part */
        if (isset($hm_input['part_full']) && !$simple) {
            echo '            <a class="font2" href="message.php?',
                 'uid=',$hm_input['uid'],'&amp;id=',$hm_input['id'],
                 '&amp;part=',$hm_input['part'],'&amp;mailbox=',
                 urlencode($hm_input['mailbox']),'&amp;page_num=',
                 $hm_input['page_num'],'">',$str[30],'</a>&nbsp;&nbsp;',"\n";
        }
        elseif (!$simple) {
            echo '            <a class="font2" href="message.php?uid=',
                 $hm_input['uid'],'&amp;id=',$hm_input['id'],'&amp;part=',
                 $hm_input['part'],'&amp;mailbox=',urlencode($hm_input['mailbox']),
                 '&amp;part_full=yes&amp;page_num=',$hm_input['page_num'],
                 '">',$str[29],'</a>&nbsp;&nbsp;',"\n";
        }
        echo '            <a class="font2" href="compose.php?id=',$hm_input['id'],
            '&amp;reply=1&amp;part=',$hm_input['part'],'&amp;uid=',$hm_input['uid'],
            '&amp;mailbox=',urlencode($hm_input['mailbox']),'">
            ',$str[41],'</a>&nbsp;&nbsp;',"\n";
        echo '            <a class="font2" href="compose.php?id=',$hm_input['id'],
            '&amp;reply=1&amp;all=1&amp;part=',$hm_input['part'],'&amp;uid=',
            $hm_input['uid'],'&amp;mailbox=',urlencode($hm_input['mailbox']),'">
            ',$str[36],'</a>&nbsp;&nbsp;',"\n";
        if (isset($list_reply) && $list_reply) {
        echo '            <a class="font2" href="compose.php?id=',$hm_input['id'],
            '&amp;reply=1&amp;list_reply=',urlencode($list_reply_to),
            '&amp;part=',$hm_input['part'],'&amp;uid=',$hm_input['uid'],
            '&amp;mailbox=',urlencode($hm_input['mailbox']),'">
            ',$str[40],'</a>&nbsp;&nbsp;',"\n";
        }
        echo '            <a class="font2" href="compose.php?id=',$hm_input['id'],
            '&amp;forward=1','&amp;part=',$hm_input['part'],'&amp;uid=',$hm_input['uid'],
            '&amp;mailbox=',urlencode($hm_input['mailbox']),'">
            ',$str[225],'</a>&nbsp;&nbsp;',"\n";
        if (!$simple) {
            echo '            </td>
         </tr>
      </table>
      </td>
   </tr>
   <tr>
      <td class="tables4" colspan="3">',"\n";
        } 
    }
}
}
/* search headers and body for email addresses */
$test_headers = array();
foreach ($message_headers as $index => $value) {
    switch (true) {
        case preg_match('/^received/', $index):
        case $index == 'message-id':
        case $index == 'resent-message-id':
        case $index == 'references':
        case $index == 'in-reply-to':
            break;
        default:
            $test_headers[] = $value;
            break;
    }
}
if (isset($part_headers)) {
    $test_part_headers = array();
    foreach ($part_headers as $index => $value) {
        switch (true) {
            case preg_match('/^received/', $index):
            case $index == 'message-id':
            case $index == 'resent-message-id':
            case $index == 'references':
            case $index == 'in-reply-to':
                break;
            default:
                $test_part_headers[] = $value;
                break;
        }
    }
    $part_string = implode(' ', $test_part_headers);
}
else {
    $part_string = '';
}
$test_string = implode(' ', $test_headers).' '.$part_string;
if (substr($dsp_type, 0, 4) == 'text') {
    $test_string .= ' '.$text_part;
}
if (preg_match_all("/([\.\-\_[:alnum:]]+@[\.\-\_[:alnum:]]{2,}\.[[:alnum:]]{2,})/i", 
                   $test_string, $matches)) {
    if (isset($matches[1])) {
        $get_addresses = array_unique($matches[1]);
    }
    else {
        $get_addresses = array();
    }
}

/* setup charset conversion for message part being displayed */
if (isset($part_decode) && $part_decode) {
    $message_charset_convert = $part_charset_convert;
    $message_code_page = $part_code_page;
    $message_utf = $part_utf;
    $message_charset = $part_charset;
}
else {
    $message_charset_convert = $charset_convert;
    $message_code_page = $code_page;
    $message_utf = $utf;
    $message_charset = $charset;
}

/* if the selected message part is an image we can display */
if (substr($dsp_type, 0, 5) == 'image') {
    echo '      <br><center><img src="download.php?id=',$hm_input['id'],
         '&amp;mailbox=',$hm_input['mailbox'],
         '&amp;uid=',$hm_input['uid'],
         '&amp;part=',$hm_input['part'],
         '&amp;decode=',$decode,
         '&amp;type=',$type,
         '&amp;subtype=',$subtype,
         '&amp;name=',$name,'" alt="',$name,'"></center><br>',"\n";
}

/* if raw message view is selected */
elseif (isset($hm_input['raw']) && $hm_input['raw'] == 1) {
    $text_part = hm_get_message_part($imap_stream, $hm_input['uid'], 'raw');
    echo '             <td>
             <table width="97%" align="center">
                <tr>
                   <td>
                   <pre>',hm_special_chars($text_part, $str['charset'], 
                                           $message_charset_convert, $message_code_page,
                                           $message_utf),'</pre>
                  </td>
               </tr>
            </table>
            </td>
         </tr>
      </table>',"\n";
}

/* if the selected part is an HTML part */
elseif ($dsp_type == 'texthtml') {
    require_once('../filter/filter.php');
    $level = 1;
    if (isset($_SESSION['settings']['filter_level']) &&
        is_numeric($_SESSION['settings']['filter_level'])) {
        $level = $_SESSION['settings']['filter_level'];
    }
    $clean = hm_filter_html($text_part, $level);
    if ($message_charset_convert) {
        $clean = hm_utf8_convert($clean, $message_code_page);
    }
    elseif ($str['charset'] == 'UTF-8') {
        if ((isset($message_charset) && $message_charset != 'utf-8') ||
           (isset($message_headers['content-type']) && 
           !stristr(strtolower($message_headers['content-type']), 'utf-8'))) {
            $clean = utf8_encode($clean);
        }
    }
    /* if no html tags are found in the message aside from the 
       start and stop sanitized html tags inserted by the filter
       then format this as a text part and display as text */

    if (substr_count($clean, "<") < 3) {
        $clean = &hm_text_cleanup($clean);
        $clean = "\n<pre>\n".$clean."\n</pre>\n";
    } 
    /* the html filter puts new window targets in a tags, lets take them
       out if the href is a reference to the current page */
    $clean = preg_replace("/(\<a href=\"#.*) target=\"_new\"/", "\\1", $clean);

    /* replace mailto: with a hm url */
    $clean = preg_replace("/\<a href=\"mailto:(.*)\" target=\"_new\"\>/", 
                 "<a href=\"compose.php?id=".$hm_input['id']."&amp;to=\\1\">", $clean); 
    echo '      <table width="97%" align="center">
         <tr>
             <td>
             ',$clean,'<br>
             </td>
         </tr>
      </table>',"\n";
}

/* if the selected part is a text part */
elseif ($dsp_type == 'textplain')  {
    if (isset($_SESSION['settings']['font_type'])) {
        $font_type = $_SESSION['settings']['font_type'];
    }
    else {
        $font_type = 'monospace';
    }
    if (isset($_SESSION['settings']['font_size'])) {
        if ($_SESSION['settings']['font_size'] == 1) {
            $pt = '10pt';
        }
        elseif ($_SESSION['settings']['font_size'] == 2) {
            $pt = '11pt';
        }
        else {
            $pt = '12pt';
        }
    }
    else {
        $pt = '11pt';
    }
    $text_part = hm_special_chars($text_part, $str['charset'], $message_charset_convert,
                                  $message_code_page, $message_utf);
    $lines = split("\n", $text_part);
    $text_part = '';
    $last_line = '';

    /* add reply quoting color */
    $block = false;
    foreach ($lines as $line) {
        $reply_test = substr(ltrim($line), 0, 4);
        if ($reply_test == '&gt;' || $last_line == "\\" || substr($line, 0, 1) == '|') {
            $last_line = substr($line, -1, 1);
            if (!$block) { 
                $line = "<font\tstyle=\"{font-family:\t".$font_type.
                        ";\tcolor:\t#555555}\">".$line."<br>\n";
               $block = true; 
            }
            else {
                $line = $line."<br>\n";
            }
        }
        else {
            if ($block) {
                $line = '</font>'.$line."<br>\n";
            }
            else {
                $line = $line."<br>\n";
            }
            $last_line = '';
            $block = false;
        }
        $line = str_replace('&gt;', ' &gt;', $line);
        $text_part .= $line;
    }

    /* add clickable (http|ftp)s links */
    if (isset($_SESSION['settings']['click_links']) &&
        $_SESSION['settings']['click_links'] == 'true') {
        $text_part = preg_replace("/((http|ftp)s?:\/\/(%[[:digit:]A-Fa-f][[:digit:]A-Fa-f]|[-_\.!~\*';\/\?#:@&=\+$,[:alnum:]])+)/",
                    "<a\ttarget=\"_new\"\thref=\"\\1\">\\1</a>",
                    $text_part);
    }
    $text_part = str_replace(' &gt;', '&gt;', $text_part);

    /* add clickable email addresses */
    if (isset($_SESSION['settings']['click_email']) &&
        $_SESSION['settings']['click_email'] == 'true') {
        $text_part = preg_replace("/([\w\.\-]+@[a-zA-Z0-9\-]+(\.[a-zA-Z0-9\-]{1,})*(\.[a-zA-Z]{2,3}){1,2})/",
                 "<a\thref=\"compose.php?id=".$hm_input['id']."&amp;to=\\1\">\\1</a>", 
                 $text_part);
    }
    $text_part = str_replace(' ', '&nbsp;', $text_part);

    echo '      <table width="97%">
         <tr>
            <td nowrap width="1%">
            &nbsp;
            </td>
            <td style="{font-family: ',$font_type,'; font-size: ',$pt,'}">';

    /* check for LARGE text parts and display notice */
    if (isset($_SESSION['cutoff']) && $_SESSION['cutoff'] == 1) {
        echo '            <br>
            <table align="center" cellspacing="4" class="tables4">
               <tr>
                  <td align="center">
                  ',$str[260],'
                  </td>
               </tr>
               <tr>
                  <td align="center">
                  <a class="font2" href="message.php?id=',$hm_input['id'],'&amp;uid=',
                  $hm_input['uid'],'&amp;part='.$hm_input['part'].
                  '&amp;mailbox=',$hm_input['mailbox'],
                  '&amp;big_text=1">',$str[261],'</a><br>
                  </td>
               </tr>
            </table><br>',"\n";
    }

    /* display text part */
    echo "\n",'<!-- Message text -->',"\n",$text_part,'<!-- End of message text -->
            </td>
         </tr>
      </table>',"\n";
}

/* hmm... not displayable */
elseif (!$simple) {
    echo '      <table width="97%" align="center">
         <tr>
            <td>
            </td>
         </tr>
      </table>',"\n";
}

/* message attachments display */
if (!isset($hm_input['raw'])) {
    if (!$simple) {
        echo '      </td>
   </tr>
   <tr>
      <td colspan="3">
      <table width="100%" class="tables2" cellspacing="0" cellpadding="2" align="center">
         <tr class="tables1">
            <td align="center" colspan="5">
            <b>',$str[46],'</b>
            </td>
         </tr>
         <tr>
            <td colspan="2">
            </td>
            <td width="30%">
            <small><b>',$str[44],'</b></small>
            </td>
            <td width="60%">
            <small><b>',$str[45],'</b></small>
            </td>
            <td width="10%">
            <small><b>',$str[24],'</b></small>
            </td>
         </tr>',"\n";
    }
    else {
        echo '&nbsp;&nbsp;',$str[46],"\n";
    }
    $atag ='<a class="font2" href="message.php?uid='.$hm_input['uid'].
           '&amp;id='.$hm_input['id'].'&amp;mailbox='.urlencode($hm_input['mailbox']).
           '&amp;page_num='.$hm_input['page_num']."&amp;";
    hm_print_attachments($structure, $hm_input['part'], $atag);
    if (!$simple) {
        echo '      </table>
      </td>
   </tr>',"\n";
    }
}

/* add to addressbook option */
if (!empty($get_addresses) && !$simple) {
echo '   <tr>
   <td align="center" colspan="3">
   <table width="100%" cellpadding="3" cellspacing="4">
      <tr>
         ',$message_dsp_header,'
         <td nowrap class="tables2" align="right">
         <form action="contacts.php" method="post">
         <input type="hidden" name="id" value="',$hm_input['id'],'">
         <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'\">
         &nbsp;<input type="submit" value="',$str[43],'" name="prep" class="button1">
         <select name="prep_addy">',"\n";
    foreach ($get_addresses as $addy) {
        echo '              <option value="',hm_special_chars($addy, $str['charset'],
             $charset_convert, $code_page, $utf),"\">", 
             hm_special_chars($addy, $str['charset'], $charset_convert, 
                              $code_page, $utf),
             "</option>\n";
    }
    echo '         </select>
         </form>',"\n";
}
/* prev+next links and folder link stored in $message_dsp_header */
elseif (!$simple) {
    echo '   <tr>
      <td align="center" colspan="3">
      <table width="100%" cellpadding="6" cellspacing="4">
         <tr>
            ',$message_dsp_header,'
            <td class="tables2" width="60%">&nbsp;',"\n";
}
else {
    echo '<br>',$message_dsp_header;
}

/* indicator for uid sort cache use */
if (!$simple) {
    echo '            </td>
         </tr>
      </table>',"\n";

    /* folder preview option */
    if (isset($_SESSION['settings']['folder_preview']) &&
        $_SESSION['settings']['folder_preview'] != 'none' &&
        $preview_pos == 'bottom') {
        if (!$preview_hide) {
            if (isset($hm_input['scroll_uid'])) {
                $scroll_uid = $hm_input['scroll_uid'];
            }
            else {
                $scroll_uid = $hm_input['uid'];
            }
            hm_folder_preview($imap_stream, $scroll_uid, $sort_info, $hm_input['id'],
                              $hm_input['mailbox'], $hm_input['uid']);
        }
    }
    echo '      </td>
   </tr>
</table>',"\n";
}
echo '
</body>
</html>';

/* clean up flags */
if (isset($_SESSION['prev_flag'])) {
    unset($_SESSION['prev_flag']);
    unset($_SESSION['prev_new']);
}
if (isset($_SESSION['next_flag'])) {
    unset($_SESSION['next_flag']);
    unset($_SESSION['next_new']);
}
if (isset($_SESSION['current_flags'])) {
    unset($_SESSION['current_flags']);
}

/* close imap connection */
hm_imap_logout($imap_stream); 

?>
