<?php

/* new.php: Displays new mail from all folders 
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: new.php,v 1.118.2.1 2004/05/06 15:39:56 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'new');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file)) {
    $config = $_SESSION['config'];
}

/* some basic init stuff */
$hm_input['id'] = session_id();
$str = $_SESSION['str'];

if (isset($hm_input['destination'])) {
    $dest = $hm_input['destination'];
}
elseif (isset($_SESSION['move_to_destination'])) {
    $dest = $_SESSION['move_to_destination'];
}
else {
    $dest = 'INBOX';
}
$_SESSION['move_to_destination'] = $dest;

/* check for simple option and set flag */
$simple = false;
if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 'true')
   || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 'true')) {
    $simple = true;
}

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config,
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* get folder list */
$dsp_folders = $_SESSION['dsp_folders'];

/* process message control action */
$action = false;
switch (true) {
    case isset($hm_input['move']):
        $action = 'move';
        break;
    case isset($hm_input['sort']):
        $action = 'sort';
        break;
    case isset($hm_input['delete']):
        $action = 'delete';
        break;
    case isset($hm_input['read']):
        $action = 'read';
        break;
    case isset($hm_input['copy']):
        $action = 'copy';
        break;
    default:
        break;
}
if ($action) {
    if ($hm_input['selection_type'] == 'page') {
        $sel = false;
        $array = $_SESSION['new_data'];
    }
    elseif ($hm_input['selection_type'] == 'marked') {
        $array = $_POST;
        $sel = true;
    }
    elseif (isset($hm_input['selection_type'])) {
        if (isset($_SESSION['new_data']) && array_key_exists($hm_input['selection_type'], 
            $_SESSION['new_data'])) {
            $array = array($hm_input['selection_type'] => 
                           $_SESSION['new_data'][$hm_input['selection_type']]);
            $sel = false;
        }
    }
    foreach ($array as $name => $value) {
            if ($sel) {
                $name = base64_decode($name);
            }
        if (substr($name, 0, 5) == 'fold_' || !$sel) {
            if ($sel) {
                $fold = substr($name, 5);
            }
            else {
                $fold = $name;
            }
            $dsp_count = count($value);
            if ($dsp_count > 1) {
                $dsp_end = $str[18];
            }
            else {
                $dsp_end = $str[26];
            }
            $dest = false;
            if (isset($hm_input['destination'])) {
                $dest = $hm_input['destination'];
            }
            if ($sel) {    
                $uid_string = $value[0];
                if ($dsp_count > 1) {
                    $uid_string = implode(',', $value);
                }
            }
            else {
                $uids = array_keys($value);
                $uid_string = $uids[0]; 
                if ($dsp_count > 1) {
                    $uid_string = implode(',', $uids);
                }
            }
            hm_select_mailbox($imap_stream, $fold);
            $result = hm_message_controls ($action, $imap_stream,
                                           $uid_string, $dest, false, false, $fold, 
                                           $dsp_count, $dsp_end);
        }
    }
}

/* get unseen messages */
$unseen = hm_unseen_status ($imap_stream, $_SESSION['folders']);

/* get headers for unseen messages */
$data = array();
$total_unseen = 0;
$total_unseen_folders = 0;
$unseen_tmp = $unseen;
foreach ($unseen_tmp as $folder => $new_count) {
    if ($new_count > 0) {
        $total_unseen_folders++;
        $total_unseen += $new_count;
        hm_select_mailbox($imap_stream, $folder);
        $uid_list = hm_search_mailbox($imap_stream, 'SEARCH UNSEEN');
        if (trim($uid_list) == '') {
            $unseen[$folder] = 0;
        }
        $uid_list = str_replace(' ', ',', trim($uid_list));
        $headers = &hm_get_messages($uid_list, $imap_stream);
        uasort($headers, "hm_date_cmp");
        $data[$folder] = $headers; 
    }
}

/* check for missing folders */
hm_check_folders($imap_stream);

/* toolbar */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, true, $str[10]);

/* new messages table */
$t_all = false;
if (isset($hm_input['toggle_all'])) {
    $t_all = true;
}
if (count($data) > 0) {
    echo '<br>
<form action="new.php" method="post">',"\n";
    if (!$simple) {
        echo '<table width="98%" align="center" cellpadding="4" cellspacing="4">
   <tr>
      <td nowrap width="30%" align="center" class="tables2">
      <b>',$total_unseen,'</b> ',$str[50],' <b>',$total_unseen_folders,
      '</b> ',$str[125],'
      </td>
      <td width="70%" align="right" colspan="2" class="tables2" nowrap>',"\n";
    }

    /* message action controls */
    echo '      <input class="button3" type="submit" name="toggle_all" ', 
         'value="',$str[246],'">&nbsp;&nbsp;
      <input type="hidden" name="id" value="',$hm_input['id'],'">
      <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">
      &nbsp;&nbsp;<select name="selection_type" class="select3">
          <option class="option3" value="marked">',$str[6],'</option>';
    $fold_tmp = array_keys($data);
    $fold_tmp_dsp = hm_folder_dsp($fold_tmp);
    foreach ($fold_tmp as $val) {
        echo '<option class="option3" value="',$val,'">',$str[51],' ',
             $fold_tmp_dsp[$val],'  (',$unseen[$val],')</option>',"\n";
    }
    echo '          <option class="option3" value="page">',$str[52],'</option>
      </select>&nbsp;
      <input type="submit" class="button3" name="read" value="',$str[2],'">
      <input type="submit" class="button3" name="delete" value="',$str[4],'">
      &nbsp;<input type="submit" class="button3" name="copy" value="',$str[1],'">-<input type="submit" class="button3" name="move" value="',$str[0],'">-&gt;
      <select class="select3" name="destination">',"\n";
    hm_folder_options($dest, false, $simple, false, 'class="option3"');
    echo '      </select>&nbsp;&nbsp;',"\n";

    /* new message table headers */
    if (!$simple) {
        echo '
      </td>
   </tr>
   <tr>
      <td>
      </td>
   </tr> 
   <tr class="tables1">
      <td colspan="4">
      <table width="99%" align="center" cellpadding="1" cellspacing="0" class="tables5">
         <tr class="tables1">'."\n";
        hm_start_message_listing(false);
        echo '         </tr>', "\n";
        if (isset($_SESSION['nn4_warning'])) {
            echo '<tr><td></td><td></td><td class="tables1">
                  <img src="../images/trans.gif" height="1" width="350"></td></tr>';
        }
    }
    else {
        echo '<table>';
    }

    /* loop through folders with new mail */
    foreach($data as $folder => $uid_array) {
        echo '         <tr>
            <td colspan="7">',"\n";
            if (!$simple) {
                echo '            <table cellpadding="1" cellspacing="0" width="100%">
               <tr class="tables2">
                  <td nowrap width="1%">
                  &nbsp;',"\n";
            }
            else {
                echo '<tr><td>';
            }
            /* clickable folder name */
            echo '                  <font class="font2">
                  &nbsp;',$unseen[$folder],'&nbsp;
                  </font>';
            if (!$simple) {
                echo '                  </td>
                  <td>';
            }
            echo '                  <a class="font2" href="mailbox.php?mailbox=',
                  urlencode($folder),
                  '&amp;id=',$hm_input['id'],'">
                  <b>',hm_htmlize($dsp_folders[$folder]),'
                  </b>
                  </a>',"\n";
        if (!$simple) {
            echo '                  </td>
               </tr>
            </table>
            </td>
         </tr>',"\n";
        }
        else {
            echo '</td></tr>';
        }
        /* get values for new messages in each folder */
        $chk_folder = base64_encode('fold_'.$folder);
        foreach ($uid_array as $uid => $headers) {
            hm_print_row($headers, $simple, $t_all, $folder, $hm_input['id'], $uid,
                         array(), false, $chk_folder);
        }
    }
    if (!$simple) {
        echo '         <tr>
            <td class="tables1" colspan="7">
            &nbsp;
            </td>
         </tr>
      </table>
      </td>
   </tr>
</table>';
    }
    else {
        echo '</table>';
    }
}
else {
    echo '</table>
<br><table align="center" class="tables4">
   <tr>
      <td align="center">
      <font class="font2">
      ',$str[53],'
      </font>
      </td>
   </tr>
</table>',"\n";
}

echo '</form>
</body>
</html>';
$_SESSION['new_data'] = $data;

/* close imap connection */
hm_imap_logout($imap_stream); 

?>
