<?php

/* options.php: Page for users to change personal settings
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: options.php,v 1.131 2004/03/30 20:55:04 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'options');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file)) {
    $config = $_SESSION['config'];
}
$hm_input['id'] = session_id();
$str = $_SESSION['str'];

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config,
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* get unseen status */
$unseen = hm_unseen_status ($imap_stream, $_SESSION['folders']);


/* profiles */
$current_count = $_SESSION['settings']['profile_count'];

/* remove profile */
foreach ($_POST as $name => $val) {
    if (substr($name, 0, 14) == 'remove_profile') {
        $index = substr($name, 15);
        array_splice($_SESSION['profiles'], $index, 1);
        $current_count--;
        $_SESSION['settings']['profile_count'] = $current_count;
        hm_write_settings($_SESSION['user'], $config['settings_dir'], $index);
        $_SESSION['notices'][] = $str[249];
        break;
    }
}
/* add profile */
if (isset($hm_input['add_profile'])) {
    $_SESSION['profiles'][] = array('sig' => '', 'from_name' => '', 'from_address' => '');
    $current_count++;
    $_SESSION['settings']['profile_count'] = $current_count;
    hm_write_settings($_SESSION['user'], $config['settings_dir']);
    $_SESSION['notices'][] = $str[248];
}

/* update settings */
if (isset($hm_input['update'])) {

    /* set css value */
    $_SESSION['settings']['css_file'] = $hm_input['css_selection'];

    /* font size */
    if ($hm_input['font_size'] == 1) {
        $_SESSION['settings']['css_file'] = str_replace('.css', '_small.css',
        $_SESSION['settings']['css_file']);
    }
    elseif ($hm_input['font_size'] == 2) {
        $_SESSION['settings']['css_file'] = str_replace('.css', '_large.css',
        $_SESSION['settings']['css_file']);
    }
    $_SESSION['settings']['font_size'] = $hm_input['font_size'];

    /* date format setting */
    $_SESSION['settings']['date_format'] = $hm_input['date_selection'];

    /* time format setting */
    $_SESSION['settings']['time_format'] = $hm_input['time_selection'];

    /* combine time and date */
    if ($hm_input['date_selection'] == 'r') {
        $_SESSION['settings']['date_string'] = 'r';
    }
    else {
        $_SESSION['settings']['date_string'] = $hm_input['time_selection'].' '.
                                               $hm_input['date_selection'];
    }

    /* message listing field order */
/*
    for($i=1;$i<7;$i++) {
        $_SESSION['settings']['pos_'.$i] = $_POST['pos_'.$i];
    }
*/

    /* language setting */
    $_SESSION['settings']['lang'] = $hm_input['lang_selection'];
    $str = hm_translate($hm_input['lang_selection'], $lang_options);
    if (isset($config['disable_utf8'])) {
        if ($config['disable_utf8'] != 'true') {
            $_SESSION['str']['charset'] = 'UTF-8';
        }
    }
    else {
        $_SESSION['str']['charset'] = 'UTF-8';
    }
    if (isset($config['disable_utf8'])) {
        if ($config['disable_utf8'] != 'true') {
            if (!isset($_SESSION['charsets']) || empty($_SESSION['charsets'])) {
                $_SESSION['charsets'] = include('../lang/charsets.php');
            }
            foreach ($str as $key => $value) {
                if (is_array($value)) {
                    foreach ($value as $k => $v) {
                        if ($str['charset'] != 'iso-8859-1') {
                            $_SESSION['str'][$key][$k] =
                                hm_special_chars($v, $str['charset'], true, 
                                $_SESSION['charsets'][$str['charset']], false);
                        }
                        else {
                            $_SESSION['str'][$key][$k] = utf8_encode($v);
                        }
                    }
                }
                else {
                    if ($str['charset'] != 'iso-8859-1') {
                        $_SESSION['str'][$key] =
                            hm_special_chars($value, $str['charset'], true, 
                            $_SESSION['charsets'][$str['charset']], false);
                    }
                    else {
                        $_SESSION['str'][$key] = utf8_encode($value);
                    }
                }
            }
            $_SESSION['str']['charset'] = 'UTF-8';
        }
        else {
            $_SESSION['str'] = $str;
        }
    }
    else {
        if (!isset($_SESSION['charsets']) || empty($_SESSION['charsets'])) {
            $_SESSION['charsets'] = include('../lang/charsets.php');
        }
        foreach ($str as $key => $value) {
            if (is_array($value)) {
                foreach ($value as $k => $v) {
                    if ($str['charset'] != 'iso-8859-1') {
                        $_SESSION['str'][$key][$k] =
                            hm_special_chars($v, $str['charset'], true, 
                            $_SESSION['charsets'][$str['charset']], false);
                    }
                    else {
                        $_SESSION['str'][$key][$k] = utf8_encode($v);
                    }
                }
            }
            else {
                if ($str['charset'] != 'iso-8859-1') {
                    $_SESSION['str'][$key] =
                        hm_special_chars($value, $str['charset'], true, 
                        $_SESSION['charsets'][$str['charset']], false);
                }
                else {
                    $_SESSION['str'][$key] = utf8_encode($value);
                }
            }
        }
        $_SESSION['str']['charset'] = 'UTF-8';
    }
    $str = $_SESSION['str'];

    /* display settings */

    /* message per page */
    if (isset($hm_input['page_count'])) {
        if ($hm_input['page_count'] > 250) {
            $hm_input['page_count'] = 250;
        }
        $_SESSION['settings']['page_count'] = $hm_input['page_count'];
        $_SESSION['sort_data'] = array();
        unset($_SESSION['sort_data']);
    }
    else {
        $_SESSION['settings']['page_count'] = 20;
    }

    /* wrap length on message view */
    if (isset($hm_input['read_wrap'])) {
        $_SESSION['settings']['read_wrap'] = $hm_input['read_wrap'];
    }
    else {
        $_SESSION['settings']['read_wrap'] = 80;
    }

    /* "New" folder refresh setting, defaulting to 1 min refresh rate */
    if (isset($hm_input['refresh_new'])) {
        $_SESSION['settings']['refresh_new'] = $hm_input['refresh_new'];
    } 
    else {
        $_SESSION['settings']['refresh_new'] = 1;
    }

    /* folder preview on the message page */
    if (isset($hm_input['folder_preview'])) {
        if ($hm_input['folder_preview'] == 'none') {
            $_SESSION['settings']['folder_preview'] = 'none';
        }
        else {
            $_SESSION['settings']['folder_preview'] = $hm_input['folder_preview'];
        }
    }
    if (isset($hm_input['preview_position'])) {
        $_SESSION['settings']['preview_position'] = $hm_input['preview_position'];
    }
    else {
        $_SESSION['settings']['preview_position'] = 0;
    }

    /* sent folder */
    if (isset($hm_input['sent_on']) && $hm_input['sent_on'] == 1) {
        $_SESSION['settings']['sent_folder'] = $hm_input['sent_folder'];
    }
    elseif (isset($_SESSION['settings']['sent_folder'])) {
        unset($_SESSION['settings']['sent_folder']);
    }

    /* trash folder */
    if (isset($hm_input['trash_on']) && $hm_input['trash_on'] == 1) {
        $_SESSION['settings']['trash_folder'] = $hm_input['trash_folder'];
    }
    elseif (isset($_SESSION['settings']['trash_folder'])) {
        unset($_SESSION['settings']['trash_folder']);
    }

    /* drafts folder */
    if (isset($hm_input['drafts_on']) && $hm_input['drafts_on'] == 1) {
        $_SESSION['settings']['drafts_folder'] = $hm_input['drafts_folder'];
    }
    elseif (isset($_SESSION['settings']['drafts_folder'])) {
        unset($_SESSION['settings']['drafts_folder']);
    }
 
    /* folder detail */
    if (isset($hm_input['folder_detail'])) {
        $_SESSION['settings']['folder_detail'] = $hm_input['folder_detail'];
    }
    else {
        $_SESSION['settings']['folder_detail'] = 'new';
    }

    /* folder style */
    if (isset($hm_input['folder_style'])) {
        $_SESSION['settings']['folder_style'] = $hm_input['folder_style'];
    }
    else {
        $_SESSION['settings']['folder_style'] = 'nested';
    } 

    /* start page */
    if (isset($hm_input['start_page'])) {
        $_SESSION['settings']['start_page'] = $hm_input['start_page'];
    }
    else {
        $_SESSION['settings']['start_page'] = 'mailbox.php';
    }

    /* update profiles */
    for ($i=0;$i<$current_count;$i++) {
        if (ini_get('magic_quotes_gpc') == 1) {
            $_SESSION['profiles'][$i]['sig'] = stripslashes($_POST['sig_'.$i]);
            $_SESSION['profiles'][$i]['from_name'] = hm_htmlize(stripslashes(str_replace(
                array('<', '>'), '', $_POST['from_name_'.$i])));
            $_SESSION['profiles'][$i]['from_address'] = hm_htmlize(stripslashes(
                str_replace(array('<', '>'), '', $_POST['from_address_'.$i])));
        }
        else {
            $_SESSION['profiles'][$i]['sig'] = $_POST['sig_'.$i];
            $_SESSION['profiles'][$i]['from_name'] = hm_htmlize(str_replace(
                array('<', '>'), '', $_POST['from_name_'.$i]));
            $_SESSION['profiles'][$i]['from_address'] = hm_htmlize(str_replace(
                array('<', '>'), '', $_POST['from_address_'.$i]));
        }
    }

    /* filter level */
    $level = 1;
    if (isset($hm_input['filter_links']) && $hm_input['filter_links'] == 1) {
        $level = 3;
    }
    if (isset($hm_input['filter_images']) && $hm_input['filter_images'] == 1) {
        if ($level > 1) {
            $level = 4;
        }
        else{
            $level = 2;
        }
    }
    $_SESSION['settings']['filter_level'] = $level;
 
    /* simple mode */
    if (isset($hm_input['simple']) && $hm_input['simple'] == 1) {
        $_SESSION['settings']['simple'] = 'true';
    }
    else {
        $_SESSION['settings']['simple'] = 'false';
    }
    
    /* clickable http links */
    if (isset($hm_input['click_links']) && $hm_input['click_links'] == 1) {
        $_SESSION['settings']['click_links'] = 'true';
    }
    else {
        $_SESSION['settings']['click_links'] = 'false';
    }
    /* clickable email links */
    if (isset($hm_input['click_email']) && $hm_input['click_email'] == 1) {
        $_SESSION['settings']['click_email'] = 'true';
    }
    else {
        $_SESSION['settings']['click_email'] = 'false';
    }
         
    /* clean line wrapping */
    if (isset($hm_input['wrap_clean']) && $hm_input['wrap_clean'] == 1) {
        $_SESSION['settings']['wrap_clean'] = 'true';
    }
    else {
        $_SESSION['settings']['wrap_clean'] = 'false';
    }
    /* html mail display */
    if (isset($hm_input['html_only']) && $hm_input['html_only'] == 1) {
        $_SESSION['settings']['html_only'] = 'true';
    }
    else {
        $_SESSION['settings']['html_only'] = 'false';
    }

    /* show clock in toolbar */
    if (isset($hm_input['show_clock']) && $hm_input['show_clock'] == 1) {
        $_SESSION['settings']['show_clock'] = 'true';
    }
    else {
        $_SESSION['settings']['show_clock'] = 'false';
    }

    /* wide toolbar */
    if (isset($hm_input['wide_bar']) && $hm_input['wide_bar'] == 1) {
        $_SESSION['settings']['wide_bar'] = 'true';
    }
    else {
        $_SESSION['settings']['wide_bar'] = 'false';
    }

    /* html mail display as default */
    if (isset($hm_input['html_default']) && $hm_input['html_default'] == 1) {
        $_SESSION['settings']['html_default'] = 'true';
    }
    else {
        $_SESSION['settings']['html_default'] = 'false';
    }
    /* font family for message text */
    if (isset($hm_input['font_type'])) {
        $_SESSION['settings']['font_type'] = $hm_input['font_type'];
    }
    else {   
        $_SESSION['settings']['font_type'] = 'monospace';
    }
    /* write the settings to the user's setting file */
    hm_write_settings($_SESSION['user'], $config['settings_dir']);
    $_SESSION['notices'][] = $str[118];
}

/* check for simple option and set flag */
$simple_dsp = false;
if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 'true')
   || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 'true')) {
    $simple_dsp = true;
}

/* set some defaults */
$settings = $_SESSION['settings'];
if (isset($settings['page_count']) && $settings['page_count'] > 0) {
    $page_count = $settings['page_count'];
}
else {
    $page_count = 20;
}
if (isset($settings['read_wrap']) && $settings['read_wrap'] > 0) {
    $read_wrap = $settings['read_wrap'];
}
else {
    $read_wrap = 80;
}
if (!isset($settings['font_size'])) {
    $settings['font_size'] = 0;
}
/*
$positions = array(1 => 'checkbox', 2 => 'subject', 3 => 'from', 4 => 'date', 
                   5 => 'size',     6 => 'flags');

for ($i=1;$i<7;$i++) {
    if (!isset($settings['pos_'.$i])) {
        $settings['pos_'.$i] = $positions[$i];
    }
}
*/

/* available languages */
if (!isset($settings['lang'])) {
    if (isset($_SESSION['config']['default_lang'])) {
        $settings['lang'] = $_SESSION['config']['default_lang'];
    }
    else {
        $settings['lang'] = 'en_US';
    }
}
$langs = array();
if ($dir = @opendir("../lang")) {
  while (($file = readdir($dir)) !== false) {
    if (preg_match("/\.php$/", $file) && $file != 'index.php' && 
        $file != 'lang_index.php') {
        $langs[] = str_replace('.php', '', $file);
    } 
  }  
  closedir($dir);
}
$lcount = count($langs);

/* select CSS */
if (!isset($settings['css_file'])) {
    if (isset($config['default_theme'])) {
        $settings['css_file'] = $config['default_theme'];
    }
    else {
        $settings['css_file'] = 'default.css';
    }
}
else {
    if (isset($settings['font_size']) && $settings['font_size'] == 1) {
        $settings['css_file'] = str_replace('_small', '', $settings['css_file']);
    }
    elseif (isset($settings['font_size']) && $settings['font_size'] == 2) {
        $settings['css_file'] = str_replace('_large', '', $settings['css_file']);
    }
}
$css_files = array();
if ($dir = @opendir("../themes")) {
  while (($file = readdir($dir)) !== false) {
    if (preg_match("/\.css$/", $file) && !stristr($file, 'small') &&
        !stristr($file, 'large')) {
        $css_files[] = $file;
    } 
  }  
  closedir($dir);
}
sort($css_files);
$count = count($css_files);

/* check for missing folders */
hm_check_folders($imap_stream);

/* toolbar */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, $str[12]);

/* options form */
echo '<form action="options.php" method="post">
<input type="hidden" name="id" value="',$hm_input['id'],'">
<input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">
<br>',"\n";

if (!$simple_dsp) {
    $opt_start = '         <tr class="tables1">
            <td width="65%" nowrap>';
    $opt_mid = '            </td>
            <td nowrap>';
    $opt_close = '            </td>
         </tr>'."\n";
    echo '<table align="center" cellpadding="4" cellspacing="2">
   <tr>
      <td align="center" rowspan="3" valign="top">
      <table align="center" width="50%" cellspacing="1" cellpadding="2" class="tables1">
         <tr class="tables2">
            <td align="center" colspan="2">
            ',$str[98],'
            </td>
         </tr>';
    if (!isset($_SESSION['nn4_warning'])) {
        echo '         <tr class="tables1">
                    <td width="65%" nowrap>
                    &nbsp;&nbsp;',$str[105],':
                    </td>
                    <td>',"\n";
    }
}
else {
    $opt_start = "\n".'<br>';
    $opt_mid = '&nbsp;';
    $opt_close = '';
    echo '<br>&nbsp;&nbsp;',$str[105],': ';
}
/* theme selection */
if (!isset($_SESSION['nn4_warning'])) {
    echo '            <select name="css_selection">',"\n";
    for ($n=0;$n<$count;$n++) {
        echo '            <option value="',$css_files[$n],'" ';
        if ($settings['css_file'] == $css_files[$n]) {
            echo 'SELECTED ';
        }
        echo ">",str_replace('.css', '', $css_files[$n]),"</option>\n";
    }

    /* language selection */
    echo '            </select>',"\n",
        $opt_close;
}
echo $opt_start,'
            &nbsp;&nbsp;',$str[215],':',"\n",$opt_mid,'
            <select name="lang_selection">',"\n";
for ($n=0;$n<$lcount;$n++) {
    if (isset($lang_options[$langs[$n]])) {
    echo '            <option value="',$langs[$n],'" ';
    if ($settings['lang'] == $langs[$n]) {
        echo 'SELECTED ';
    }
    echo ">",$str[$lang_options[$langs[$n]]],"</option>\n";
    }
}

/* font size */
echo '            </select>',"\n",
      $opt_close,
      $opt_start,'
            &nbsp;&nbsp;',$str[281],':',"\n",$opt_mid,'
            <select name="font_size">',"\n";

$sizes = array($str[279] => 0, $str[278] => 1, $str[280] => 2);
foreach ($sizes as $index => $val) {
    echo '            <option value="',$val,'" ';
    if (isset($settings['font_size']) && $settings['font_size'] == $val) {
        echo 'SELECTED ';
    }
    echo '>',$index,"</option>\n";
}

/* time format */
$time_types = array('12:00:00' => 'g:i:s a', '24:00:00' => 'G:i:s',
                    '12:00'    => 'g:i a',   '24:00'    => 'G:i');
echo '            </select>',"\n",
      $opt_close,
      $opt_start,'
            &nbsp;&nbsp;',$str[264],':',"\n",$opt_mid,'
            <select name="time_selection">',"\n";
foreach($time_types as $name => $val) {
    echo '            <option value="',$val,'" ';
    if (isset($settings['time_format']) && $settings['time_format'] == $val) {
        echo 'SELECTED ';
    }
    echo ">",$name,"</option>\n";
}

/* date format */
$date_types = array('mm/dd/yy'     => 'm/d/y',  'mm/dd/yyyy'     => 'm/d/Y',
                    'mm-dd-yy'     => 'm-d-y',  'mm-dd-yyyy'     => 'm/d/Y',
                    'mon dd, yyyy' => 'M j, Y', 'mon dd, yy'     => 'M j, y',
                    'mon dd'       => 'M j',    'month dd, yyyy' => 'F d, Y',
                    'month dd, yy' => 'F d, y', 'rfc822'         => 'r',
                    'dd/mm/yyyy'   => 'd/m/Y',  'dd/mm/yy'       => 'd/m/y');

echo '            </select>',"\n",
      $opt_close,
      $opt_start,'
            &nbsp;&nbsp;',$str[263],':',"\n",$opt_mid,'
            <select name="date_selection">',"\n";
foreach($date_types as $name => $val) {
    echo '            <option value="',$val,'" ';
    if (isset($settings['date_format']) && $settings['date_format'] == $val) {
        echo 'SELECTED ';
    }
    echo ">",$name,"</option>\n";
}
/* font type */
echo '            </select>',"\n",
      $opt_close,
      $opt_start,'
            &nbsp;&nbsp;',$str[107],':',"\n",$opt_mid,'
            <select name="font_type">',"\n";
$fonts = array('serif', 'sans-serif', 'cursive', 'fantasy', 'monospace');
if (isset($settings['font_type'])) {
    $current_font = $settings['font_type'];
}
else {
    $current_font = 'monospace';
}
foreach ($fonts as $font) {
    echo '               <option ';
    if ($current_font == $font) {
        echo 'SELECTED ';
    }
    echo 'value="',$font,'">',$font,'</option>',"\n";
}

/* new page refresh rate */
echo '            </select>&nbsp;&nbsp;',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[108],':',"\n",
     $opt_mid,' 
            <select name="refresh_new">',"\n";
$times = array(0,1,2,3,5,10,15,20,30);
if (isset($settings['refresh_new'])) {
    $cur_set = $settings['refresh_new'];
}
else {
    $cur_set = 1;
}
foreach ($times as $value) {
    if ($value != 1) {
        $mins = $str[120];
    }
    else {
        $mins = $str[119];
    }
    $mins = $value . ' ' . $mins;
    if ($value == 0) {
        $mins = $str[106];
    }
    echo "               <option value=\"$value\"";
    if ($cur_set == $value) {
        echo " SELECTED ";
    }
    echo "> $mins </option>\n";
}

/* start page */
$start_pgs = array($str[220]  => 'mailbox.php',
                   $str[10]   => 'new.php',
                   $str[15]   => 'compose.php',
                   $str[12]   => 'options.php',
                   $str[13]   => 'folders.php',
                   $str[14]   => 'contacts.php',
                   $str[11]   => 'search.php');

if (isset($settings['start_page'])) {
    $sp = $settings['start_page'];
}
else {
    $sp = 'mailbox.php';
}
echo '            </select>',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[219],':',"\n",
     $opt_mid,'
            <select name="start_page">',"\n";
    foreach($start_pgs as $key => $value) {
        echo '<option ';
        if ($sp == $value) {
            echo 'SELECTED ';
        }
        echo 'value="',$value,'">',$key,'</option>',"\n";
    }
    echo "</select>",
     $opt_close,

     /* per page count for mailbox page */
     $opt_start,'
            &nbsp;&nbsp;',$str[109],':',"\n",
     $opt_mid,'
            <input type="text" size="4" name="page_count" ', 
     'value="',$page_count,'" class="text2">',"\n",
     $opt_close,

     /* wrap at length in chars for message page */
     $opt_start,'
            &nbsp;&nbsp;',$str[110],':',"\n",
     $opt_mid,'
            <input type="text" size="4" name="read_wrap" ',
     'value="',$read_wrap,'" class="text2">',"\n",
     $opt_close,

     /* clean wrapping toggle */
     $opt_start,'
            &nbsp;&nbsp;',$str[111],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="wrap_clean" ';
if (isset($settings['wrap_clean']) && $settings['wrap_clean'] == 'true') {
    echo 'CHECKED ';
}

/* show html part toggle */
echo 'value="1">',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[235],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="html_only" ';
if (isset($settings['html_only']) && $settings['html_only'] == 'true') {
    echo 'CHECKED ';
}

/* show clock toggle */
echo 'value="1">',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[284],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="show_clock" ';
if (isset($settings['show_clock']) && $settings['show_clock'] == 'true') {
    echo 'CHECKED ';
}

/* wide toolbar */
echo 'value="1">',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[285],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="wide_bar" ';
if (isset($settings['wide_bar']) && $settings['wide_bar'] == 'true') {
    echo 'CHECKED ';
}

/* html default toggle */
echo 'value="1">',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[274],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="html_default" ';
if (isset($settings['html_default']) && $settings['html_default'] == 'true') {
    echo 'CHECKED ';
}

/* simple mode toggle */
echo 'value="1">',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[112],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="simple" ';
if (isset($settings['simple']) && $settings['simple'] == 'true') {
    echo 'CHECKED ';
}
echo 'value="1">';
if (!$simple_dsp) {
    echo '      </table>
      </td>
      <td valign="top">
      <table align="center" width="100%" cellspacing="1" cellpadding="2" class="tables1">
         <tr class="tables2">
            <td colspan="2" align="center">
            ',$str[99],'
            </td>
         </tr>',"\n";
}

/* HTML links filter toggle */
echo  $opt_start,'
            &nbsp;&nbsp;',$str[113],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="filter_links" ';
if (isset($settings['filter_level']) && ($settings['filter_level'] == 3 ||
    $settings['filter_level'] == 4)) {
    echo 'CHECKED ';
}

/* HTML images filter toggle */
echo 'value="1">',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[114],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="filter_images" ';
if (isset($settings['filter_level']) && ($settings['filter_level'] == 2 ||
           $settings['filter_level'] == 4)) {
    echo 'CHECKED ';
}

/* TEXT clickable links toggle */
echo 'value="1">',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[237],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="click_links" ';
if (isset($settings['click_links']) && $settings['click_links'] == 'true') {
    echo 'CHECKED ';
}

/* TEXT clickable email addresses toggle */
echo 'value="1">',"\n",
     $opt_close,
     $opt_start,'
            &nbsp;&nbsp;',$str[238],':',"\n",
     $opt_mid,'
            <input type="checkbox" name="click_email" ';
if (isset($settings['click_email']) && $settings['click_email'] == 'true') {
    echo 'CHECKED ';
}
echo 'value="1">',"\n";
if (!$simple_dsp) {
    echo '            </td>
         </tr>
      </table>
      </td>
   </tr>
   <tr>',"\n";
}

/* the folder options */
$folders = $_SESSION['folders'];
if (isset($settings['sent_folder'])) {
    $current_sent = urldecode($settings['sent_folder']);
}
else {
    $current_sent = 'INBOX';
}
if (isset($settings['drafts_folder'])) {
    $current_drafts = urldecode($settings['drafts_folder']);
}
else {
    $current_drafts = 'INBOX';
}
if (isset($settings['trash_folder'])) {
    $current_trash = urldecode($settings['trash_folder']);
}
else {
    $current_trash = 'INBOX';
}
if (!$simple_dsp) {
echo '  
      <td align="center" valign="top">
      <table align="center" width="100%" cellspacing="1" cellpadding="2" class="tables1">
         <tr class="tables2">
            <td align="center" colspan="2">
            ',$str[13],'
            </td>
         </tr>
         <tr class="tables1">
            <td>',"\n";
}
else {
    echo '<br>';
}
/* sent folder */
echo '            &nbsp;<input type="checkbox" ';
if (isset($settings['sent_folder'])) {
    echo "CHECKED ";
}
echo 'name="sent_on" value="1">
            &nbsp;',$str[115],"\n";
if (!$simple_dsp) {
    echo '            </td>
            <td valign="bottom">',"\n";
}
echo '-&gt;<select name="sent_folder">',"\n";
    hm_folder_options($current_sent, false, $simple_dsp, false);
echo '            </select>',"\n";
if (!$simple_dsp) {
    echo '            </td>
         </tr>
         <tr class="tables1">
            <td nowrap>',"\n";
}
else {
    echo '<br>';
}
/* trash folder */
echo '            &nbsp;<input type="checkbox" ';
if (isset($settings['trash_folder'])) {
    echo "CHECKED ";
}
echo 'name="trash_on" value="1">
            &nbsp;',$str[116],"\n";
if (!$simple_dsp) {
echo '            </td>
            <td valign="bottom">',"\n";
}
echo '-&gt;<select name="trash_folder">',"\n";
    hm_folder_options($current_trash, false, $simple_dsp, false);
echo '            </select>',"\n";
if (!$simple_dsp) {
    echo '            </td>
         </tr>
         <tr class="tables1">
            <td nowrap>',"\n";
}
else {
    echo '<br>';
}
/* drafts folder */

echo '            &nbsp;<input type="checkbox" ';
if (isset($settings['drafts_folder'])) {
    echo "CHECKED ";
}
echo 'name="drafts_on" value="1">
            &nbsp;',$str[117],"\n";
if (!$simple_dsp) {
echo '            </td>
            <td valign="bottom" nowrap>',"\n";
}
echo '-&gt;<select name="drafts_folder">',"\n";
    hm_folder_options($current_drafts, false, $simple_dsp, false);
echo '            </select>&nbsp;',"\n";

/* folder detail option */
$fold_styles = array (266 => 'nested', 267 => 'flat');
$fold_detail = array (292 => 'none', 268 => 'new', 269 => 'total');
if (!$simple_dsp) {
    echo '            </td>
         </tr>
         <tr>
            <td>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            ',$str[270],'
            </td>
            <td nowrap>
            &nbsp;&nbsp;&nbsp;<select name="folder_detail">',"\n";
    foreach ($fold_detail as $ind => $val) {
        echo '<option value="',$val,'" ';
        if (isset($settings['folder_detail']) && $settings['folder_detail'] == $val) {
            echo 'SELECTED ';
        }
        echo '>',$str[$ind],'</option>',"\n";
    }
    /* folder style */
    echo '            </select>&nbsp;&nbsp;
            </td>
         </tr>
         <tr>
            <td>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            ',$str[271],'
            </td>
            <td nowrap>
            &nbsp;&nbsp;&nbsp;<select name="folder_style">',"\n";
    foreach ($fold_styles as $ind => $val) {
        echo '<option value="',$val,'" ';
        if (isset($settings['folder_style']) && $settings['folder_style'] == $val) {
            echo 'SELECTED ';
        }
        echo '>',$str[$ind],'</option>',"\n";
    }
    /* folder preview */
    $folder_preview_opts = array('none' => $str[291], 3 => '3 '.$str[18], 5 =>
                           '5 '.$str[18], 7 => '7 '.$str[18], 9 => '9 '.$str[18],
                            11 => '11 '.$str[18], 13 => '13 '.$str[18]);
    echo '            </select>&nbsp;&nbsp;
            ',$opt_start,'
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            ',$str[275],':',"\n",
            $opt_mid,'
            &nbsp;&nbsp;&nbsp;<select name="folder_preview">';
    foreach ($folder_preview_opts as $opt => $val) {
        if (isset($settings['folder_preview']) && $settings['folder_preview'] == $opt) {
            echo '<option value="'.$opt.'" SELECTED>',$val,"</option>\n";
        }
        else {
            echo '<option value="'.$opt.'">',$val,"</option>\n";
        }
    }
    /* folder preview location */
    $fold_pos_opts = array('0' => $str[276], '1' => $str[277]);
    echo '</select>
            ',$opt_close,'
            ',$opt_start,'
            ',$opt_mid,'
            &nbsp;&nbsp;&nbsp;<select name="preview_position">';
    foreach ($fold_pos_opts as $opt => $val) {
        if (isset($settings['preview_position']) && 
            $settings['preview_position'] == $opt) {
            echo '<option value="'.$opt.'" SELECTED>',$val,"</option>\n";
        }
        else {
            echo '<option value="'.$opt.'">',$val,"</option>\n";
        }
    }
    echo '</select>
            </td>
         </tr>
      </table>
      </td>
   </tr>
   <tr>
      <td align="center">
      <input type="submit" class="button1" value="',$str[103],'" name="update">
      </td>
   <tr>
      <td>',"\n";
}

/* message listing order */
/*
if(!$simple_dsp) {
    echo '
      <table width="100%" align="center" cellpadding="1" cellspacing="1" class="tables1">
         <tr class="tables2">
            <td colspan="7" align="center">
            Message listing order
            </td>
         </tr>
         <tr><td></td>',"\n";
    for ($i=1;$i<7;$i++) {
        echo '            <td align="center">',$i,"</td>\n";
    }
    foreach ($positions as $val) {
        echo '
         <tr>
            <td>
            &nbsp;&nbsp;&nbsp;',$val,'
            </td>',"\n";
        for ($i=1;$i<7;$i++) {
            echo '            <td align="center">
            <input type="radio" ';
            if ($settings['pos_'.$i] == $val) {
                echo 'CHECKED';
            }
            echo ' value="',$val,'" name="pos_',$i,'">
            </td>',"\n";
        }
        echo '         </tr>',"\n";
    }
    echo '      </table>
      </td>
   </tr>',"\n";
}*/

/* profiles */
if (isset($config['disable_profiles']) && $config['disable_profiles'] == 'true') {
    $use_profiles = false;
    $current_count = 1;
}
else {
    $use_profiles = true;
}
if(!$simple_dsp) {
    for ($i=0;$i<$current_count;$i++) {
    $current_profile = $_SESSION['profiles'][$i];
    echo '   <tr>
      <td align="center" colspan="2">
      <table width="100%" cellpadding="2" cellspacing="1" class="tables1">',"\n";
        echo '         <tr class="tables2">
            <td colspan="2" align="center">',"\n";
                if ($i == 0) {
                    echo $str[100],"\n";
                }
                else {
                    echo $str[104],' ',($i+1);
                }
                echo '            </td>
         </tr>
         <tr>
            <td>
            &nbsp;
            </td>
         </tr>
         <tr>
            <td valign="top" align="center" height="1%">
            ',$str[93],':<br>
            <input type="text" name="from_name_'.$i.'" class="text2" size="28" ',
            'value="',$current_profile['from_name'],'">
            </td>
            <td align="center" rowspan="2">
            ',$str[102],':<br>
            <textarea cols="60" name="sig_',$i,'" class="composetext" rows="10">',
            $current_profile['sig'],'</textarea>
            </td>
         </tr>
         <tr>
            <td valign="top" align="center">',"\n";
        if ($use_profiles) {
        echo '            ',$str[101],':<br>
            <input type="text" name="from_address_',$i,'" class="text2" size="28" ',
            'value="',$current_profile['from_address'],'">
            <br><br><br><br>',"\n";
            if ($i == 0) {
                echo '            <input class="button1" type="submit" value="',$str[250],
                     '" name="add_profile">',"\n";
            }
            else {
                echo '<input class="button1" type="submit" value="',$str[251],
                     '" name="remove_profile_',$i,'">',"\n";
            }
        }
        echo '            </td>
         </tr>
         <tr>
            <td>
            &nbsp;
            </td>
         </tr>
      </table>
      </td>
   </tr>',"\n";
    }
    echo '   <tr>
      <td  align="center" colspan="2">
      <br><input type="submit" class="button1" value="',$str[103],'" name="update">
      </td>
   </tr>
</table>',"\n";
}
else {
    echo '<br><br>',$str[104],'<br>',"\n";
    for ($i=0;$i<$current_count;$i++) {
        $current_profile = $_SESSION['profiles'][$i];
        echo $str[93],': <input type="text" name="from_name_',$i,
             '" class="text2" size="28" value="',$current_profile['from_name'],
             '"><br> ',$str[101],': <input type="text" name="from_address_',
             $i,'" class="text2" size="28" value="',$current_profile['from_address'],
             '"><br>',$str[102],':<br><textarea cols="76" name="sig_',$i,
             '" class="composetext" ',
             'rows="10">',$current_profile['sig'],'</textarea><br>',"\n";
        if ($i == 0) {
            echo '            <input class="button1" type="submit" value="',
                 $str[250],'" ','name="add_profile"><br><br>',"\n";
        }
        else {
            echo '<input class="button1" type="submit" value="Remove Profile" name="remove_profile_',$i,'"><br><br>',"\n";
        }
    }
    echo '<input type="submit" class="button1" value="',$str[103],'" name="update">',"\n";
}
echo '</form>
</body>
</html>';

hm_imap_logout($imap_stream); 

?>
