<?php

/*  print_view.php: Clean view of a message part for printing
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: print_view.php,v 1.24 2004/03/25 19:11:08 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'print_view');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file)) {
    $config = $_SESSION['config'];
}
$hm_input['id'] = session_id();
$str = $_SESSION['str'];

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config,
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* get unseen status */
$unseen = hm_unseen_status($imap_stream, $_SESSION['folders']);

/* select the mailbox for imap */
hm_select_mailbox($imap_stream, $hm_input['mailbox']);

/* get message headers */
$message_headers = hm_get_full_header($imap_stream, $hm_input['uid'], false);

/* bail if the message is gone */
if (empty($message_headers)) {
    $_SESSION['notices'][] = $str[256].'<br>'.$str[218];
    header("Location: ".$config['hostname'].$config['install_path'].
       "mailbox.php?id=".$hm_input['id']."&mailbox=".$hm_input['mailbox']);
    exit;
}

/* get message structure */
$structure = hm_get_struct($imap_stream, $hm_input['uid']);

/* check for full message display on LARGE message parts */
if (isset($hm_input['big_text'])) {
    $cutoff = false;
}
else {
    $cutoff = true;
}

/* get the message and some info about it */
$results = &hm_find_display_part($imap_stream, $structure, $hm_input['uid'], 
                                    $hm_input['part'], false, false, $cutoff);
$hm_input['part']= $results[0];
$text_part = $results[1];
$decode = $results[2][0];
$type = $results[2][1];
$subtype = $results[2][2];
$dsp_type = $results[2][3];

/* set date format */
if (isset($_SESSION['settings']['date_string'])) {
    $date_string = $_SESSION['settings']['date_string'];
}
else {
    $date_string = 'g:i a, F j, Y';
}

/* charset info */
$code_page = false;
$charset_convert = false;
$charset = false;
if (isset($results[2][4]) && $results[2][4] && $str['charset'] == 'UTF-8') {
    $charset = strtolower($results[2][4]);
    if (isset($_SESSION['charsets'][$charset])) {
        $code_page = $_SESSION['charsets'][$charset];
        $charset_convert = true;
    }
}

/* full header views */
if (isset($hm_input['print_full']) && $hm_input['print_full'] == 'true') {
    $full = '&amp;full=yes';
}
else {
    $full = '';
}
if (isset($hm_input['print_part_full']) && $hm_input['print_part_full'] == 'true') {
    $part_full = '&amp;part_full=yes';
}
else {
    $part_full = '';
}

/* message header and body display */
echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>
      Print View
  </title>
  <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=',$str['charset'],'">
  <link rel="SHORTCUT ICON" href="../images/hastymail.ico">
</head>
<body>
<br>
<table align="center" width="80%">
   <tr>
      <td>
      <small><a href="message.php?id=',$hm_input['id'],
      '&amp;part=',$hm_input['part'],'&amp;uid=',$hm_input['uid'],
      '&amp;mailbox=',urlencode($hm_input['mailbox']),$full,$part_full,'">
      ',$str[91],'
      </a></small>
      </td>
   </tr>
</table>
<br>',"\n"; 

if (isset($hm_input['print_full'])) {
    echo "<table cellpadding=\"0\" cellspacing=\"0\">\n";
    foreach ($message_headers as $name => $val) {
        echo '
   <tr>
      <td align="right" valign="top">
      <small>',preg_replace("/_\d*$/", '', $name),':</small>
      </td> 
      <td>
      &nbsp;<small>',$val,'</small>
      </td> 
   </tr>',"\n";
    }
    echo "</table>\n";
}
else {
    if (isset($message_headers['subject']) && $message_headers['subject'] != '') {
        $subject = $message_headers['subject'];
    }
    else {
        $subject = $str[229];
    }
    if (isset($message_headers['date']) && $message_headers['date'] != '') {
        $date = date($date_string, (strtotime($message_headers['date'])));
    }
    else {
        $date = $str[231];
    }
    if (isset($message_headers['from']) && $message_headers['from'] != '') {
        $from = $message_headers['from'];
    }
    else {
        $from = $str[230];
    }
    if (isset($message_headers['to']) && $message_headers['to'] != '') {
        $to = $message_headers['to'];
    }
    else {
        $to = $str[232];
    }
    if (isset($message_headers['cc']) && $message_headers['cc'] != '') {
        $cc = $message_headers['cc'];
    }
    else {
        $cc = false;
    }
    echo '<table width="80%" align="center">
   <tr>
      <td>
      ',$str[21],':
      </td>
      <td>',
      $subject,'
      </td>
   </tr>
   <tr>
      <td>
      ',$str[23],':
      </td>
      <td>',
      $date,'
      </td>
   </tr>
   <tr>
      <td>
      ',$str[22],':
      </td>
      <td>',
      $from,'
      </td>
   </tr>
   <tr>
      <td>
      ',$str[25],':
      </td>
      <td>',
      $to,'
      </td>
   </tr>
</table>',"\n";
}

/* check for rfc header information on nested parts */
if (strstr($hm_input['part'], '.') && array_key_exists(1, $structure)) {
    $value = &hm_in_multi_array($hm_input['part'], $structure, array(), true); 
    $part_headers = hm_get_full_header($imap_stream, $hm_input['uid'], $value[0]);
    if (isset($hm_input['print_part_full']) && $hm_input['print_part_full'] == 'true') { 
        $part_full_view = 'yes';
        echo '<table width="80%" align="center">',"\n";
        foreach ($part_headers as $key => $value) {
            echo '     <tr>
     <td>
        <small>&nbsp;',hm_htmlize($key),': ',
        hm_htmlize($value),'</small>
     </td>
   </tr>',"\n";
        }
echo '</table>',"\n";
    }
    else {
    /* rfc message headers */
        if (is_array($part_headers)) {
        $feilds = array ('subject', 'from', 'date');
        foreach($feilds as $feild) {
            if (!isset($part_headers[$feild]) || $part_headers[$feild] == 'nil' ||
                $part_headers[$feild] == 'NIL' || $part_headers[$feild] == '') {
                $part_headers[$feild] = '';
            }
            $part_headers[$feild] = hm_special_chars($part_headers[$feild],
                                    $str['charset'], $charset_convert, $code_page);
            } 
        echo '<br><table width="80%" align="center">
       <tr>
          <td>
          ',$str[21],':
          </td>
          <td>
          ',$part_headers['subject'],'</small>
          </td>
      </tr>
      <tr>
          <td>
          ',$str[23],':
          </td>
          <td>
          ',hm_htmlize(stripslashes(date($date_string, (
                   strtotime($part_headers['date']))))),'
          </td>
      </tr>
       <tr>
          <td>
          ',$str[22],':
          </td>
          <td>
          ',$part_headers['from'],'
          </td>
      </tr>
    </table>',"\n";
        }
    }
}

/* if the selected message part is an image we can display */
if (substr($dsp_type, 0, 5) == 'image') {
    echo '      <br><center><img src="download.php?id=',$hm_input['id'],
         '&amp;mailbox=',$hm_input['mailbox'],
         '&amp;uid=',$hm_input['uid'],
         '&amp;part=',$hm_input['part'],
         '&amp;decode=',$decode,
         '&amp;type=',$type,
         '&amp;subtype=',$subtype,
         '&amp;name=',$_GET['name'],'" alt="',$_GET['name'],'"></center><br>',"\n";
}

/* if the selected part is an HTML part */
elseif ($dsp_type == 'texthtml') {
    require_once('../filter/filter.php');
    if (isset($_SESSION['settings']['filter_level']) &&
        $_SESSION['settings']['filter_level'] == 'less') {
        $clean = hm_filter_html($text_part, 'less');
    }
    else {
        $clean = hm_filter_html($text_part);
    }

    /* if no html tags are found in the message aside from the 
       start and stop sanitized html tags inserted by the filter
       then format this as a text part and display as text */

    if (substr_count($clean, "<") < 3) {
        $clean = hm_text_cleanup($text_part);
        $clean = "\n<pre>\n".$clean."\n</pre>\n";
    } 
    echo '      <table width="80%" align="center">
         <tr>
             <td>
             ',$clean,'<br>
             </td>
         </tr>
      </table>',"\n";
}

/* if the selected part is a text part */
elseif ($dsp_type == 'textplain')  {
    $text_part = hm_special_chars($text_part, $str['charset'], $charset_convert,
                                  $code_page);
    echo '     <table width="80%" align="center">
         <tr>
            <td>
            <pre>
            ',$text_part,'
            </pre>
            </td>
         </tr>
      </table>',"\n";
}

/* hmm... not displayable */
else {
    echo '      <table width="97%" align="center">
         <tr>
            <td>
            </td>
         </tr>
      </table>',"\n";
}


echo '
<br><br>
<table align="center" width="80%">
   <tr>
      <td>
      <small><a href="message.php?id=',$hm_input['id'],
      '&amp;part=',$hm_input['part'],'&amp;uid=',$hm_input['uid'],
      '&amp;mailbox=',urlencode($hm_input['mailbox']),$full,$part_full,'">
      ',$str[91],'
      </a></small>
      </td>
   </tr>
</table>
</body>
</html>',"\n";


hm_imap_logout($imap_stream); 

?>
