<?php

/* redirect.php:  Called from the toolbar to direct the user and from the
                  login page to check the username/password.

    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

*
* $Id: redirect.php,v 1.38 2003/12/26 07:43:08 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, array(), 'redirect');

/* reroute the page depending on how we arrived */

if (isset($hm_input['uid'])) {
    $uid = '&uid='.$hm_input['uid'];
}
else {
    $uid = '';
}

/* Logout */
if (isset($hm_input['logout'])) {
    header("Location: ".$hm_input['hostname'].$hm_input['install_path'].
           "logout.php?id=".$hm_input['id']);
    exit;
}

/* folders page */
elseif (isset($hm_input['folders'])) {
    header("Location: ".$hm_input['hostname'].$hm_input['install_path'].
           "folders.php?id=".$hm_input['id']."&mailbox=".$hm_input['mailbox'].$uid);
    exit;
}

/* new mail page */
elseif (isset($hm_input['new'])) {
    header("Location: ".$hm_input['hostname'].$hm_input['install_path'].
           "new.php?id=".$hm_input['id']."&mailbox=".$hm_input['mailbox'].$uid);
    exit;
}

/* search page */
elseif (isset($hm_input['search'])) {
    header("Location: ".$hm_input['hostname'].$hm_input['install_path'].
           "search.php?id=".$hm_input['id']."&mailbox=".$hm_input['mailbox'].$uid);
    exit;
}

/* compose page */
elseif (isset($hm_input['compose'])) {
    header("Location: ".$hm_input['hostname'].$hm_input['install_path'].
           "compose.php?new=1&id=".$hm_input['id']."&mailbox=".$hm_input['mailbox'].$uid);
    exit;
}

/* options page */
elseif (isset($hm_input['options'])) {
    header("Location: ".$hm_input['hostname'].$hm_input['install_path'].
           "options.php?id=".$hm_input['id']."&mailbox=".$hm_input['mailbox'].$uid);
    exit;
}

/* contacts page */
elseif (isset($hm_input['contacts'])) {
    header("Location: ".$hm_input['hostname'].$hm_input['install_path'].
           "contacts.php?id=".$hm_input['id']."&mailbox=".$hm_input['mailbox'].$uid);
    exit;
}

/* any other */
else {
    header("Location: ".$hm_input['hostname'].$hm_input['install_path'].
           "logout.php");
    exit;
}

?>
