<?php

/* search.php: Interface for searching mailboxes
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: search.php,v 1.78.2.1 2004/05/11 04:41:02 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'search');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file)) {
    $config = $_SESSION['config'];
}
$hm_input['id'] = session_id();
$str = $_SESSION['str'];

if (isset($hm_input['destination'])) {
    $dest = $hm_input['destination'];
}
elseif (isset($_SESSION['move_to_destination'])) {
    $dest = $_SESSION['move_to_destination'];
}
else {
    $dest = 'INBOX';
}
$_SESSION['move_to_destination'] = $dest;

if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 'true')
   || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 'true')) {
    $simple = $_SESSION['settings']['simple'];
}
else {
    $simple = false;
}

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config,
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* do message control actions */
$action = false;
switch (true) {
    case isset($hm_input['move']):
        $action = 'move';
        break;
    case isset($hm_input['sort']):
        $action = 'sort';
        break;
    case isset($hm_input['delete']):
        $action = 'delete';
        break;
    case isset($hm_input['read']):
        $action = 'read';
        break;
    case isset($hm_input['unread']):
        $action = 'unread';
        break;
    case isset($hm_input['copy']):
        $action = 'copy';
        break;
    default:
        break;
}
if ($action) {
    if ($hm_input['selection_type'] == 'page') {
        $sel = false;
        $array = $_SESSION['search_info'];
    }
    elseif ($hm_input['selection_type'] == 'marked') {
        $array = $_POST;
        $sel = true;
    }
    elseif (isset($hm_input['selection_type'])) {
        if (isset($_SESSION['search_info']) && 
            array_key_exists($hm_input['selection_type'], $_SESSION['search_info'])) {
            $array = array($hm_input['selection_type'] => 
                           $_SESSION['search_info'][$hm_input['selection_type']]);
            $sel = false;
        }
    }
    foreach ($array as $name => $value) {
            if ($sel) {
                $name = base64_decode($name);
            }
        if (substr($name, 0, 5) == 'fold_' || !$sel) {
            if ($sel) {
                $fold = substr($name, 5);
            }
            else {
                $fold = $name;
            }
            $dsp_count = count($value);
            if ($dsp_count > 1) {
                $dsp_end = $str[18];
            }
            else {
                $dsp_end = $str[26];
            }
            $dest = false;
            if (isset($hm_input['destination'])) {
                $dest = $hm_input['destination'];
            }
            if ($sel) {    
                $uid_string = $value[0];
                if ($dsp_count > 1) {
                    $uid_string = implode(',', $value);
                }
            }
            else {
                $uids = array_keys($value);
                $uid_string = $uids[0]; 
                if ($dsp_count > 1) {
                    $uid_string = implode(',', $uids);
                }
            }
            hm_select_mailbox($imap_stream, $fold);
            $result = hm_message_controls ($action, $imap_stream,
                                           $uid_string, $dest, false, false, $fold, 
                                           $dsp_count, $dsp_end);
        }
    }
    $hm_input['update'] = 1;        
}

/* get unseen messages */
$unseen = hm_unseen_status ($imap_stream, $_SESSION['folders']);

/* check the session and reset buttons */
if (isset($hm_input['reset'])) {
    if (isset($_SESSION['search_params'])) {
        $_SESSION['search_params'] = array();
        unset($_SESSION['search_params']);
        unset($_SESSION['search_info']);
    }
    foreach($hm_input as $key => $value) {
        if (substr($key, 0, 4) == 'FLAG') {
            unset($hm_input[$key]);
        }
    }
}

$new_search = false;
$old_search = false;

/* execute the submitted search */
if (isset($hm_input['update']) || isset($hm_input['search'])) {

    $range_type  = $hm_input['range_type'];
    $day         = $hm_input['day'];
    $month       = $hm_input['month'];
    $year        = $hm_input['year'];
    $size        = $hm_input['size'];
    $size_unit   = $hm_input['size_unit'];
    $search_part = $hm_input['search_part'];
    $sstring     = $hm_input['sstring'];
    $size_type   = $hm_input['size_type'];
    $search_folder = array();
    $_SESSION['search_params'] = $hm_input;
    unset($_SESSION['search_params']['mailbox']);
    unset($_SESSION['search_params']['id']);
    $date_string = '';
    $size_string = '';
    $flag_string = '';

        /* check which folders to search */
        $search_folder = array();
        if (!isset($hm_input['search_folders'])) {
            $search_folder[] = 'INBOX';
        }
        elseif (is_array($hm_input['search_folders']) && 
                !empty($hm_input['search_folders'])) {
            $search_folder = $hm_input['search_folders'];
        }
        else {
            $search_folder[] = 'INBOX';
        }
        $_SESSION['search_params']['search_folder'] = $search_folder;
    
        /* size options */
        if (isset($hm_input['size_type']) && $hm_input['size_type'] != 'any'
            && isset($hm_input['size']) && $hm_input['size'] > 0) {
            $size_string = $hm_input['size_type'].' ';
            switch ($hm_input['size_unit']) {
                case 'b':
                    $size_string .= $hm_input['size'];
                    break;
                case 'k';
                    $size_string .= $hm_input['size']*1024;
                    break;
                case 'm';
                    $size_string .= $hm_input['size']*1048576;
                    break;
            }
        }
    
        /* date range options */
        if (isset($hm_input['range_type']) && $hm_input['range_type'] != 'any') {
            $date_string = $hm_input['range_type'].' '.$hm_input['day'].'-'.
                           $hm_input['month'].'-'.$hm_input['year'];    
        }
    
        /* look for flag options */
        foreach ($hm_input as $key => $val) {
            if (substr($key, 0, 4) == 'FLAG') {
                $flag_string .= substr($key, 5).' ';
            }
        }
        $flag_string = rtrim($flag_string);
        if (isset($hm_input['sstring']) && $hm_input['sstring'] != '') {
            $spart = $hm_input['search_part'];
            $string = $hm_input['sstring'];
        }
        else {
            $spart = '';
            $string = false;
        }
        $search_string = 'SEARCH '.$flag_string.' '.$date_string.' '.$size_string.' '
                         .$spart;
        $search_string = preg_replace("/\s{2,}/", ' ', $search_string);
        if (rtrim($search_string) == 'SEARCH') {
            $search_string .= 'ALL';
        }
        $data = array();
        $f_cnt = 0;
        $ht_cnt = 0;
        
        /* perform search and get headers for resulting UIDs */
        foreach($search_folder as $sf) {
            $f_cnt++;
            hm_select_mailbox($imap_stream, $sf);
            $uids = hm_search_mailbox($imap_stream, $search_string, $string);
            $uids = str_replace(' ', ',', trim($uids));
            $headers = &hm_get_messages($uids, $imap_stream);
            if (!empty($headers)) {
                $ht_cnt += count($headers);
                uasort($headers, "hm_date_cmp");
                $data[$sf] = $headers;
            }
        }
    
        /* save search in session */
        $_SESSION['search_info'] = $data;
        $_SESSION['search_params']['search_string'] = $search_string;
        $_SESSION['search_params']['ht_cnt'] = $ht_cnt;
        $_SESSION['search_params']['f_cnt'] = $f_cnt;
        $new_search = true;
}

/* reload previous search */
elseif (isset($_SESSION['search_params']) && !empty($_SESSION['search_params']) &&
        isset($_SESSION['search_info'])) {
    foreach ($_SESSION['search_params'] as $key => $value) {
        if (substr($key, 0, 4) == 'FLAG') {
            $hm_input[$key] = $value;
        }
    }
    $range_type    = $_SESSION['search_params']['range_type'];
    $day           = $_SESSION['search_params']['day'];
    $month         = $_SESSION['search_params']['month'];
    $year          = $_SESSION['search_params']['year'];
    $size          = $_SESSION['search_params']['size'];
    $size_unit     = $_SESSION['search_params']['size_unit'];
    $search_part   = $_SESSION['search_params']['search_part'];
    $sstring       = $_SESSION['search_params']['sstring'];
    $size_type     = $_SESSION['search_params']['size_type'];
    $search_folder = $_SESSION['search_params']['search_folder'];
    $data          = $_SESSION['search_info'];
    $search_string = $_SESSION['search_params']['search_string'];
    $ht_cnt        = $_SESSION['search_params']['ht_cnt'];
    $f_cnt         = $_SESSION['search_params']['f_cnt'];
    $old_search    = true;
}
else {
    $range_type  = 'any';
    $day         = '1'; 
    $month       = 'Jan';
    $year        = '1970';
    $size        = '';
    $size_unit   = 'b';
    $search_part = 'TEXT';
    $sstring     = '';
    $size_type   = 'any';
    $search_folder = array();
}

/* check for missing folders */
hm_check_folders($imap_stream);

/* toolbar */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, $str[11]);

/* search results */
echo '<form action="search.php" method="post">',"\n";
if ($new_search || $old_search) {
    echo '<br>
<table align="center" width="98%" class="tables4" cellpadding="1" cellspacing="1">',"\n";
    if ($old_search) {
        echo '   <tr class="tables2">
      <td colspan="3" nowrap>
      <font class="font2">
      <small>&nbsp;',$str[90],'</small>
      </font>
      </td>
   </tr>',"\n";
    }

    /* summary */
    echo '   <tr>
      <td nowrap width="1%">
      &nbsp;<small><b>',$str[63],'&nbsp;&nbsp;</b></small>
      <small>',$search_string,' ',hm_htmlize($sstring),
     '&nbsp;</small>
      &nbsp;<small><b>',$str[64],'&nbsp;&nbsp;</b></small>
      <small>',$ht_cnt,'</small>
      &nbsp;<small><b>',$str[65],'&nbsp;&nbsp;</b></small>
      <small>',$f_cnt,'</small>
      </td>
   </tr>
   <tr>
      <td>
      </td>
   </tr>
</table>
<br>',"\n";

    /* message controls */
    $t_all = false;
    if (isset($hm_input['toggle_all'])) {
        $t_all = true;
    }
    if (count($data) > 0) {
        echo '<table width="98%" align="center" cellpadding="4" cellspacing="4">
   <tr>
      <td nowrap class="tables2">
      &nbsp;<input type="submit" class="button1" value="',$str[61],'" name="update">
      &nbsp;<input type="submit" class="button1" value="',$str[60],'" name="reset">
      </td>
      <td colspan="2" nowrap align="right" class="tables2">
      <input class="button3" type="submit" name="toggle_all" ', 
         'value="',$str[246],'">&nbsp;&nbsp;
      <input type="hidden" name="id" value="',$hm_input['id'],'">
      <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">
      &nbsp;&nbsp;<select name="selection_type" class="select3">
          <option class="option3" value="marked">',$str[6],'</option>';
    if (!empty($data)) {
        $fold_tmp = array_keys($data);
        $fold_tmp_dsp = hm_folder_dsp($fold_tmp);
        foreach ($fold_tmp as $val) {
            echo '<option class="option3" value="',$val,'">',$str[51],' ',
                 $fold_tmp_dsp[$val],'</option>',"\n";
        }
    }
    echo '          <option class="option3" value="page">',$str[52],'</option>
      </select>&nbsp;
      <input type="submit" class="button3" name="read" value="',$str[2],'">
      <input type="submit" class="button3" name="unread" value="',$str[3],'">
      <input type="submit" class="button3" name="delete" value="',$str[4],'">
      &nbsp;<input type="submit" class="button3" name="copy" value="',$str[1],'">-<input type="submit" class="button3" name="move" value="',$str[0],'">-&gt;
      <select class="select3" name="destination">',"\n";
    hm_folder_options($dest, false, $simple, false, 'class="option3"');
    echo '      </select>&nbsp;&nbsp;
      </td>
   </tr>
   <tr>
      <td>
      </td>
   </tr>
</table>
<table width="98%" align="center" cellpadding="4" cellspacing="4">
   <tr>
      <td class="tables1">
<table width="99%" align="center" cellpadding="1" cellspacing="0" class="tables5">
   <tr class="tables1">',"\n";
    hm_start_message_listing($hm_input['mailbox']);
    echo '   </tr>',"\n";
    if (isset($_SESSION['nn4_warning'])) {
        echo '<tr><td></td><td></td><td class="tables1">
              <img src="../images/trans.gif" width="350" height="1"></td></tr>';
    }

    /* loop through folders with search results */
    foreach($data as $folder => $uid_array) {
        echo '
   <tr>
      <td colspan="7">
      <table cellpadding="1" cellspacing="0" width="100%">
         <tr class="tables2">
            <td width="1%" nowrap>
            &nbsp;
            <font class="font2">
            &nbsp;',count($uid_array),'&nbsp;
            </font>
            </td>
            <td>
            <a class="font2" href="mailbox.php?mailbox=',urlencode($folder),
            '&amp;id=',$hm_input['id'],'">
            <b>',hm_htmlize($_SESSION['dsp_folders'][$folder]),'</b>
            </a>
            </td>
         </tr>
      </table>
      </td>
   </tr>',"\n";
        $chk_folder = base64_encode('fold_'.$folder);

        /* get search result message data */
        foreach ($uid_array as $uid => $headers) {
            $current = false;
            if (isset($hm_input['uid']) && $hm_input['uid'] == $uid) {
                $current = true;
            }
            hm_print_row($headers, $simple, $t_all, $folder, $hm_input['id'], $uid,
                         array(), true, $chk_folder, true, false, $current);
        }
    }
        echo '         <tr>
            <td class="tables1" colspan="7">
            &nbsp;
            </td>
         </tr>
      </table>
      </td>
   </tr>
</table>';
    }
    else {
        echo '<br><table align="center" class="tables4">
   <tr>
      <td align="center">
      <font class="font2"><small>
      No messages found that match your search
      </small></font>
      </td>
   </tr>
</table>';
    }
}

/* search form */
$months = $str['months'];
echo '<br>
<input type="hidden" name="id" value="',$hm_input['id'],'">
<input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">
<table class="tables5" cellpadding="4" cellspacing="4" align="center">
   <tr>
      <td rowspan="3">
      <table class="tables1" width="99%" cellspacing="1" cellpadding="2">
         <tr class="tables2">
            <td align="center">
            ',$str[55],'
            </td>
         </tr> 
         <tr>
            <td>
            <br>
            </td>
         </tr>
         <tr>
            <td nowrap align="center">
            &nbsp;&nbsp;<select name="search_folders[]" multiple size="20">',"\n";
    hm_folder_options($search_folder, false, $simple, false);
    echo '                  </select>&nbsp;&nbsp;
            </td>
         </tr>
         <tr>
            <td>
            <br>
            </td>
         </tr>
      </table> 
      </td>
      <td valign="top" height="10%">
      <table class="tables1" width="99%" cellspacing="1" cellpadding="2">
         <tr class="tables2">
            <td align="center" colspan="4">
            ',$str[56],'
            </td>
         </tr> 
         <tr>
            <td>
            <br>
            </td>
         </tr>
         <tr>
            <td nowrap>
            &nbsp;&nbsp;<small>',$str[289],'</small>
            </td>
            <td colspan="3">
            <small>',$str[23],'</small>
            </td>
         </tr> 
         <tr>
            <td nowrap>
            &nbsp;
            <select name="range_type">
               <option ';
if ($range_type == 'any') {
    echo 'SELECTED ';
}
echo 'value="any">',$str[76],'</option>
               <option ';
if ($range_type == 'SENTBEFORE') {
    echo 'SELECTED ';
}
echo 'value="SENTBEFORE">',$str[77],'</option>
               <option ';
if ($range_type == 'SENTSINCE') {
    echo 'SELECTED ';
}
echo 'value="SENTSINCE">',$str[78],'</option>
               <option ';
if ($range_type == 'SENTON') {
    echo 'SELECTED ';
}
echo 'value="SENTON">',$str[79],'</option>
            </select>
            &nbsp;&nbsp;
            </td>
            <td>
               <select name="month">',"\n";
foreach ($months as $key => $val) {
    echo '             <option ';
    if ($key == $month) {
        echo 'SELECTED ';
    }
    echo 'value="',$key,'">',$val,"</option>\n";
}
echo '                </select>
            </td>
            <td>
               <select name="day">',"\n";
for ($i=1;$i<32;$i++) {
    echo '            <option ';
    if ($i == $day) {
        echo 'SELECTED ';
    }
    echo 'value="',$i,'">',$i,"</option>\n";
} 
echo '               </select>
            </td>
            <td nowrap>
               <select name="year">',"\n";
for ($i=1970;$i<2010;$i++) {
    echo '            <option ';
    if ($i == $year) {
        echo 'SELECTED ';
    }
    echo ' value="',$i,'">',$i,"</option>\n";
} 
echo '               </select>
            &nbsp;
            </td>
         </tr>
         <tr>
            <td>
            <br>
            </td>
         </tr>
      </table>
      </td>
      <td valign="top" rowspan="2">
      <table class="tables1" width="99%" cellspacing="1" cellpadding="2">
         <tr class="tables2">
            <td align="center" colspan="2">
            ',$str[57],'
            </td>
         </tr> 
         <tr>
            <td>
            <br>
            </td>
         </tr>
         <tr>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_ANSWERED'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_ANSWERED">&nbsp;',$str[67],'
            </td>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_UNANSWERED'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_UNANSWERED">&nbsp;',$str[68],'
            </td>
         </tr> 
         <tr>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_SEEN'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_SEEN">&nbsp;',$str[2],'
            </td>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_UNSEEN'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_UNSEEN">&nbsp;',$str[3],'
            </td>
         </tr> 
         <tr>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_DELETED'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_DELETED">&nbsp;',$str[89],'
            </td>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_UNDELETED'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_UNDELETED">&nbsp;',$str[70],'
            </td>
         </tr> 
         <tr>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_FLAGGED'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_FLAGGED">&nbsp;',$str[71],'
            </td>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_UNFLAGGED'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_UNFLAGGED">&nbsp;',$str[72],'
            </td>
         </tr> 
         <tr>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_DRAFT'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_DRAFT">&nbsp;',$str[69],'
            </td>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_UNDRAFT'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_UNDRAFT">&nbsp;',$str[73],'
            </td>
         </tr> 
         <tr>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_RECENT'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_RECENT">&nbsp;',$str[74],'
            </td>
            <td nowrap>
            <input type="checkbox" ';
if (isset($hm_input['FLAG_OLD'])) {
    echo 'CHECKED ';
}
echo 'name="FLAG_OLD">&nbsp;',$str[75],'
            </td>
         </tr> 
         <tr>
            <td>
            <br>
            </td>
         </tr>
      </table>
      </td>
   </tr>
   <tr>
      <td valign="top" height="10%">
      <table class="tables1" width="99%" cellspacing="1" cellpadding="2">
         <tr class="tables2">
            <td align="center" colspan="3">
            ',$str[24],'
            </td>
         </tr> 
         <tr>
            <td nowrap>
            &nbsp;&nbsp;<small>',$str[290],'</small>
            </td>
            <td nowrap>
            &nbsp;<small>',$str[24],'</small>
            </td>
         </tr>
         <tr>
            <td>
            &nbsp;
            <select name="size_type">
               <option ';
if ($size_type == 'any') {
    echo 'SELECTED ';
}
echo 'value="any">',$str[76],'</option>
               <option ';
if ($size_type == 'SMALLER') {
    echo 'SELECTED ';
}
echo 'value="SMALLER">',$str[80],'</option>
               <option ';
if ($size_type == 'LARGER') {
    echo 'SELECTED ';
}
echo 'value="LARGER">',$str[81],'</option>
            </select>
            </td>
            <td>
            &nbsp;<input type="text" size="10" class="text2" name="size" value="',
            hm_htmlize($size),'">&nbsp;
            </td>
            <td>
            <select name="size_unit">
               <option ';
if ($size_unit == 'b') {
    echo 'SELECTED ';
}
echo 'value="b">',$str[82],'</option>
               <option ';
if ($size_unit == 'k') {
    echo 'SELECTED ';
}
echo 'value="k">',$str[83],'</option>
               <option ';
if ($size_unit == 'm') {
    echo 'SELECTED ';
}
echo 'value="m">',$str[84],'</option>
            </select>
            </td>
         </tr> 
         <tr>
            <td>
            <br>
            </td>
         </tr>
      </table>
      </td>
   </tr>
   <tr>
      <td nowrap colspan="2" valign="top">
      <table>
         <tr>
            <td rowspan="2" valign="top">
            <table class="tables1" cellspacing="1" cellpadding="2">
               <tr class="tables2">
                  <td valign="top" align="center">
                  ',$str[58],'
                  </td>
               </tr> 
               <tr>
                  <td>
                  <br>
                  </td>
               </tr>
               <tr>
                  <td nowrap>
                  &nbsp;';
if (isset($config['simple_search']) && $config['simple_search'] == 'true') {
    echo '                  <input type="text" class="text2" name="sstring" size="50" ',
         'value ="',hm_htmlize($sstring),'">';
}
else {
    echo '                  <textarea cols="60" name="sstring" class="text2" rows="4">',
                  hm_htmlize($sstring),'</textarea>';
}
echo '
                  &nbsp;
                  </td>
               </tr> 
               <tr>
                  <td>
                  <br>
                  <br>
                  </td>
               </tr>
            </table>
            </td>
            <td rowspan="2">
            &nbsp;
            </td>
            <td valign="top" nowrap height="5%">
            <table class="tables1" cellspacing="1" cellpadding="2">
               <tr class="tables2">
                  <td align="center">
                  ',$str[59],'
                  </td>
               </tr> 
               <tr>
                  <td>
                  <br>
                  </td>
               </tr>
               <tr>
                  <td align="center" nowrap>
                  &nbsp;
                  <select name="search_part">
                     <option ';
if ($search_part == 'TEXT') {
    echo 'SELECTED ';
}
echo 'value="TEXT">',$str[85],'</option>
                     <option ';
if ($search_part == 'FROM') {
    echo 'SELECTED ';
}
echo 'value="FROM">',$str[22],'</option>
                     <option ';
if ($search_part == 'TO') {
    echo 'SELECTED ';
}
echo 'value="TO">',$str[25],'</option>
                     <option ';
if ($search_part == 'CC') {
    echo 'SELECTED ';
}
echo 'value="CC">',$str[87],'</option>
                     <option ';
if ($search_part == 'BCC') {
    echo 'SELECTED ';
}
echo 'value="BCC">',$str[88],'</option>
                     <option ';
if ($search_part == 'SUBJECT') {
    echo 'SELECTED ';
}
echo 'value="SUBJECT">',$str[21],'</option>
                     <option ';
if ($search_part == 'BODY') {
    echo 'SELECTED ';
}
echo 'value="BODY">',$str[86],'</option>
                  </select>
                  &nbsp;
                  </td>
               </tr> 
               <tr>
                  <td>
                  <br>
                  </td>
               </tr>
            </table>
            </td>
         </tr>
         <tr>
            <td align="center">
            <br>
            &nbsp;<input type="submit" class="button1" value="',$str[11],'" name="search">
            <br><br>
            &nbsp;<input type="submit" class="button1" value="',$str[60],'" name="reset">
            </td>
         </tr>
      </table>
      </td>
   </tr>
</table>
</form>',"\n";

echo '</body>
</html>';

hm_imap_logout($imap_stream); 

?>
